/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.TabbedPaneUI;
import oracle.ide.inspector.AbstractAdditionalPage;
import oracle.ide.inspector.AbstractPropertyInspectorPanel;
import oracle.ide.inspector.CategoryCollection;
import oracle.ide.inspector.CategoryCollectionDisplay;
import oracle.ide.inspector.Orientation;
import oracle.ide.inspector.Properties;
import oracle.ide.inspector.PropertyCategoryPanel;
import oracle.ide.inspector.PropertyCategoryPanelHelper;
import oracle.ide.inspector.UserSelectedCategories;
import oracle.ide.model.Displayable;
import oracle.javatools.ui.plaf.FlatTabbedPaneUI;
import oracle.javatools.util.ModelUtil;

abstract class CategoryTabbedPane
extends JTabbedPane
implements CategoryCollection {
    private static final String NO_SELECTED_CATEGORY = "";
    private int currentTabIndex;
    private String currentCategory;
    private static final int NO_ADDITIONAL_PAGES = -1;
    private int firstAdditionalPageIndex = -1;
    private Component[] additionalPages;
    private final List<PropertyCategoryPanel> categoryPanels = new ArrayList<PropertyCategoryPanel>();
    private PropertyCategoryPanelHelper categoryPanelHelper = new PropertyCategoryPanelHelper();
    final CategoryCollectionDisplay categoryCollectionDisplay;
    final UserSelectedCategories userSelectedCategories;
    private boolean cleaningUp;
    private static final String[] EMPTY_LIST = new String[0];

    @Override
    public List<PropertyCategoryPanel> categoryPanels() {
        return new ArrayList<PropertyCategoryPanel>(this.categoryPanels);
    }

    public CategoryTabbedPane(CategoryCollectionDisplay categoryCollectionDisplay) {
        this.categoryCollectionDisplay = categoryCollectionDisplay;
        this.userSelectedCategories = categoryCollectionDisplay.userSelectedCategories();
        this.setUI((TabbedPaneUI)new FlatTabbedPaneUI());
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (e.getSource() != CategoryTabbedPane.this) {
                    return;
                }
                CategoryTabbedPane.this.checkIfCategoryTabChanged();
            }
        });
    }

    private void checkIfCategoryTabChanged() {
        if (this.getTabCount() == 0) {
            return;
        }
        int selectedTabIndex = this.getSelectedIndex();
        if (selectedTabIndex == this.currentTabIndex) {
            return;
        }
        if (selectedTabIndex < 0) {
            selectedTabIndex = 0;
        }
        this.currentTabIndex = selectedTabIndex;
        this.updateCurrentCategoryFromTabs();
        this.categorySelectionChanged(this.selectedPropertyCategoryPanel());
        if (!this.cleaningUp) {
            this.userSelectedCategories.userSelected(this.getTitleAt(selectedTabIndex));
        }
    }

    @Override
    public final JComponent gui() {
        return this;
    }

    final String updateCategoryFromCurrentTab() {
        if (this.getTabCount() == 0) {
            return null;
        }
        int selectedTabIndex = this.getSelectedIndex();
        if (selectedTabIndex < 0) {
            selectedTabIndex = 0;
        }
        this.currentTabIndex = selectedTabIndex;
        this.updateCurrentCategoryFromTabs();
        return this.currentCategory;
    }

    private void updateCurrentCategoryFromTabs() {
        this.currentCategory = this.getTitleAt(this.currentTabIndex);
    }

    @Override
    public final void clearCurrentCategory() {
        this.currentCategory(null);
    }

    @Override
    public final void currentCategory(String newValue) {
        this.currentCategory = newValue;
        this.currentCategoryUpdated(this.currentCategory);
    }

    @Override
    public final String currentCategory() {
        return this.currentCategory;
    }

    @Override
    public final String selectedCategoryName() {
        if (this.getTabCount() == 0) {
            return NO_SELECTED_CATEGORY;
        }
        int index = this.getSelectedIndex();
        return index > -1 ? this.getTitleAt(index) : NO_SELECTED_CATEGORY;
    }

    @Override
    public final void selectedCategoryName(String categoryName) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            String title = this.getTitleAt(i);
            if (!ModelUtil.areEqual((Object)categoryName, (Object)title)) continue;
            this.setSelectedIndex(i);
            break;
        }
    }

    PropertyCategoryPanel selectedPropertyCategoryPanel() {
        Component c = this.getSelectedComponent();
        if (!(c instanceof Container)) {
            return null;
        }
        return this.propertyCategoryPanelFrom((Container)c);
    }

    private PropertyCategoryPanel propertyCategoryPanelFrom(Container container) {
        for (Component c : container.getComponents()) {
            if (c instanceof PropertyCategoryPanel) {
                return (PropertyCategoryPanel)((Object)c);
            }
            if (!(c instanceof Container)) continue;
            return this.propertyCategoryPanelFrom((Container)c);
        }
        return null;
    }

    @Override
    public final void additionalTabPages(Component[] additionalPages) {
        this.removeAdditionalPages();
        this.additionalPages = additionalPages;
        if (additionalPages == null || additionalPages.length == 0) {
            return;
        }
        for (Component page : additionalPages) {
            if (!(page instanceof JComponent)) continue;
            if (page instanceof AbstractAdditionalPage) {
                AbstractAdditionalPage additionalPage = (AbstractAdditionalPage)page;
                additionalPage.render(Orientation.HORIZONTAL);
            }
            this.addCategoryPanel(this.labelFromPage(page), (JComponent)page);
        }
        this.firstAdditionalPageIndex = this.getTabCount() - 1;
    }

    @Override
    public Component[] additionalPages() {
        return this.additionalPages;
    }

    @Override
    public final void removeAdditionalPages() {
        if (this.firstAdditionalPageIndex == -1) {
            return;
        }
        for (int i = this.firstAdditionalPageIndex; i < this.getTabCount(); ++i) {
            this.removeTabAt(i);
        }
        this.firstAdditionalPageIndex = -1;
    }

    private String labelFromPage(Component page) {
        if (page instanceof Displayable) {
            return ((Displayable)page).getShortLabel();
        }
        return page.getName();
    }

    @Override
    public final void addCategory(PropertyCategoryPanel categoryPanelSource, Properties properties) {
        String title = categoryPanelSource.categoryTitle();
        JComponent categoryPanel = categoryPanelSource.categoryPanel();
        this.addCategoryPanel(title, categoryPanel);
        this.selectIfNecessary(categoryPanelSource, properties);
        this.categoryPanels.add(categoryPanelSource);
    }

    private void addCategoryPanel(String title, JComponent categoryPanel) {
        Color background = this.getBackground();
        categoryPanel.setBackground(background);
        categoryPanel.setBorder(BorderFactory.createEmptyBorder(5, 8, 5, 8));
        JScrollPane scrollPane = new JScrollPane(categoryPanel);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        scrollPane.setBackground(background);
        scrollPane.getViewport().setOpaque(false);
        this.addTab(title, scrollPane);
    }

    private void selectIfNecessary(PropertyCategoryPanel categoryPanelSource, Properties properties) {
        int lastAddedIndex = this.getTabCount() - 1;
        if (lastAddedIndex == -1) {
            return;
        }
        String title = this.getTitleAt(lastAddedIndex);
        boolean wasSelected = this.wasSelected(title);
        boolean selectedByDefault = this.selectedByDefault(categoryPanelSource);
        boolean collapsed = this.userSelectedCategories.isUnselected(title);
        if ((wasSelected || selectedByDefault) && !collapsed) {
            if (!categoryPanelSource.isRendered()) {
                categoryPanelSource.render(properties, Orientation.HORIZONTAL);
            }
            this.setSelectedIndex(lastAddedIndex);
        }
    }

    private boolean wasSelected(String category) {
        if (!this.userSelectedCategories.enabled()) {
            return false;
        }
        if (this.userSelectedCategories.hasSelection()) {
            return ModelUtil.areEqual((Object)this.userSelectedCategories.lastSelected(), (Object)category);
        }
        return false;
    }

    private boolean selectedByDefault(PropertyCategoryPanel categoryPanelSource) {
        Boolean selected = categoryPanelSource.isDefaultSelected();
        return selected != null ? selected : false;
    }

    @Override
    public final boolean hasCategory(String category) {
        int categoryCount = this.getTabCount();
        if (categoryCount == 0) {
            return false;
        }
        for (int i = 0; i < categoryCount; ++i) {
            if (!category.equals(this.getTitleAt(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public final Component componentToAddToPI(Properties properties) {
        if (this.showTabsOnlyIfMoreThanOne()) {
            return this.gui();
        }
        Component selectedComponent = this.getSelectedComponent();
        return null != selectedComponent ? selectedComponent : this.gui();
    }

    private boolean showTabsOnlyIfMoreThanOne() {
        boolean tabsVisible = this.getTabCount() > 1;
        this.setVisible(tabsVisible);
        return tabsVisible;
    }

    @Override
    public void removeAllCategories() {
        this.removeAll();
        this.categoryPanels.clear();
    }

    @Override
    public void removeAll() {
        this.cleaningUp = true;
        this.firstAdditionalPageIndex = -1;
        this.clearInspectorPanels(this);
        super.removeAll();
        this.cleaningUp = false;
    }

    private void clearInspectorPanels(Container start) {
        for (Component c : start.getComponents()) {
            if (c instanceof Container) {
                this.clearInspectorPanels((Container)c);
            }
            if (!(c instanceof AbstractPropertyInspectorPanel)) continue;
            this.clear((AbstractPropertyInspectorPanel)c);
        }
    }

    private void clear(AbstractPropertyInspectorPanel panel) {
        panel.clearTargetPanel();
    }

    @Override
    public int categoryCount() {
        return this.getTabCount();
    }

    @Override
    public void updateComplete(Properties properties) {
        this.renderAndSelectFirstTabIfNoneSelected(properties);
    }

    private void renderAndSelectFirstTabIfNoneSelected(Properties properties) {
        if (!this.userSelectedCategories.enabled() || this.userSelectedCategories.selectedCount() > 0) {
            return;
        }
        if (this.categoryPanels.isEmpty()) {
            return;
        }
        if (this.getTabCount() == 0) {
            return;
        }
        PropertyCategoryPanel firstCategoryPanel = this.categoryPanels.get(0);
        if (!firstCategoryPanel.isRendered()) {
            firstCategoryPanel.render(properties, Orientation.HORIZONTAL);
        }
        int selectedTabIndex = 0;
        this.setSelectedIndex(selectedTabIndex);
        this.userSelectedCategories.userSelected(this.getTitleAt(selectedTabIndex));
    }

    @Override
    public Color background() {
        return this.getBackground();
    }

    @Override
    public void expandCategories(String[] categoryNames) {
    }

    @Override
    public String defaultSelectedCategory() {
        return this.categoryPanelHelper.defaultSelectedCategory(this.categoryPanels);
    }
}

