/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.ocsp;

import java.io.IOException;
import java.io.InputStream;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.ocsp.OCSP;
import oracle.security.crypto.util.Utils;

public class NonceExtension
extends X509Extension {
    private static final ASN1ObjectID TYPE = OCSP.id_pkix_ocsp_nonce;

    public NonceExtension() {
        super(TYPE);
    }

    public NonceExtension(byte[] nonce) {
        this(nonce, false);
    }

    public NonceExtension(byte[] nonce, boolean critical) {
        super(TYPE, critical, nonce);
    }

    public NonceExtension(InputStream is) throws IOException {
        super(is);
    }

    public byte[] getNonce() {
        return this.getValue();
    }

    public String toString() {
        return "nonce extension = " + Utils.toHexString((byte[])this.getNonce());
    }
}

