/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.ocsp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.ocsp.OCSP;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.Utils;

public class AcceptableResponseTypeExtension
extends X509Extension {
    private static final ASN1ObjectID TYPE = OCSP.id_pkix_ocsp_response;
    private Vector acceptableRespTab = new Vector();

    public AcceptableResponseTypeExtension() {
        super(TYPE);
    }

    public AcceptableResponseTypeExtension(ASN1ObjectID acceptableResponse) {
        this(acceptableResponse, false);
    }

    public AcceptableResponseTypeExtension(ASN1ObjectID acceptableResponse, boolean critical) {
        super(TYPE, critical);
        this.acceptableRespTab.addElement(acceptableResponse);
        this.setValue(this.toByteArray());
    }

    public AcceptableResponseTypeExtension(InputStream is) throws IOException {
        super(is);
    }

    public void addAcceptableResponse(ASN1ObjectID acceptableResponse) {
        if (!this.acceptableRespTab.contains(acceptableResponse)) {
            this.acceptableRespTab.addElement(acceptableResponse);
        }
        this.setValue(this.toByteArray());
    }

    public Enumeration acceptableResponses() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.acceptableRespTab.elements();
    }

    private byte[] toByteArray() {
        ASN1Sequence seq = new ASN1Sequence();
        Enumeration e = this.acceptableRespTab.elements();
        while (e.hasMoreElements()) {
            seq.addElement((ASN1Object)((ASN1ObjectID)e.nextElement()));
        }
        byte[] b = Utils.toBytes((Streamable)seq);
        this.isDecoded = true;
        return b;
    }

    private void decodeValue() {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(this.getValue());
            ASN1SequenceInputStream seq = new ASN1SequenceInputStream((InputStream)is);
            this.acceptableRespTab = new Vector();
            while (seq.hasMoreData()) {
                this.addAcceptableResponse(new ASN1ObjectID((InputStream)seq));
            }
            seq.terminate();
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex.toString());
        }
        this.isDecoded = true;
    }

    public String toString() {
        StringBuffer s = new StringBuffer("Acceptable response type extension: ");
        Enumeration e = this.acceptableRespTab.elements();
        while (e.hasMoreElements()) {
            s.append(e.nextElement());
            s.append("; ");
        }
        return s.toString();
    }
}

