/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.library;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.NoSuchFileException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.VersionNumber;
import oracle.ide.xml.XMLUtil;
import oracle.javatools.exports.comment.RemediationCommentsReader;
import oracle.javatools.exports.common.UnmodifiableArrayWrapper;
import oracle.javatools.exports.common.UnmodifiableMappingListWrapper;
import oracle.javatools.exports.library.ClassPathEntry;
import oracle.javatools.exports.library.ExportLibrary;
import oracle.javatools.exports.library.ExportLibraryReader;
import oracle.javatools.exports.library.ExportLibraryWriter;
import oracle.javatools.exports.library.FileExportLibrary;
import oracle.javatools.exports.library.LibraryDependency;
import oracle.javatools.exports.message.Log;
import oracle.javatools.exports.message.Message;
import oracle.javatools.exports.message.Tag;
import oracle.javatools.exports.specification.ExportLinkage;
import oracle.javatools.exports.specification.ExportSpecificationReader;
import oracle.javatools.marshal.AttributeMarker;
import oracle.javatools.marshal.TransientMarker;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.UnexpectedExceptionError;
import oracle.jdeveloper.library.ExternalLibrary;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.JLibraryDefinition;
import oracle.jdeveloper.library.JLibraryManager;
import oracle.jdeveloper.library.JPaths;
import oracle.jdeveloper.library.Library;
import org.xml.sax.SAXException;

public class JLibraryNode
extends ExternalLibrary
implements JLibrary,
ExportLibrary {
    public static final String NAMESPACE_URI = XMLUtil.toNamespaceURI((String)"jlibrarynode");
    public static final String ROOT_TAG = "JLibraryNode";
    private FileExportLibrary exportLibrary;
    private boolean exportFormat;
    private String id = "";
    private boolean idSynthetic;
    private String description = "";
    private Boolean deployed;
    private Map<String, List<URL>> exportSpecificationPaths = Collections.emptyMap();
    private List<URL> remediationCommentsPaths = Collections.emptyList();
    private List<LibraryDependency> dependencies = Collections.emptyList();
    private List<ClassPathEntry> suppliedClassPathEntries = Collections.emptyList();
    private List<ClassPathEntry> resolvedClassPathEntries = Collections.emptyList();
    private List<ClassPathEntry> expandedClassPathEntries = Collections.emptyList();
    private boolean manifestClassPath = false;
    private Map<String, String> resolvedRemediationComments = Collections.emptyMap();
    private static final Logger LOGGER;
    private static final ExportLibraryReader READER;

    public JLibraryNode() {
        this.exportFormat = true;
    }

    public JLibraryNode(URL url) {
        super(url);
        this.exportFormat = true;
    }

    public JLibraryNode(URL url, boolean exportFormat) {
        super(url);
        this.exportFormat = exportFormat;
    }

    public JLibraryNode(FileExportLibrary library) {
        super(library.getOrigin());
        this.exportLibrary = library;
        this.exportFormat = true;
        try {
            this.open();
        }
        catch (IOException e) {
            throw new UnexpectedExceptionError((Throwable)e);
        }
        this.exportLibrary = null;
    }

    @Override
    protected void openImpl() throws IOException {
        try {
            if (!this.exportFormat) {
                throw new ExportLibraryReader.LegacyFormatException();
            }
            if (this.exportLibrary == null) {
                Log log = Log.newLog((Tag[])new Tag[0]);
                this.exportLibrary = READER.read(this.getURL(), Collections.emptyMap(), log);
                this.exportLibrary.resolve(new ExportSpecificationReader(), new RemediationCommentsReader(), id -> JLibraryManager.getAddinLibraries().findLibrary(id), log);
                for (Message message : log.getMessages()) {
                    LOGGER.log(message.getLevel(), message.getMessage());
                }
            }
            this.exportFormat = true;
            this.id = this.exportLibrary.getId();
            this.idSynthetic = this.exportLibrary.isIdSynthetic();
            this.setName(this.exportLibrary.getName());
            this.description = this.exportLibrary.getDescription();
            this.setDeployedByDefault(this.exportLibrary.isSet(FileExportLibrary.LibraryFlag.DEPLOYED));
            this.setLocked(this.exportLibrary.isSet(FileExportLibrary.LibraryFlag.LOCKED));
            this.exportSpecificationPaths = this.exportLibrary.getExportSpecificationPaths();
            this.remediationCommentsPaths = this.exportLibrary.getRemediationCommentsPaths();
            this.resolvedRemediationComments = this.exportLibrary.getResolvedRemediationComments();
            URLPath sourcePath = new URLPath();
            sourcePath.add((Collection)this.exportLibrary.getSourcePath());
            this.setSourcePath(sourcePath);
            URLPath docPath = new URLPath();
            docPath.add((Collection)this.exportLibrary.getDocPath());
            this.setDocPath(docPath);
            this.dependencies = this.exportLibrary.getDependencies();
            URLPath classPath = new URLPath();
            classPath.add((Collection)this.exportLibrary.getResolvedClassPath());
            super.setClassPath(classPath);
            this.suppliedClassPathEntries = this.exportLibrary.getSuppliedClassPathEntries();
            this.resolvedClassPathEntries = this.exportLibrary.getResolvedClassPathEntries();
            this.expandedClassPathEntries = this.exportLibrary.getExpandedClassPathEntries();
            this.manifestClassPath = this.exportLibrary.hasManifestClassPath();
            this.markDirty(false);
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            this.exportFormat = false;
            super.openImpl();
            this.id = "";
            this.idSynthetic = false;
            this.description = "";
            this.exportSpecificationPaths = Collections.emptyMap();
            this.remediationCommentsPaths = Collections.emptyList();
            this.resolvedRemediationComments = Collections.emptyMap();
            this.dependencies = Collections.emptyList();
            this.setClassPath(new URLPath());
        }
        catch (ExportLibraryReader.LegacyFormatException e) {
            this.exportFormat = false;
            this.id = ExportLibrary.syntheticId((URL)this.getURL(), (String)this.getName());
            this.idSynthetic = true;
            this.description = "";
            this.dependencies = Collections.emptyList();
            super.openImpl();
        }
        catch (IllegalArgumentException | ParserConfigurationException | SAXException e) {
            this.exportLibrary = null;
            throw new IOException("exception opening " + this.getURL() + ": " + e, e);
        }
    }

    public void markDirty(boolean dirty) {
        super.markDirty(dirty);
        if (this.isOpen()) {
            this.exportFormat = true;
        }
    }

    @Override
    protected void saveImpl() throws IOException {
        if (this.exportFormat) {
            boolean mutated;
            URLPath maybeMutatedClassPath;
            EnumSet<FileExportLibrary.LibraryFlag> flags = EnumSet.noneOf(FileExportLibrary.LibraryFlag.class);
            if (Boolean.TRUE.equals(this.getDeployedByDefault())) {
                flags.add(FileExportLibrary.LibraryFlag.DEPLOYED);
            }
            if (this.isLocked()) {
                flags.add(FileExportLibrary.LibraryFlag.LOCKED);
            }
            if ((maybeMutatedClassPath = this.getClassPath()) != null) {
                Iterator left = maybeMutatedClassPath.iterator();
                Iterator<ClassPathEntry> right = this.resolvedClassPathEntries.iterator();
                boolean bl = mutated = maybeMutatedClassPath.size() != this.resolvedClassPathEntries.size();
                while (!mutated && left.hasNext()) {
                    mutated = !URLFileSystem.equals((URL)((URL)left.next()), (URL)right.next().getUrl());
                }
            } else {
                boolean bl = mutated = !this.resolvedClassPathEntries.isEmpty();
            }
            if (mutated) {
                this.setClassPath(maybeMutatedClassPath);
            }
            URLPath sourcePath = this.getSourcePath();
            URLPath docPath = this.getDocPath();
            new ExportLibraryWriter(Charset.forName(IdeUtil.getIdeIanaEncoding())).write(this.getURL(), this.id, this.getName(), this.description, flags, this.resolvedClassPathEntries, this.exportSpecificationPaths, this.remediationCommentsPaths, this.dependencies, sourcePath != null ? sourcePath.asList() : Collections.emptyList(), docPath != null ? docPath.asList() : Collections.emptyList());
        } else {
            super.saveImpl();
        }
    }

    @Override
    public boolean equivalent(Library library) {
        if (!(library instanceof JLibrary)) {
            return false;
        }
        JLibrary jLibrary = (JLibrary)library;
        if (!super.equivalent(jLibrary)) {
            return false;
        }
        if (ModelUtil.areDifferent((Object)this.deployed, (Object)jLibrary.getDeployedByDefault())) {
            return false;
        }
        if (library instanceof ExportLibrary) {
            ExportLibrary xLibrary = (ExportLibrary)library;
            if (ModelUtil.areDifferent((Object)this.id, (Object)xLibrary.getId())) {
                return false;
            }
            if (ModelUtil.areDifferent((Object)this.description, (Object)xLibrary.getDescription())) {
                return false;
            }
            if (ModelUtil.areDifferent(this.exportSpecificationPaths, (Object)xLibrary.getExportSpecificationPaths())) {
                return false;
            }
            if (ModelUtil.areDifferent(this.remediationCommentsPaths, (Object)xLibrary.getRemediationCommentsPaths())) {
                return false;
            }
            if (ModelUtil.areDifferent(this.dependencies, (Object)xLibrary.getDependencies())) {
                return false;
            }
            return !this.areDifferent(this.suppliedClassPathEntries, xLibrary.getSuppliedClassPathEntries());
        }
        return true;
    }

    private boolean areDifferent(Collection<ClassPathEntry> c0, Collection<ClassPathEntry> c1) {
        if (c0.size() != c1.size()) {
            return true;
        }
        Iterator<ClassPathEntry> i0 = c0.iterator();
        Iterator<ClassPathEntry> i1 = c1.iterator();
        while (i0.hasNext()) {
            ClassPathEntry e1;
            ClassPathEntry e0 = i0.next();
            if (e0.equals((Object)(e1 = i1.next())) && e0.getExportLinkage() == e1.getExportLinkage() && e0.getLibraryLinkageKey().equals(e1.getLibraryLinkageKey()) && e0.isManifestExport() == e1.isManifestExport()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void initFromLibrary(Library lib) {
        if (lib instanceof JLibrary) {
            JLibrary jlib = (JLibrary)lib;
            Boolean deployed = jlib.getDeployedByDefault();
            super.initFromLibrary(jlib);
            if (ModelUtil.areDifferent((Object)deployed, (Object)this.getDeployedByDefault())) {
                this.setDeployedByDefault(deployed);
            }
            if (lib instanceof ExportLibrary) {
                ExportLibrary xlib = (ExportLibrary)lib;
                if (ModelUtil.areDifferent((Object)xlib.getId(), (Object)this.getId())) {
                    this.setId(xlib.getId());
                }
                if (ModelUtil.areDifferent((Object)xlib.getDescription(), (Object)this.getDescription())) {
                    this.setDescription(xlib.getDescription());
                }
                if (ModelUtil.areDifferent((Object)xlib.getDependencies(), this.getDependencies())) {
                    this.setDependencies(xlib.getDependencies());
                }
                if (this.areDifferent(xlib.getSuppliedClassPathEntries(), this.getSuppliedClassPathEntries())) {
                    this.setSuppliedClassPathEntries(xlib.getSuppliedClassPathEntries());
                }
                if (this.areDifferent(xlib.getResolvedClassPathEntries(), this.getSuppliedClassPathEntries())) {
                    this.setResolvedClassPathEntries(xlib.getSuppliedClassPathEntries());
                }
                if (this.areDifferent(xlib.getExpandedClassPathEntries(), this.getExpandedClassPathEntries())) {
                    this.setExpandedClassPathEntries(xlib.getExpandedClassPathEntries());
                }
                if (ModelUtil.areDifferent((Object)xlib.getExportSpecificationPaths(), this.getExportSpecificationPaths())) {
                    this.setExportSpecificationPaths(xlib.getExportSpecificationPaths());
                }
                if (ModelUtil.areDifferent((Object)xlib.getRemediationCommentsPaths(), this.getRemediationCommentsPaths())) {
                    this.setRemediationCommentsPaths(xlib.getRemediationCommentsPaths());
                }
            }
        }
    }

    public URL getOrigin() {
        return this.getURL();
    }

    public String getId() throws TransientMarker {
        return this.ensureOpen() ? this.id : "";
    }

    public void setId(String newId) {
        String oldId = this.id;
        if (this.ensureOpen() && ModelUtil.areDifferent((Object)oldId, (Object)newId)) {
            this.id = newId;
            this.idSynthetic = false;
            this.markDirty(true);
            this.fireChangeEvent("id", oldId, newId);
        }
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (this.idSynthetic) {
            String newId = ExportLibrary.syntheticId((URL)this.getURL(), (String)this.getName());
            String oldId = this.id;
            if (this.ensureOpen() && ModelUtil.areDifferent((Object)oldId, (Object)newId)) {
                this.id = newId;
                this.markDirty(true);
                this.fireChangeEvent("id", oldId, newId);
            }
        }
    }

    public String getDescription() throws TransientMarker {
        return this.ensureOpen() ? this.description : "";
    }

    public void setDescription(String newDescription) {
        String oldDescription = this.description;
        if (this.ensureOpen() && ModelUtil.areDifferent((Object)oldDescription, (Object)newDescription)) {
            this.description = newDescription;
            this.markDirty(true);
            this.fireChangeEvent("description", oldDescription, newDescription);
        }
    }

    @Override
    public Boolean getDeployedByDefault() throws AttributeMarker {
        return this.ensureOpen() ? this.deployed : Boolean.FALSE;
    }

    @Override
    public void setDeployedByDefault(Boolean newDeployed) {
        Boolean oldDeployed = this.deployed;
        if (this.ensureOpen() && ModelUtil.areDifferent((Object)newDeployed, (Object)oldDeployed)) {
            this.deployed = newDeployed;
            this.markDirty(true);
            this.fireChangeEvent("deployedByDefault", oldDeployed, newDeployed);
        }
    }

    @Override
    public void setClassPath(URLPath newClassPath) {
        if (this.ensureOpen()) {
            URLPath classPath = new URLPath();
            Object[] suppliedEntries = new ClassPathEntry[newClassPath.size()];
            int count = 0;
            for (URL url : newClassPath) {
                classPath.add(url);
                suppliedEntries[count++] = new ClassPathEntry(url, ExportLinkage.NULL, null, false, -1);
            }
            this.suppliedClassPathEntries = new UnmodifiableArrayWrapper(suppliedEntries);
            LinkedHashSet<ClassPathEntry> resolvedEntries = new LinkedHashSet<ClassPathEntry>(this.suppliedClassPathEntries);
            for (LibraryDependency dependency : this.dependencies) {
                Object library = dependency.getLibrary();
                if (library instanceof ExportLibrary) {
                    ExportLibrary exportLibrary = (ExportLibrary)library;
                    classPath.add((Collection)exportLibrary.getResolvedClassPath());
                    resolvedEntries.addAll(exportLibrary.getResolvedClassPathEntries());
                    continue;
                }
                if (!(library instanceof JPaths)) continue;
                for (URL url : ((JPaths)library).getClassPath()) {
                    classPath.add(url);
                    resolvedEntries.add(new ClassPathEntry(url, ExportLinkage.NULL, null, false, -1));
                }
            }
            super.setClassPath(classPath);
            this.resolvedClassPathEntries = new UnmodifiableArrayWrapper((Object[])resolvedEntries.toArray(new ClassPathEntry[resolvedEntries.size()]));
            this.expandedClassPathEntries = Collections.emptyList();
            this.manifestClassPath = false;
            this.setExportSpecificationPaths(Collections.emptyMap());
            this.setRemediationCommentsPaths(Collections.emptyList());
        }
    }

    private void setSuppliedClassPathEntries(List<ClassPathEntry> newClassPath) {
        List<ClassPathEntry> oldClassPath = this.suppliedClassPathEntries;
        if (this.ensureOpen() && this.areDifferent(oldClassPath, newClassPath)) {
            this.suppliedClassPathEntries = newClassPath;
        }
    }

    private void setResolvedClassPathEntries(List<ClassPathEntry> newClassPath) {
        List<ClassPathEntry> oldClassPath = this.resolvedClassPathEntries;
        if (this.ensureOpen() && this.areDifferent(oldClassPath, newClassPath)) {
            this.resolvedClassPathEntries = newClassPath;
        }
    }

    private void setExpandedClassPathEntries(List<ClassPathEntry> newClassPath) {
        List<Object> oldClassPath = this.expandedClassPathEntries;
        if (oldClassPath == null) {
            oldClassPath = Collections.emptyList();
        }
        if (this.ensureOpen() && this.areDifferent(oldClassPath, newClassPath)) {
            this.expandedClassPathEntries = newClassPath;
        }
    }

    public List<ClassPathEntry> getSuppliedClassPathEntries() {
        return this.ensureOpen() ? this.resolvedClassPathEntries : Collections.emptyList();
    }

    public List<URL> getSuppliedClassPath() {
        return new UnmodifiableMappingListWrapper(this.suppliedClassPathEntries, ClassPathEntry::getUrl);
    }

    public List<ClassPathEntry> getResolvedClassPathEntries() {
        return this.ensureOpen() ? this.resolvedClassPathEntries : Collections.emptyList();
    }

    public List<URL> getResolvedClassPath() {
        return new UnmodifiableMappingListWrapper(this.resolvedClassPathEntries, ClassPathEntry::getUrl);
    }

    public List<ClassPathEntry> getExpandedClassPathEntries() {
        if (!this.ensureOpen()) {
            return Collections.emptyList();
        }
        if (this.expandedClassPathEntries.isEmpty() && this.getClassPath().size() > 0) {
            URLPath path = new URLPath(this.getClassPath());
            path.expandToIncludeManifestClassPaths();
            Object[] entries = new ClassPathEntry[path.size()];
            int count = 0;
            for (URL url : path) {
                entries[count++] = new ClassPathEntry(url, ExportLinkage.NULL, null, false, -1);
            }
            this.expandedClassPathEntries = new UnmodifiableArrayWrapper(entries);
        }
        return this.expandedClassPathEntries;
    }

    public List<URL> getExpandedClassPath() {
        return new UnmodifiableMappingListWrapper(this.getExpandedClassPathEntries(), ClassPathEntry::getUrl);
    }

    public Map<String, List<URL>> getExportSpecificationPaths() {
        return this.ensureOpen() ? this.exportSpecificationPaths : Collections.emptyMap();
    }

    public boolean hasManifestClassPath() {
        return this.manifestClassPath;
    }

    private void setExportSpecificationPaths(Map<String, List<URL>> newExportSpecificationPaths) {
        Map<String, List<URL>> oldExportSpecificationPaths = this.exportSpecificationPaths;
        if (this.ensureOpen() && ModelUtil.areDifferent(oldExportSpecificationPaths, newExportSpecificationPaths)) {
            this.exportSpecificationPaths = newExportSpecificationPaths;
        }
    }

    public List<URL> getRemediationCommentsPaths() {
        return this.ensureOpen() ? this.remediationCommentsPaths : Collections.emptyList();
    }

    public void setRemediationCommentsPaths(List<URL> newRemediationCommentPaths) {
        List<URL> oldRemediationCommentPaths = this.remediationCommentsPaths;
        if (this.ensureOpen() && ModelUtil.areDifferent(oldRemediationCommentPaths, newRemediationCommentPaths)) {
            this.remediationCommentsPaths = newRemediationCommentPaths;
        }
    }

    public Map<String, String> getResolvedRemediationComments() {
        return this.ensureOpen() ? this.resolvedRemediationComments : Collections.emptyMap();
    }

    public List<LibraryDependency> getDependencies() throws TransientMarker {
        return this.ensureOpen() ? this.dependencies : Collections.emptyList();
    }

    private void setDependencies(List<LibraryDependency> newDependencies) {
        List<LibraryDependency> oldDependencies = this.dependencies;
        if (this.ensureOpen() && ModelUtil.areDifferent(oldDependencies, newDependencies)) {
            this.dependencies = newDependencies;
        }
    }

    @Override
    @Deprecated
    public JLibraryDefinition getDefaultLibraryDefinition() {
        return this;
    }

    @Override
    @Deprecated
    public JLibraryDefinition getLibraryDefinition(VersionNumber jdkVer) {
        return this;
    }

    @Override
    protected String getExtension() {
        return ".library";
    }

    static {
        Object2Dom.registerNamespaceElem(JLibraryNode.class, (String)NAMESPACE_URI, (String)ROOT_TAG);
        LOGGER = Logger.getLogger(JLibraryNode.class.getName());
        READER = new ExportLibraryReader();
        boolean validate = Boolean.getBoolean("ide.library.schema.validate");
        READER.setSchemaValidating(validate);
        READER.setQuiet(!validate);
        ExportSpecificationReader specificationReader = READER.getExportSpecificationReader();
        specificationReader.setSchemaValidating(validate);
        specificationReader.setQuiet(!validate);
        specificationReader.setDomainValidating(validate);
        RemediationCommentsReader commentsReader = READER.getRemediationCommentsReader();
        commentsReader.setSchemaValidating(validate);
        commentsReader.setQuiet(!validate);
    }
}

