/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.library;

import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.VersionNumber;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.marshal.ToStringManager;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.JDKUtil;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.library.LibraryAdapter;

public final class JDKAdapter
extends LibraryAdapter
implements JDK {
    private transient String[] _vms;
    private URLPath _expandedClsPath;
    private URLPath _expandedSrcPath;

    public JDKAdapter(HashStructure hash) {
        super(hash);
    }

    @Override
    public boolean equivalent(Library lib) {
        JDK jdk;
        JDK jDK = jdk = lib instanceof JDK ? (JDK)lib : null;
        if (!super.equivalent(jdk)) {
            return false;
        }
        if (ModelUtil.areDifferent((Object)jdk.getJavaExecutable(), (Object)this.getJavaExecutable())) {
            return false;
        }
        if (!Arrays.equals(jdk.getInstalledVMs(), this.getInstalledVMs())) {
            return false;
        }
        if (ModelUtil.areDifferent((Object)jdk.getJavaVersion(), (Object)this.getJavaVersion())) {
            return false;
        }
        if (ModelUtil.areDifferent((Object)jdk.getSDKBinDir(), (Object)this.getSDKBinDir())) {
            return false;
        }
        if (ModelUtil.areDifferent((Object)jdk.getExpandedClassPath(), (Object)this.getExpandedClassPath())) {
            return false;
        }
        return !ModelUtil.areDifferent((Object)jdk.getExpandedSourcePath(), (Object)this.getExpandedSourcePath());
    }

    @Override
    public void initFromLibrary(Library lib) {
        if (lib instanceof JDK) {
            super.initFromLibrary(lib);
            JDK jdk = (JDK)lib;
            URL exe = jdk.getJavaExecutable();
            Object[] vms = jdk.getInstalledVMs();
            VersionNumber version = jdk.getJavaVersion();
            URL binDir = jdk.getSDKBinDir();
            URLPath expandedClsPath = jdk.getExpandedClassPath();
            URLPath expandedSrcPath = jdk.getExpandedSourcePath();
            if (ModelUtil.areDifferent((Object)exe, (Object)this.getJavaExecutable())) {
                this.setJavaExecutable(exe);
            }
            if (!Arrays.equals(vms, this.getInstalledVMs())) {
                this.setInstalledVMs((String[])vms);
            }
            if (ModelUtil.areDifferent((Object)version, (Object)this.getJavaVersion())) {
                this.setJavaVersion(version);
            }
            if (ModelUtil.areDifferent((Object)binDir, (Object)this.getSDKBinDir())) {
                this.setSDKBinDir(binDir);
            }
            if (ModelUtil.areDifferent((Object)expandedClsPath, (Object)this.getExpandedClassPath())) {
                this.setExpandedClassPath(expandedClsPath);
            }
            if (ModelUtil.areDifferent((Object)expandedSrcPath, (Object)this.getExpandedSourcePath())) {
                this.setExpandedSourcePath(expandedSrcPath);
            }
        }
    }

    @Override
    public URL getJavaExecutable() {
        return this._hash.getURL("javaExecutable");
    }

    @Override
    public void setJavaExecutable(URL url) {
        if (url == null) {
            this._hash.remove("javaExecutable");
        } else {
            this._hash.putURL("javaExecutable", url);
        }
    }

    @Override
    public synchronized String[] getInstalledVMs() {
        if (this._vms == null && this.getSDKBinDir() != null) {
            this._vms = JDKUtil.getVMChoices(this.getSDKBinDir(), false);
        }
        return this._vms != null ? this._vms : new String[]{};
    }

    @Override
    public synchronized void setInstalledVMs(String[] installedVMs) {
        this._vms = installedVMs;
    }

    @Override
    public VersionNumber getJavaVersion() {
        String str = this._hash.getString("version");
        if (str != null) {
            try {
                return (VersionNumber)ToStringManager.fromString((String)str, VersionNumber.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public void setJavaVersion(VersionNumber ver) {
        if (ver == null) {
            this._hash.remove("version");
        } else {
            try {
                this._hash.putString("version", ToStringManager.toString((Object)ver, VersionNumber.class));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public URL getSDKBinDir() {
        return this._hash.getURL("sdkBinDir");
    }

    @Override
    public void setSDKBinDir(URL url) {
        if (url == null) {
            this._hash.remove("sdkBinDir");
        } else {
            this._hash.putURL("sdkBinDir", url);
        }
    }

    @Override
    public String getSDKBinJavaExecutableNoConsole() {
        URL url = this.getSDKBinDir();
        if (url != null) {
            return JDKUtil.getJavaExecutableNoConsolePath(url);
        }
        return null;
    }

    @Override
    public String getJavaExecutableNoConsole() {
        URL url = this.getJavaExecutable();
        if (url != null && (url = URLFileSystem.getParent((URL)url)) != null) {
            return JDKUtil.getJavaExecutableNoConsolePath(url);
        }
        return null;
    }

    @Override
    public Properties getSystemProperties() {
        return JDKUtil.getSystemProperties(this);
    }

    @Override
    @Deprecated
    public URLPath getModulePath() {
        VersionNumber javaVersion = this.getJavaVersion();
        if (javaVersion != null && javaVersion.isAfter("9", true)) {
            return this.getClassPath();
        }
        return new URLPath();
    }

    @Override
    @Deprecated
    public void setModulePath(URLPath modulePath) {
        VersionNumber javaVersion = this.getJavaVersion();
        if (javaVersion != null && javaVersion.isAfter("9", true)) {
            this.setClassPath(modulePath);
        }
    }

    @Override
    public URLPath getExpandedClassPath() {
        ListStructure data = this._hash.getListStructure("expandedClassPath");
        return data == null ? new URLPath(this.getClassPath()) : new URLPath((List)data);
    }

    @Override
    public void setExpandedClassPath(URLPath path) {
        if (path == null) {
            this._hash.remove("expandedClassPath");
        } else {
            ListStructure data = this._hash.getOrCreateListStructure("expandedClassPath");
            data.mirror(path.asList());
        }
    }

    @Override
    public URLPath getExpandedSourcePath() {
        ListStructure data = this._hash.getListStructure("expandedSourcePath");
        return data == null ? new URLPath(this.getSourcePath()) : new URLPath((List)data);
    }

    @Override
    public void setExpandedSourcePath(URLPath path) {
        if (path == null) {
            this._hash.remove("expandedSourcePath");
        } else {
            ListStructure data = this._hash.getOrCreateListStructure("expandedSourcePath");
            data.mirror(path.asList());
        }
    }
}

