/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.library;

import javax.swing.Icon;
import oracle.ide.net.URLPath;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.library.LibraryElement;
import oracle.jdevimpl.library.LibraryProxy;

public abstract class AbstractLibrary
extends LibraryElement
implements Library {
    @Override
    public boolean equivalent(Library library) {
        if (library == null) {
            return false;
        }
        if (ModelUtil.areDifferent((Object)library.getClassPath(), (Object)this.getClassPath())) {
            return false;
        }
        if (ModelUtil.areDifferent((Object)library.getSourcePath(), (Object)this.getSourcePath())) {
            return false;
        }
        if (ModelUtil.areDifferent((Object)library.getDocPath(), (Object)this.getDocPath())) {
            return false;
        }
        return library.isLocked() == this.isLocked();
    }

    @Override
    public void initFromLibrary(Library library) {
    }

    @Override
    public void setClassPath(URLPath clsPath) {
    }

    @Override
    public void setSourcePath(URLPath srcPath) {
    }

    @Override
    public void setDocPath(URLPath docPath) {
    }

    @Override
    public boolean isLocked() {
        return true;
    }

    @Override
    public void setLocked(boolean isLocked) {
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public Object getID() {
        return this.getName();
    }

    @Override
    @Deprecated
    public URLPath getDefaultClassPath() {
        return this.getClassPath();
    }

    @Override
    @Deprecated
    public void setDefaultClassPath(URLPath clsPath) {
        this.setClassPath(clsPath);
    }

    @Override
    @Deprecated
    public URLPath getDefaultSourcePath() {
        return this.getSourcePath();
    }

    @Override
    @Deprecated
    public void setDefaultSourcePath(URLPath srcPath) {
        this.setSourcePath(srcPath);
    }

    @Override
    @Deprecated
    public URLPath getDefaultDocPath() {
        return this.getDocPath();
    }

    @Override
    @Deprecated
    public void setDefaultDocPath(URLPath docPath) {
        this.setDocPath(docPath);
    }

    @Override
    public void markDirty(boolean dirty) {
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    public String getShortLabel() {
        return this.getName();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (LibraryProxy.isProxyLibrary(o)) {
            o = LibraryProxy.getProxiedLibrary(o);
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((AbstractLibrary)o);
    }

    public Icon getIcon() {
        return OracleIcons.getIcon((String)"library.png");
    }

    protected final void copyToImpl(AbstractLibrary copy) {
    }

    protected boolean equalsImpl(AbstractLibrary other) {
        return ModelUtil.areEqual((Object)this.getName(), (Object)other.getName());
    }
}

