/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.saml2.profiles.attribute.dce;

import java.util.List;
import oracle.security.xmlsec.saml2.core.Attribute;
import oracle.security.xmlsec.saml2.util.SAML2URI;
import oracle.security.xmlsec.util.QName;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DCERealmAttribute
extends Attribute {
    public DCERealmAttribute(Element element) throws DOMException {
        super(element);
    }

    public DCERealmAttribute(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public DCERealmAttribute(Document owner) throws DOMException {
        super(owner);
        this.setNameFormat("urn:oasis:names:tc:SAML:2.0:attrname-format:uri");
        this.setName("urn:oasis:names:tc:SAML:2.0:profiles:attribute:DCE:realm");
    }

    public void setAttributeValue(String uuidValue, String friendlyName) {
        XMLUtils.removeChildren((Element)((Element)this.node), (String)"urn:oasis:names:tc:SAML:2.0:assertion", (String)"AttributeValue");
        Element av = this.addAttributeValue(this.getOwnerDocument().createTextNode(uuidValue), SAML2URI.encoding_xsitype_dceValueType);
        if (friendlyName != null) {
            String prefix = XMLElement.getDefaultNSPrefix((String)"urn:oasis:names:tc:SAML:2.0:profiles:attribute:DCE");
            if (prefix == null || prefix.length() == 0) {
                prefix = "dceprof";
            }
            this.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, "urn:oasis:names:tc:SAML:2.0:profiles:attribute:DCE");
            av.setAttributeNS("urn:oasis:names:tc:SAML:2.0:profiles:attribute:DCE", prefix + ":FriendlyName", friendlyName);
        }
    }

    public String getAttributeValueString() {
        List avList = this.getAttributeValues();
        if (avList != null) {
            int len = avList.size();
            for (int i = 0; i < len; ++i) {
                Element av = (Element)avList.get(i);
                QName type = DCERealmAttribute.getXsiType(av);
                if (type != null && !SAML2URI.encoding_xsitype_dceValueType.equals((Object)type)) continue;
                return XMLUtils.collectText((Node)av);
            }
        }
        return null;
    }

    @Override
    public String getAttributeProfileID() {
        return "urn:oasis:names:tc:SAML:2.0:profiles:attribute:DCE";
    }
}

