/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.saml2.metadata;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Date;
import oracle.security.xmlsec.dsig.SigningException;
import oracle.security.xmlsec.dsig.VerifyException;
import oracle.security.xmlsec.dsig.XSKeyInfo;
import oracle.security.xmlsec.dsig.XSSignature;
import oracle.security.xmlsec.saml2.metadata.Extensions;
import oracle.security.xmlsec.saml2.util.SAML2Initializer;
import oracle.security.xmlsec.saml2.util.SAML2Utils;
import oracle.security.xmlsec.transform.TransformationException;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class Descriptor
extends XMLElement {
    private static final String[] nsList = new String[]{"http://www.w3.org/2000/09/xmldsig#", "urn:oasis:names:tc:SAML:2.0:metadata"};
    private static final String[] tagList = new String[]{"Signature", "Extensions"};

    public Descriptor(Element element) throws DOMException {
        super(element);
    }

    public Descriptor(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    protected Descriptor(Document owner, String nsURI, String localName) throws DOMException {
        super(owner, nsURI, localName);
    }

    public void setID(String id) {
        this.setAttribute("ID", id);
    }

    public String getID() {
        if (this.hasAttribute("ID")) {
            return this.getAttribute("ID");
        }
        return null;
    }

    public void setValidUntil(Date validUntil) {
        this.setAttribute("validUntil", XMLUtils.formatDateTime((Date)validUntil));
    }

    public Date getValidUntil() {
        if (this.hasAttribute("validUntil")) {
            return XMLUtils.parseDateTime((String)this.getAttribute("validUntil"));
        }
        return null;
    }

    public void setCacheDuration(String duration) {
        this.setAttribute("cacheDuration", duration);
    }

    public String getCacheDuration() {
        if (this.hasAttribute("cacheDuration")) {
            return this.getAttribute("cacheDuration");
        }
        return null;
    }

    public void setExtensions(Extensions extension) {
        XMLUtils.removeChildren((Element)((Element)this.getNode()), (String)"urn:oasis:names:tc:SAML:2.0:metadata", (String)"Extensions");
        XMLUtils.insertChild((XMLElement)this, (XMLElement)extension, (String[])new String[]{"http://www.w3.org/2000/09/xmldsig#", "urn:oasis:names:tc:SAML:2.0:metadata"}, (String[])new String[]{"Signature", "Extensions"});
    }

    public Extensions getExtensions() {
        return (Extensions)SAML2Utils.getChildElement(this, "urn:oasis:names:tc:SAML:2.0:metadata", "Extensions");
    }

    public XSSignature getSignature() {
        return (XSSignature)SAML2Utils.getChildElement(this, "http://www.w3.org/2000/09/xmldsig#", "Signature");
    }

    public boolean isSigned() {
        return SAML2Utils.getChildElement(this, "http://www.w3.org/2000/09/xmldsig#", "Signature") != null;
    }

    public void sign(PrivateKey privateKey, X509Certificate cert) throws SigningException {
        this.sign(privateKey, cert, "http://www.w3.org/2001/10/xml-exc-c14n#");
    }

    public void sign(PrivateKey privateKey, X509Certificate cert, String c14nMethod) throws SigningException {
        try {
            String keyAlgorithm = privateKey.getAlgorithm();
            String signatureMethod = null;
            if ("RSA".equals(keyAlgorithm)) {
                signatureMethod = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
            } else if ("DSA".equals(keyAlgorithm)) {
                signatureMethod = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
            } else {
                throw new SigningException("Unsupported key algorithm.");
            }
            XSSignature sig = this.addSignature(signatureMethod, c14nMethod);
            if (cert != null) {
                XSKeyInfo ki = sig.createKeyInfo();
                ki.addKeyInfoData((XMLElement)ki.createX509Data(cert));
                sig.setKeyInfo(ki);
            }
            sig.sign(privateKey, null);
        }
        catch (TransformationException ex) {
            throw new SigningException(ex.toString());
        }
    }

    public XSSignature addSignature(String signatureMethod, String c14nMethod) {
        return this.addSignature(signatureMethod, c14nMethod, "http://www.w3.org/2000/09/xmldsig#sha1");
    }

    public XSSignature addSignature(String signatureMethod, String c14nMethod, String digestMethod) {
        XMLUtils.removeChildren((Element)((Element)this.node), (String)"http://www.w3.org/2000/09/xmldsig#", (String)"Signature");
        XSSignature sig = SAML2Utils.createSignature(this, this.getID(), signatureMethod, c14nMethod, digestMethod);
        XMLUtils.insertChild((XMLElement)this, (XMLElement)sig, (String[])nsList, (String[])tagList);
        return sig;
    }

    public boolean verify() throws VerifyException {
        return this.verify(null);
    }

    public boolean verify(PublicKey publicKey) throws VerifyException {
        XSSignature sig = this.getSignature();
        if (sig == null) {
            throw new VerifyException("The message is not signed");
        }
        if (publicKey != null) {
            return sig.verify(publicKey, true);
        }
        return sig.verify(true);
    }

    protected void clearSignature() {
        XMLUtils.removeChildren((Element)((Element)this.node), (String)"http://www.w3.org/2000/09/xmldsig#", (String)"Signature");
    }

    static {
        SAML2Initializer.initialize();
    }
}

