/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.saml2.metadata;

import java.util.List;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.xmlsec.saml2.metadata.AffiliateMember;
import oracle.security.xmlsec.saml2.metadata.Descriptor;
import oracle.security.xmlsec.saml2.metadata.EntityID;
import oracle.security.xmlsec.saml2.metadata.KeyDescriptor;
import oracle.security.xmlsec.saml2.util.SAML2Utils;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AffiliationDescriptor
extends Descriptor {
    String[] tagList = new String[]{"Signature", "Extensions", "AffiliateMember", "KeyDescriptor"};
    String[] nsList = new String[]{"http://www.w3.org/2000/09/xmldsig#", "urn:oasis:names:tc:SAML:2.0:metadata", "urn:oasis:names:tc:SAML:2.0:metadata", "urn:oasis:names:tc:SAML:2.0:metadata"};

    public AffiliationDescriptor(Element element) throws DOMException {
        super(element);
    }

    public AffiliationDescriptor(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public AffiliationDescriptor(Document owner) throws DOMException {
        super(owner, "urn:oasis:names:tc:SAML:2.0:metadata", "AffiliationDescriptor");
        this.addNSPrefixAttrDefault("urn:oasis:names:tc:SAML:2.0:metadata");
    }

    public void setAffiliationOwnerID(EntityID name) {
        this.setAttribute("affiliationOwnerID", name.getURI());
    }

    public EntityID getAffiliationOwnerID() {
        String uri;
        if (this.hasAttribute("affiliationOwnerID") && (uri = this.getAttribute("affiliationOwnerID")) != null) {
            AffiliateMember am = new AffiliateMember(this.getOwnerDocument());
            try {
                am.setURI(uri);
            }
            catch (InvalidInputException invalidInputException) {
                // empty catch block
            }
            return am;
        }
        return null;
    }

    public void addAffiliateMember(AffiliateMember am) {
        XMLUtils.insertChild((XMLElement)this, (XMLElement)am, (String[])this.nsList, (String[])this.tagList);
    }

    public List getAffiliateMembers() {
        return SAML2Utils.getChildElements(this, "urn:oasis:names:tc:SAML:2.0:metadata", "AffiliateMember");
    }

    public void addKeyDescriptor(KeyDescriptor kd) {
        XMLUtils.insertChild((XMLElement)this, (XMLElement)kd, (String[])this.nsList, (String[])this.tagList);
    }

    public List getKeyDescriptors() {
        return SAML2Utils.getChildElements(this, "urn:oasis:names:tc:SAML:2.0:metadata", "KeyDescriptor");
    }
}

