/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.saml2.core;

import oracle.security.xmlsec.saml2.core.BaseID;
import oracle.security.xmlsec.saml2.core.EncryptedID;
import oracle.security.xmlsec.saml2.core.NameID;
import oracle.security.xmlsec.saml2.core.SAML2NameIdentifier;
import oracle.security.xmlsec.saml2.core.SubjectConfirmationData;
import oracle.security.xmlsec.saml2.util.SAML2Initializer;
import oracle.security.xmlsec.saml2.util.SAML2Utils;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SubjectConfirmation
extends XMLElement {
    private static final String[] nsList = new String[]{"urn:oasis:names:tc:SAML:2.0:assertion", "urn:oasis:names:tc:SAML:2.0:assertion", "urn:oasis:names:tc:SAML:2.0:assertion", "urn:oasis:names:tc:SAML:2.0:assertion"};
    private static final String[] tagList = new String[]{"BaseID", "NameID", "EncryptedID", "SubjectConfirmationData"};

    public SubjectConfirmation(Element element) throws DOMException {
        super(element);
    }

    public SubjectConfirmation(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public SubjectConfirmation(Document owner) throws DOMException {
        super(owner, "urn:oasis:names:tc:SAML:2.0:assertion", "SubjectConfirmation");
        this.addNSPrefixAttrDefault("urn:oasis:names:tc:SAML:2.0:assertion");
    }

    public void setNameIdentifier(SAML2NameIdentifier nameID) {
        XMLUtils.removeChildren((Element)((Element)this.getNode()), (String)"urn:oasis:names:tc:SAML:2.0:assertion", (String)"BaseID");
        XMLUtils.removeChildren((Element)((Element)this.getNode()), (String)"urn:oasis:names:tc:SAML:2.0:assertion", (String)"NameID");
        XMLUtils.removeChildren((Element)((Element)this.getNode()), (String)"urn:oasis:names:tc:SAML:2.0:assertion", (String)"EncryptedID");
        XMLUtils.insertChild((XMLElement)this, (XMLElement)((XMLElement)nameID), (String[])nsList, (String[])tagList);
    }

    public SAML2NameIdentifier getNameIdentifier() throws DOMException {
        XMLElement nid = null;
        nid = (NameID)SAML2Utils.getChildElement(this, "urn:oasis:names:tc:SAML:2.0:assertion", "NameID");
        if (nid != null) {
            return nid;
        }
        nid = (EncryptedID)SAML2Utils.getChildElement(this, "urn:oasis:names:tc:SAML:2.0:assertion", "EncryptedID");
        if (nid != null) {
            return nid;
        }
        nid = (BaseID)SAML2Utils.getChildElement(this, "urn:oasis:names:tc:SAML:2.0:assertion", "BaseID");
        if (nid != null) {
            return nid;
        }
        return null;
    }

    public void setMethod(String confirmationMethod) {
        this.setAttribute("Method", confirmationMethod);
    }

    public String getMethod() {
        if (this.hasAttribute("Method")) {
            return this.getAttribute("Method");
        }
        return null;
    }

    public void setSubjectConfirmationData(SubjectConfirmationData scd) {
        XMLUtils.removeChildren((Element)((Element)this.getNode()), (String)"urn:oasis:names:tc:SAML:2.0:assertion", (String)"SubjectConfirmationData");
        this.appendChild(scd.getNode());
    }

    public SubjectConfirmationData getSubjectConfirmationData() {
        return (SubjectConfirmationData)SAML2Utils.getChildElement(this, "urn:oasis:names:tc:SAML:2.0:assertion", "SubjectConfirmationData");
    }

    static {
        SAML2Initializer.initialize();
    }
}

