/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.saml2.core;

import java.util.List;
import oracle.security.xmlsec.saml2.core.Condition;
import oracle.security.xmlsec.saml2.util.SAML2Utils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ProxyRestriction
extends Condition {
    public ProxyRestriction(Element element) throws DOMException {
        super(element);
    }

    public ProxyRestriction(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public ProxyRestriction(Document owner) throws DOMException {
        super(owner, "urn:oasis:names:tc:SAML:2.0:assertion", "ProxyRestriction");
        this.addNSPrefixAttrDefault("urn:oasis:names:tc:SAML:2.0:assertion");
    }

    protected ProxyRestriction(Document owner, String nsURI, String localName) throws DOMException {
        super(owner, nsURI, localName);
    }

    public void addAudience(String uri) {
        SAML2Utils.appendChildElementWithText(this, "urn:oasis:names:tc:SAML:2.0:assertion", "Audience", uri);
    }

    public List getAudiences() {
        return SAML2Utils.collectTextFromChildren(this, "urn:oasis:names:tc:SAML:2.0:assertion", "Audience");
    }

    public void setCount(int count) {
        if (count < 0) {
            this.setAttribute("Count", Integer.toString(0));
        } else {
            this.setAttribute("Count", Integer.toString(count));
        }
    }

    public int getCount() {
        int c = 0;
        try {
            if (this.hasAttribute("Count")) {
                c = Integer.parseInt(this.getAttribute("Count"));
            }
        }
        catch (NumberFormatException ex) {
            c = 0;
        }
        return c;
    }
}

