/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.saml2.core;

import oracle.security.xmlsec.saml2.util.SAML2Initializer;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Action
extends XMLElement {
    public static final String READ = "Read";
    public static final String WRITE = "Write";
    public static final String EXECUTE = "Execute";
    public static final String DELETE = "Delete";
    public static final String CONTROL = "Control";
    public static final String READ_DENIED = "~Read";
    public static final String WRITE_DENIED = "~Write";
    public static final String EXECUTE_DENIED = "~Execute";
    public static final String DELETE_DENIED = "~Delete";
    public static final String CONTROL_DENIED = "~Control";
    public static final String GET = "GET";
    public static final String HEAD = "HEAD";
    public static final String PUT = "PUT";
    public static final String POST = "POST";

    public Action(Element element) throws DOMException {
        super(element);
    }

    public Action(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public Action(Document owner) throws DOMException {
        super(owner, "urn:oasis:names:tc:SAML:2.0:assertion", "Action");
        this.addNSPrefixAttrDefault("urn:oasis:names:tc:SAML:2.0:assertion");
    }

    public void setNamespace(String uri) {
        this.setAttribute("Namespace", uri);
    }

    public String getNamespace() {
        if (this.hasAttribute("Namespace")) {
            return this.getAttribute("Namespace");
        }
        return null;
    }

    public void setValue(String value) {
        XMLUtils.removeAllChildren((Node)this.getNode());
        this.appendChild(this.getOwnerDocument().createTextNode(value));
    }

    public String getValue() {
        return XMLUtils.collectText((Node)this.getNode());
    }

    static {
        SAML2Initializer.initialize();
    }
}

