/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.saml2.ac;

import java.util.List;
import oracle.security.xmlsec.saml2.ac.Extension;
import oracle.security.xmlsec.saml2.ac.PrivateKeyProtection;
import oracle.security.xmlsec.saml2.ac.Protection;
import oracle.security.xmlsec.saml2.ac.SecretKeyProtection;
import oracle.security.xmlsec.saml2.util.SAML2Initializer;
import oracle.security.xmlsec.saml2.util.SAML2Utils;
import oracle.security.xmlsec.util.XMLElement;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TechnicalProtection
extends XMLElement {
    public TechnicalProtection(Element element) throws DOMException {
        super(element);
    }

    public TechnicalProtection(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public TechnicalProtection(Document owner, String nsURI) throws DOMException {
        super(owner, nsURI, "TechnicalProtection");
        String prefix = XMLElement.getDefaultNSPrefix((String)nsURI);
        if (prefix != null && prefix.length() > 0) {
            this.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, nsURI);
        } else {
            this.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", nsURI);
        }
    }

    protected TechnicalProtection(Document owner, String nsURI, String localName) throws DOMException {
        super(owner, nsURI, localName);
        String prefix = XMLElement.getDefaultNSPrefix((String)nsURI);
        if (prefix != null && prefix.length() > 0) {
            this.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, nsURI);
        } else {
            this.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", nsURI);
        }
    }

    public void setProtection(Protection pkp) {
        Node n = this.getFirstChild();
        if (n == null) {
            this.appendChild(((XMLElement)pkp).getNode());
        } else if (n.getNamespaceURI().equals(this.getNamespaceURI()) && n.getLocalName().equals("Extension")) {
            this.insertBefore(((XMLElement)pkp).getNode(), n);
        } else {
            this.replaceChild(((XMLElement)pkp).getNode(), n);
        }
    }

    public PrivateKeyProtection getPrivateKeyProtection() {
        return (PrivateKeyProtection)SAML2Utils.getChildElement(this, this.getNamespaceURI(), "PrivateKeyProtection");
    }

    public SecretKeyProtection getSecretKeyProtection() {
        return (SecretKeyProtection)SAML2Utils.getChildElement(this, this.getNamespaceURI(), "SecretKeyProtection");
    }

    public void addExtension(Extension extn) {
        this.appendChild(extn.getNode());
    }

    public List getExtensions() {
        return SAML2Utils.getChildElements(this, this.getNamespaceURI(), "Extension");
    }

    static {
        SAML2Initializer.initialize();
    }
}

