/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.saml2.ac;

import oracle.security.xmlsec.saml2.util.SAML2Initializer;
import oracle.security.xmlsec.util.XMLElement;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Generation
extends XMLElement {
    public Generation(Element element) throws DOMException {
        super(element);
    }

    public Generation(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    protected Generation(Document owner, String nsURI) throws DOMException {
        super(owner, nsURI, "Generation");
        String prefix = XMLElement.getDefaultNSPrefix((String)nsURI);
        if (prefix != null && prefix.length() > 0) {
            this.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, nsURI);
        } else {
            this.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", nsURI);
        }
    }

    protected Generation(Document owner, String nsURI, String localName) throws DOMException {
        super(owner, nsURI, localName);
        String prefix = XMLElement.getDefaultNSPrefix((String)nsURI);
        if (prefix != null && prefix.length() > 0) {
            this.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, nsURI);
        } else {
            this.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", nsURI);
        }
    }

    public void setMechanism(GenerationType mech) {
        this.setAttribute("mechanism", mech.getValue());
    }

    public GenerationType getMechanism() {
        if (this.hasAttribute("mechanism")) {
            return new GenerationType(this.getAttribute("mechanism"));
        }
        return null;
    }

    static {
        SAML2Initializer.initialize();
    }

    public static class GenerationType {
        public static final GenerationType PRINCIPAL_CHOSEN = new GenerationType("principalchosen");
        public static final GenerationType AUTOMATIC = new GenerationType("automatic");
        private String value;

        public GenerationType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return "GenerationType=" + this.value;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(Object o) {
            if (o.getClass().getName().equals(GenerationType.class.getName())) {
                return this.getValue().equals(((GenerationType)o).getValue());
            }
            return false;
        }
    }
}

