/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.hadoop.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.extract.ExtractResources;
import oracle.dbtools.extract.models.ExtractListModel;
import oracle.dbtools.importer.core.ImportProperties;
import oracle.dbtools.raptor.data.ui.ImportSummaryTreeModel;
import oracle.dbtools.raptor.hadoop.core.HadoopKeys;
import oracle.dbtools.raptor.hadoop.core.HadoopProperties;
import oracle.dbtools.raptor.hadoop.execute.OLHExec;
import oracle.dbtools.raptor.hadoop.ui.HadoopWizArb;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.icons.OracleIcons;

public class OLHIWizSummaryPage
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 1L;
    protected JTree _summaryTree = new JTree();
    private JTabbedPane _summaryTabbedPane = new JTabbedPane();
    private JTextComponent _scriptPane;
    private HadoopProperties _hProps;
    ExtractListModel _listModel;
    private OLHExec _olhExec = new OLHExec();

    public OLHIWizSummaryPage() {
        this.build();
    }

    public void build() {
        this.setLayout(new BorderLayout());
        this._summaryTree.setCellRenderer(new NodeRenderer());
        this._summaryTabbedPane.add(HadoopWizArb.getString("SUMMARY_SUMMARY_TITLE"), new JScrollPane(this._summaryTree, 20, 30));
        this._scriptPane = this.createTextPane(false);
        this._summaryTabbedPane.add(HadoopWizArb.getString("SUMMARY_SCRIPT_TITLE"), new JScrollPane(this._scriptPane, 20, 30));
        this.add(this._summaryTabbedPane, "Center");
    }

    private JTextComponent createTextPane(boolean bl) {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setLineWrap(bl);
        jTextArea.setWrapStyleWord(bl);
        jTextArea.setEditable(false);
        return jTextArea;
    }

    public void onEntry(TraversableContext traversableContext) {
        this._listModel = (ExtractListModel)traversableContext.get("EXTRACT_LIST_MODEL");
        this._hProps = (HadoopProperties)((Object)traversableContext.get("HADOOP_PROPERTIES"));
        ExitCode exitCode = this._olhExec.start(this._hProps);
        String string = this._olhExec.getScript();
        this._hProps.put(HadoopKeys.SCRIPT, string);
        this._scriptPane.setText(string);
        this._summaryTree.removeAll();
        this._summaryTree.setModel(this.getSummaryTreeModel(HadoopWizArb.getString("STEP_SUMMARY")));
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (traversableContext.getDirection() == 1) {
            this._olhExec.doExec();
        }
    }

    public DefaultTreeModel getSummaryTreeModel(String string) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string);
        boolean bl = ((String)this._hProps.get(HadoopKeys.SOURCE_TYPE)).equals(HadoopWizArb.getString("HIVE_TABLE"));
        boolean bl2 = ((String)this._hProps.get(HadoopKeys.SOURCE_TYPE)).equals(HadoopWizArb.getString("TEXT"));
        boolean bl3 = ((String)this._hProps.get(HadoopKeys.SOURCE_TYPE)).equals("AVRO");
        String string2 = HadoopWizArb.getString("HIVE_TABLE");
        if (bl2) {
            string2 = HadoopWizArb.getString("TEXT");
        } else if (bl3) {
            string2 = "AVRO";
        }
        defaultMutableTreeNode.add(ImportSummaryTreeModel.getConnectionNode((ImportProperties)this._hProps));
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(StringUtils.stripMnemonic((String)HadoopWizArb.getString("SOURCE_TYPE")) + " " + string2);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        if (bl) {
            defaultMutableTreeNode2.add(this.getSourceConnectionNode());
        }
        if (bl2 || bl3) {
            defaultMutableTreeNode2.add(ImportSummaryTreeModel.getFileNode((ImportProperties)this._hProps));
            defaultMutableTreeNode2.add(ImportSummaryTreeModel.getSelectedFields((ImportProperties)this._hProps));
            defaultMutableTreeNode2.add(ImportSummaryTreeModel.getSelectableFields((ImportProperties)this._hProps));
        }
        return new DefaultTreeModel(defaultMutableTreeNode);
    }

    private DefaultMutableTreeNode getSourceConnectionNode() {
        String string = (String)this._hProps.get(HadoopKeys.SOURCE_CONN_NAME);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(HadoopWizArb.getString("SUMMARY_NODE_SOURCE_CONN"));
        if (string != null) {
            JLabel jLabel = new JLabel();
            String string2 = Connections.getDisplayName((String)string);
            jLabel.setText(HadoopWizArb.getString("SUMMARY_NODE_SOURCE_CONN") + ": " + string2);
            jLabel.setIcon(ExtractResources.getIcon((String)"CONNECTION_ICON"));
            defaultMutableTreeNode = new DefaultMutableTreeNode(jLabel);
            JLabel jLabel2 = new JLabel();
            jLabel2.setText(HadoopWizArb.getString("HIVE_TABLE") + ": " + this._hProps.get(HadoopKeys.SOURCE_SCHEMA_NAME) + "." + this._hProps.get(HadoopKeys.SOURCE_TABLE_NAME));
            jLabel2.setIcon(OracleIcons.getIcon((String)"table.png"));
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(jLabel2);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            String string3 = (String)this._hProps.get(HadoopKeys.WHERE);
            if (string3 != null) {
                string3.trim();
                if (!string3.isEmpty()) {
                    JLabel jLabel3 = new JLabel();
                    jLabel3.setText(HadoopWizArb.getString("WHERE") + ": " + string3);
                    jLabel3.setIcon(OracleIcons.getIcon((String)"filter.png"));
                    DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(jLabel3);
                    defaultMutableTreeNode.add(defaultMutableTreeNode3);
                }
            }
        }
        return defaultMutableTreeNode;
    }

    public class NodeRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
            if (object2 instanceof String) {
                jLabel.setText((String)object2);
                if (bl3) {
                    jLabel.setIcon(OracleIcons.getIcon((String)"attribute.png"));
                }
                return jLabel;
            }
            return (Component)object2;
        }
    }
}

