/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.hadoop.ui;

import java.awt.Component;
import java.util.Properties;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.raptor.dialogs.conn.ConnectionInfoPanel;
import oracle.dbtools.raptor.hadoop.core.HadoopKeys;
import oracle.dbtools.raptor.hadoop.core.HadoopProperties;
import oracle.dbtools.raptor.hadoop.core.HadoopUtils;
import oracle.dbtools.raptor.hadoop.ui.HadoopWizArb;
import oracle.dbtools.raptor.models.SQLComboxModel;
import oracle.dbtools.raptor.ui.dialogs.MessageDetailsDialog;
import oracle.dbtools.raptor.utils.ConnectionCanceledException;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.transfer.utility.ScriptOutput;
import oracle.ide.Ide;
import oracle.ide.panels.TraversalException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.db.DatabaseConnections;
import org.apache.sshd.client.session.ClientSession;

public class HadoopUIUtils {
    public static boolean isHostScriptExcutable(ClientSession clientSession) {
        boolean bl = false;
        if (clientSession != null) {
            String string = "sqldev_temp/";
            String string2 = "ls " + string;
            ScriptOutput scriptOutput = HadoopUtils.executeScript(clientSession, string2);
            if (scriptOutput.rc != 0) {
                string2 = "mkdir " + string;
                scriptOutput = HadoopUtils.executeScript(clientSession, string2);
                if (scriptOutput.rc != 0) {
                    String string3 = "STDOUT: " + scriptOutput.stdout + HadoopUtils.getTerm() + "STDERR: " + scriptOutput.stderr + HadoopUtils.getTerm();
                    MessageDetailsDialog messageDetailsDialog = new MessageDetailsDialog();
                    messageDetailsDialog.showErrorDialog(HadoopWizArb.getString("TEMP_DIR_ERROR1"), string3);
                } else {
                    bl = true;
                }
            } else {
                bl = true;
            }
        } else {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)HadoopWizArb.getString("SSH_CONNECT_FAILURE2"), (String)HadoopWizArb.getString("SSH_CONNECT_TITLE"), null);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean updateConnectionInfo(HadoopProperties hadoopProperties, String string) throws TraversalException {
        boolean bl;
        block13: {
            Properties properties = (Properties)hadoopProperties.get(HadoopKeys.ORA_CONN_INFO_CLONE);
            Properties properties2 = (Properties)hadoopProperties.get(HadoopKeys.ORA_CONN_INFO_CLONE);
            String string2 = null;
            if (properties != null) {
                string2 = (String)hadoopProperties.get(HadoopKeys.ORA_CONN_INFO_CLONE_NAME);
            }
            if (!string.equals(string2)) {
                properties2 = Connections.getInstance().getConnectionInfo(string);
                properties = (Properties)properties2.clone();
            }
            String string3 = properties.getProperty("password");
            bl = true;
            try {
                if (string3 == null) {
                    while (bl) {
                        try {
                            ConnectionInfoPanel.promptForConnection((Properties)properties);
                        }
                        catch (ConnectionCanceledException connectionCanceledException) {
                            throw new TraversalException((Object)connectionCanceledException);
                        }
                        catch (Exception exception) {
                            throw new TraversalException((Object)exception);
                        }
                        try {
                            DatabaseConnections.getInstance().testConnection(properties);
                            String string4 = properties.getProperty("password");
                            if (string4 != null) {
                                properties2.setProperty("password", string4);
                            }
                            bl = false;
                        }
                        catch (Exception exception) {
                            properties.remove("password");
                            throw new TraversalException((Object)exception);
                        }
                    }
                    break block13;
                }
                boolean bl2 = true;
                return bl2;
            }
            finally {
                hadoopProperties.put(HadoopKeys.ORA_CONN_INFO_CLONE, properties);
                hadoopProperties.put(HadoopKeys.ORA_CONN_INFO, properties2);
                hadoopProperties.put(HadoopKeys.ORA_CONN_INFO_CLONE_NAME, string);
            }
        }
        return !bl;
    }

    public static JComboBox<String> getSQLCombo(JLabel jLabel) {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.setEnabled(true);
        jLabel.setEnabled(true);
        jLabel.setLabelFor(jComboBox);
        jComboBox.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                Object object = popupMenuEvent.getSource();
                if (object instanceof JComboBox && ((JComboBox)object).getModel() instanceof SQLComboxModel) {
                    ((SQLComboxModel)((JComboBox)object).getModel()).load();
                }
            }
        });
        return jComboBox;
    }

    public static void setOraDirModel(JComboBox<String> jComboBox, String string) {
        HadoopUIUtils.setOraDirModel(jComboBox, string, true);
    }

    public static void setOraDirModel(JComboBox<String> jComboBox, String string, boolean bl) {
        HadoopUIUtils.initSQLComboBox(jComboBox, string, "select DIRECTORY_NAME from all_directories", bl);
    }

    public static void setSchemaModel(JComboBox<String> jComboBox, String string) {
        HadoopUIUtils.initSQLComboBox(jComboBox, string, "show databases", false);
    }

    public static void setTableModel(JComboBox<String> jComboBox, String string, String string2) {
        if (string2 != null && string2.length() > 0) {
            HadoopUIUtils.initSQLComboBox(jComboBox, string, "show tables in " + string2);
        }
    }

    public static void setTableModel(JComboBox<String> jComboBox, String string, String string2, boolean bl) {
        if (string2 != null && string2.length() > 0) {
            HadoopUIUtils.initSQLComboBox(jComboBox, string, "show tables in " + string2, bl);
        }
    }

    private static void initSQLComboBox(JComboBox<String> jComboBox, String string, String string2) {
        HadoopUIUtils.initSQLComboBox(jComboBox, string, string2, true);
    }

    private static void initSQLComboBox(JComboBox<String> jComboBox, String string, String string2, boolean bl) {
        if (string != null && jComboBox != null) {
            SQLComboxModel sQLComboxModel = HadoopUIUtils.getSQLComboModel(string, string2, bl);
            jComboBox.setModel((ComboBoxModel<String>)sQLComboxModel);
        }
    }

    private static SQLComboxModel getSQLComboModel(String string, String string2, boolean bl) {
        SQLComboxModel sQLComboxModel = null;
        if (string != null) {
            sQLComboxModel = new SQLComboxModel(string, string2);
            sQLComboxModel.setDelayed(bl);
        }
        return sQLComboxModel;
    }

    public static DefaultMutableTreeNode getSummaryBooleanItem(String string, boolean bl) {
        JLabel jLabel = new JLabel();
        jLabel.setText(string);
        if (bl) {
            jLabel.setIcon(OracleIcons.getIcon((String)"check.png"));
        } else {
            jLabel.setIcon(OracleIcons.getIcon((String)"delete.png"));
        }
        return new DefaultMutableTreeNode(jLabel);
    }
}

