/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.hadoop.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.importer.core.ImportKeys;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.hadoop.core.HadoopKeys;
import oracle.dbtools.raptor.hadoop.core.HadoopProperties;
import oracle.dbtools.raptor.hadoop.ui.HadoopWizArb;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;

public class BDACopyDirectoriesPanel
extends JPanel {
    private static final long serialVersionUID = -4806824652842858395L;
    private JLabel _oraDirLabel;
    private JComboBox<String> _oraDirCmp;
    private ActionListener _oraDirListener;
    private JLabel _destRootLabel;
    private URLFileChooser.URLFileChooserPanel _destRootPanel;
    Vector<String> _oraDirList;
    boolean _oraDirListenerRemoved = false;
    private HadoopProperties _hProps;

    public JPanel getPanel(HadoopProperties hadoopProperties) {
        this._hProps = hadoopProperties;
        DBConfig dBConfig = DBConfig.getInstance();
        String string = dBConfig.getString("IMPORT_ORA_DIR");
        String string2 = (String)this._hProps.get(ImportKeys.ORADIRNAME);
        if (string2 != null && string2.length() >= 1) {
            this._hProps.put(ImportKeys.ORADIRNAME, string2);
        }
        this.build();
        return this;
    }

    public void onExit() {
        this._hProps.put(ImportKeys.ORADIRNAME, this._oraDirCmp.getSelectedItem());
        this._hProps.put(HadoopKeys.DEST_ROOT_DIR, this._destRootPanel.getText());
    }

    private void build() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.getDirectoryLabel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add(this.getDirectoryValue(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 22, 2, new Insets(0, 8, 0, 0), 0, 0));
        jPanel.add((Component)this.getDestRootLabel(), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 2, new Insets(6, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.getDestRootPanel(), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 22, 2, new Insets(6, 8, 0, 0), 0, 0));
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "Center");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void getDirectories() {
        ResultSet resultSet = null;
        this._oraDirList = new Vector();
        DBObject dBObject = (DBObject)this._hProps.get(ImportKeys.DBOBJECT);
        String string = (String)this._hProps.get(HadoopKeys.SOURCE_CONN);
        if (Connections.getInstance().lock(string)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)dBObject.getConnection());
                resultSet = dBUtil.executeQuery("select DIRECTORY_NAME from all_directories", Collections.EMPTY_MAP);
                while (resultSet.next()) {
                    this._oraDirList.add(resultSet.getString(1));
                }
            }
            catch (SQLException sQLException) {
                DBUtil.closeResultSet(resultSet);
                Connections.getInstance().unlock(dBObject.getConnectionName());
                catch (Throwable throwable) {
                    DBUtil.closeResultSet(resultSet);
                    Connections.getInstance().unlock(dBObject.getConnectionName());
                    throw throwable;
                }
            }
            DBUtil.closeResultSet((ResultSet)resultSet);
            Connections.getInstance().unlock(dBObject.getConnectionName());
        }
    }

    protected JLabel getDirectoryLabel() {
        if (this._oraDirLabel == null) {
            this._oraDirLabel = new JLabel(HadoopWizArb.getString("ORA_DIR"));
            this._oraDirLabel.setToolTipText(HadoopWizArb.getString("ORA_DIR_TIP"));
        }
        return this._oraDirLabel;
    }

    protected JComboBox<String> getDirectoryValue() {
        if (this._oraDirCmp == null) {
            this._oraDirCmp = new JComboBox();
            this._oraDirCmp.setEditable(true);
            this.addOraDirListener();
        }
        return this._oraDirCmp;
    }

    private void addOraDirListener() {
        this._oraDirListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (BDACopyDirectoriesPanel.this._oraDirList == null) {
                    BDACopyDirectoriesPanel.this.getDirectories();
                    BDACopyDirectoriesPanel.this._oraDirList.addAll(BDACopyDirectoriesPanel.this._oraDirList);
                } else if (!BDACopyDirectoriesPanel.this._oraDirListenerRemoved) {
                    BDACopyDirectoriesPanel.this._oraDirCmp.removeActionListener(BDACopyDirectoriesPanel.this._oraDirListener);
                    BDACopyDirectoriesPanel.this._oraDirListenerRemoved = true;
                }
            }
        };
        this._oraDirCmp.addActionListener(this._oraDirListener);
    }

    protected JLabel getDestRootLabel() {
        if (this._destRootLabel == null) {
            this._destRootLabel = new JLabel(HadoopWizArb.getString("ROOT_DIR"));
        }
        return this._destRootLabel;
    }

    protected JComponent getDestRootPanel() {
        if (null == this._destRootPanel) {
            this._destRootPanel = URLFileChooser.createURLFileChooserPanel((int)1, (String)"", (boolean)false);
            this._destRootPanel.setFileSelectionMode(1);
            this._destRootPanel.setPathContext("COPYHADOOP");
            this._destRootPanel.setToolTipText(HadoopWizArb.getString("ROOT_DIR_TIP"));
        }
        return this._destRootPanel;
    }

    public String getRootDir() {
        return this._destRootPanel.getText();
    }
}

