/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.hadoop.execute;

import java.awt.Component;
import java.io.ByteArrayInputStream;
import java.net.URL;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Vector;
import javax.swing.SwingUtilities;
import oracle.dbtools.common.utils.BasicDBObject;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.data.model.LoadField;
import oracle.dbtools.data.model.LoadFile;
import oracle.dbtools.extract.models.ExtractObject;
import oracle.dbtools.importer.ImportResources;
import oracle.dbtools.importer.core.ImportDataFormat;
import oracle.dbtools.importer.core.ImportKeys;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionController;
import oracle.dbtools.raptor.hadoop.core.HadoopEncryption;
import oracle.dbtools.raptor.hadoop.core.HadoopImportDataFormat;
import oracle.dbtools.raptor.hadoop.core.HadoopKeys;
import oracle.dbtools.raptor.hadoop.core.HadoopProperties;
import oracle.dbtools.raptor.hadoop.core.HadoopUtils;
import oracle.dbtools.raptor.hadoop.execute.HadoopExec;
import oracle.dbtools.raptor.hadoop.ui.HadoopWizArb;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.transfer.location.SshLocation;
import oracle.dbtools.transfer.location.SshSessionLocation;
import oracle.dbtools.transfer.utility.ScriptOutput;
import oracle.dbtools.util.Logger;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;

public class OSCHExec
extends HadoopExec {
    public static final int TYPE_DB_OBJECTS = 0;
    public static final int TYPE_QUERY = 1;
    public static final int SUCCESS = 0;
    public static final int WARNING = 1;
    public static final int ERROR = 2;
    private static final String P_CONN_URL = "oracle.hadoop.connection.url=";
    private static final String P_CONN_USER = "oracle.hadoop.connection.user=";
    private static final String P_EXTTAB_COL_NAMES = "oracle.hadoop.exttab.columnNames=";
    private static final String P_EXTTAB_DATA_PATHS = "oracle.hadoop.exttab.dataPaths=";
    private static final String P_EXTTAB_DEFAULT_DIR = "oracle.hadoop.exttab.defaultDirectory=";
    private static final String P_EXTAB_LOG_DIR = "oracle.hadoop.exttab.logDirectory=";
    private static final String P_EXTAB_CREATE_LOG = "oracle.hadoop.exttab.createLogFiles=";
    private static final String P_EXTAB_CREATE_BAD = "oracle.hadoop.exttab.createBadFiles=";
    private static final String P_EXTTAB_TABLE_NAME = "oracle.hadoop.exttab.tableName=";
    private static final String P_FIELD_ENCLOSURE_INITIAL = "oracle.hadoop.exttab.initialFieldEncloser=";
    private static final String P_FIELD_ENCLOSURE_TRAILING = "oracle.hadoop.exttab.trailingFieldEncloser=";
    private static final String P_FIELD_TERM = "oracle.hadoop.exttab.fieldTerminator=";
    private static final String P_HIVE_DBN = "oracle.hadoop.exttab.hive.databaseName=";
    private static final String P_HIVE_TABLE_NAME = "oracle.hadoop.exttab.hive.tableName=";
    private static final String P_HIVE_COLMAP_PREFIX = "oracle.hadoop.exttab.colMap.";
    private static final String P_HIVE_COLMAP_SUFFIX_LENGTH = ".columnLength=";
    private static final String P_HIVE_COLMAP_SUFFIX_TYPE = ".columnType=";
    private static final String P_HIVE_COLMAP_SUFFIX_DATEMASK = ".dateMask=";
    private static final String P_HIVE_COLMAP_SUFFIX_TSMASK = ".timestampMask=";
    private static final String P_HIVE_COLMAP_SUFFIX_TSTZMASK = "timestampTZMask=";
    private static final String P_LOCATION_FILE_COUNT = "oracle.hadoop.exttab.locationFileCount=";
    private static final String P_PART_FILTER = "oracle.hadoop.exttab.hive.partitionFilter=";
    private static final String P_RECORD_DELIM = "oracle.hadoop.exttab.recordDelimiter=";
    private static final String P_SOURCE_TYPE_HIVE = "oracle.hadoop.exttab.sourceType=hive";
    private static final String P_SOURCE_TYPE_TEXT = "oracle.hadoop.exttab.sourceType=text";
    private static final String P_STACK_TRACE = "oracle.hadoop.exttab.printStackTrace=true";
    private static final String P_WALLET_LOC = "oracle.hadoop.connection.wallet_location=${WALLET_LOCATION}";
    private static final String P_WALLET_TNS_ENTRY = "oracle.hadoop.connection.tnsEntryName=";
    private static final String P_WALLET_TNS_ADMIN = "oracle.hadoop.connection.tns_admin=${TNS_ADMIN}";
    private static final String CLASSPATH1 = "setenv HADOOP_CLASSPATH  ";
    private static final String CLASSPATH2 = "/jlib/*\n";
    private static final String MKDIR = "mkdir -p ";
    private static final String ENV = "#!/bin/bash\nsource .sqldev_osch_env\nenv\n";
    private static final String EXEC_OSCH = "hadoop jar  ${OSCH_HOME}/jlib/orahdfs.jar oracle.hadoop.exttab.ExternalTable";
    private static final String EXEC_EXTTAB1 = "hadoop jar ";
    private static final String EXEC_EXTTAB2 = "/jlib/orahdfs.jar oracle.hadoop.exttab.ExternalTable ";
    private static final String CREATE_TABLE = "-createTable";
    private static final String DESCRIBE = "-describe";
    private static final String DROP = "-drop";
    private static final String PUBLISH = "-publish";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String NO_EXEC = " --noexecute\r\n";
    private static final String EXEC = "\r\n";
    private static final String PARM = "-D ";
    private static final String SEP = " \\\n";
    private static final SimpleDateFormat S_DATEFORMAT = new SimpleDateFormat("yyyyMMddHHmmss");
    protected final String ENCODING_UTF8 = "UTF-8";
    private RaptorTask<Void> _task = null;
    private ExtractObject _EO;
    private BasicDBObject _dbo;
    private LoadFile _loadFile;
    boolean _isExistingTable;
    boolean _isCleanupNeeded = false;
    boolean _isSuccess = true;
    boolean _isStaging;
    boolean _isDropStaging;
    boolean _isWallet;
    private String _ddl;
    private String _script;
    private String _tempDir;
    private String _tempName;
    private String _where;
    private String _xmlName;
    private String _xml;
    private ScriptOutput _result;

    @Override
    public ExitCode start(HadoopProperties hadoopProperties) {
        this._isExistingTable = (Boolean)hadoopProperties.get(ImportKeys.IS_EXISTING_TABLE);
        String string = (String)hadoopProperties.get(HadoopKeys.LOAD_METHOD_NAME);
        if (string != null) {
            this._isStaging = string.equals(HadoopImportDataFormat.METHOD_STAGING_EXTERNAL_TABLE_NAME);
            if (this._isStaging) {
                this._isDropStaging = hadoopProperties.getValueBoolean(ImportKeys.DROP_STAGING_TABLE);
            }
            this._isStaging = string.equals(HadoopImportDataFormat.METHOD_STAGING_EXTERNAL_TABLE_NAME);
        }
        this._logPrefix = HadoopWizArb.getString("OSCH_EXEC_LOG_PREFIX");
        this._tempDir = "sqldev_temp/";
        this._tempName = HadoopUtils.getTempName("sqldev_osch");
        this._exitCode = super.start(hadoopProperties);
        this._destUser = HadoopUtils.getOracleUser(this._hProps);
        this._destConnUrl = HadoopUtils.getOracleUrl(this._hProps);
        this.openLog(true);
        this._script = null;
        return this._exitCode;
    }

    public ExitCode doTest() {
        this.doOSCH(true);
        this.deleteDeploy();
        this.log(this.getFinalMessage());
        return this._exitCode;
    }

    @Override
    public ExitCode doExec() {
        this.openLog();
        this.doWithRaptorTask();
        return this._exitCode;
    }

    public void doOSCH(boolean bl) {
        String string = (String)this._hProps.get(HadoopKeys.SOURCE_TYPE);
        this._loadFile = (LoadFile)this._hProps.get(ImportKeys.LOAD_FILE);
        this._EO = (ExtractObject)this._hProps.get(HadoopKeys.EXTRACT_OBJECT);
        String string2 = HadoopWizArb.format("OSCH_EXEC_STEP_CREATE_DEST", this._destConnDisplayName);
        this.setMessage(string2);
        this.log("\n" + HadoopWizArb.format("OSCH_EXEC_STEP_START", string2));
        if (this._EO != null) {
            this._dbo = this._EO.getDBObject();
        }
        if (this._script == null) {
            this._script = string != null && string.equals(HadoopWizArb.getString("HIVE_TABLE")) ? this.getHiveScript(bl) : this.getTextScript(bl);
        }
        this.executeAsScript(this._script);
        this.log("*** SCRIPT ***\n" + this._script + "\n\n" + this.getFormattedOutput(this._result));
        int n = this._result.stdout.indexOf("CREATE TABLE");
        if (n == -1) {
            n = this._result.stdout.indexOf("create table \"");
        }
        if (bl && n != -1) {
            int n2 = this._result.stdout.indexOf("$ exit $");
            this._ddl = this._result.stdout.substring(n, n2 != -1 ? n2 : this._result.stdout.length());
            int n3 = this._ddl.lastIndexOf("\n");
            this._ddl.substring(0, n3 != -1 ? n3 : this._ddl.length());
        }
        string2 = HadoopWizArb.format("OSCH_EXEC_STEP_CREATE_DEST", this._destConnDisplayName);
        this.log("\n" + HadoopWizArb.format("OSCH_EXEC_STEP_END", this._result.rc == 0 ? HadoopWizArb.getString("OSCH_EXEC_SUCCESS") : HadoopWizArb.getString("OSCH_EXEC_FAIL"), string2));
        this.setMessage(string2);
        ExitCode exitCode = ExitCode.EXIT_SUCCESS;
        if (this._result.rc != 0) {
            exitCode = ExitCode.EXIT_ERROR;
            this.signalCancel();
            this.setExitCodeHighest(exitCode);
        }
    }

    private String getHiveScript(boolean bl) {
        String string = "${OSCH_HOME}";
        StringBuilder stringBuilder = new StringBuilder(EXEC_EXTTAB1 + string + "/jlib/orahdfs.jar oracle.hadoop.exttab.ExternalTable  \\\n");
        stringBuilder.append("-D oracle.hadoop.exttab.sourceType=hive \\\n");
        stringBuilder.append("-D oracle.hadoop.exttab.hive.databaseName=\"" + this._dbo.getSchemaName() + "\" \\\n");
        stringBuilder.append("-D oracle.hadoop.exttab.hive.tableName=\"" + this._dbo.getObjectName() + "\" \\\n");
        stringBuilder.append("-D oracle.hadoop.exttab.tableName=\"" + this._destDbo.getSchemaName() + "\"." + (this._isStaging ? (String)this._hProps.get(ImportKeys.STAGING_TABLE_NAME) : (String)this._hProps.get(ImportKeys.TABLE_NAME)) + SEP);
        stringBuilder.append("-D oracle.hadoop.exttab.locationFileCount=" + this._hProps.getValueInteger(HadoopKeys.PARALLEL) + SEP);
        this.doDirs(stringBuilder);
        this._where = (String)this._hProps.get(HadoopKeys.WHERE);
        if (this._where != null) {
            this._where.trim();
            if (!this._where.isEmpty()) {
                stringBuilder.append("-D oracle.hadoop.exttab.hive.partitionFilter='" + this._where + " ' \\\n");
            }
        }
        this.doColumns(stringBuilder);
        this.doCredentials(stringBuilder);
        stringBuilder.append(CREATE_TABLE + (bl ? NO_EXEC : EXEC));
        return stringBuilder.toString();
    }

    private String getTextScript(boolean bl) {
        String string;
        String string2 = "${OSCH_HOME}";
        StringBuilder stringBuilder = new StringBuilder(EXEC_EXTTAB1 + string2 + "/jlib/orahdfs.jar oracle.hadoop.exttab.ExternalTable  \\\n");
        stringBuilder.append("-D oracle.hadoop.exttab.sourceType=text \\\n");
        stringBuilder.append("-D oracle.hadoop.exttab.dataPaths=" + (String)this._hProps.get(HadoopKeys.SOURCE_ROOT_DIR) + SEP);
        ImportDataFormat importDataFormat = (ImportDataFormat)this._hProps.get(ImportKeys.IMPORT_DATA_FORMAT);
        String string3 = importDataFormat.getDelimiterValue();
        if (!string3.equals("\t")) {
            stringBuilder.append("-D oracle.hadoop.exttab.fieldTerminator=\"" + string3 + "\" \\\n");
        } else {
            stringBuilder.append("-D oracle.hadoop.exttab.fieldTerminator=\"\\u0009\" \\\n");
        }
        String string4 = importDataFormat.getEnclosureLeftValue();
        String string5 = importDataFormat.getEnclosureRightValue();
        if (string4 != null && !string4.isEmpty()) {
            if (string4.equals("\"")) {
                stringBuilder.append("-D oracle.hadoop.exttab.initialFieldEncloser=0x22 \\\n");
            } else {
                stringBuilder.append("-D oracle.hadoop.exttab.initialFieldEncloser=\"" + string4 + "\" \\\n");
            }
            if (string5.equals("\"")) {
                stringBuilder.append("-D oracle.hadoop.exttab.trailingFieldEncloser=0x22 \\\n");
            } else {
                stringBuilder.append("-D oracle.hadoop.exttab.trailingFieldEncloser=\"" + string5 + "\" \\\n");
            }
        }
        if (!(string = importDataFormat.getRecordTerminatorValue()).equals("\n")) {
            if (string.equals(EXEC)) {
                stringBuilder.append("-D oracle.hadoop.exttab.recordDelimiter=\"\\u000d\\u000a\" \\\n");
            } else if (string.equals("\r")) {
                stringBuilder.append("-D oracle.hadoop.exttab.recordDelimiter=\"\\u000d\" \\\n");
            } else {
                stringBuilder.append("-D oracle.hadoop.exttab.recordDelimiter=\"" + string + "\" \\\n");
            }
        }
        this.doColumnNames(stringBuilder);
        this.doColumns(stringBuilder);
        stringBuilder.append("-D oracle.hadoop.exttab.tableName=\"" + this._destDbo.getSchemaName() + "\"." + (this._isStaging ? (String)this._hProps.get(ImportKeys.STAGING_TABLE_NAME) : (String)this._hProps.get(ImportKeys.TABLE_NAME)) + SEP);
        stringBuilder.append("-D oracle.hadoop.exttab.locationFileCount=" + this._hProps.getValueInteger(HadoopKeys.PARALLEL) + SEP);
        this.doDirs(stringBuilder);
        this.doCredentials(stringBuilder);
        stringBuilder.append(CREATE_TABLE + (bl ? NO_EXEC : EXEC));
        return stringBuilder.toString();
    }

    public void finish() {
        this.closeLog();
    }

    public ExitCode doScriptUtility(Action action) {
        this._destDbo = this._dbo = (DBObject)this._hProps.get(ImportKeys.DBOBJECT);
        switch (action) {
            case ACTION_DESCRIBE: {
                this._script = this.getDescribeScript();
                break;
            }
            case ACTION_PUBLISH: {
                this._script = this.getPublishScript();
                break;
            }
            case ACTION_DROP: {
                this._script = this.getDropScript();
                break;
            }
        }
        return this._exitCode;
    }

    public ExitCode doExecUtility(Action action) {
        this.openLog(true);
        this._cancel = false;
        this._destDbo = this._dbo = (DBObject)this._hProps.get(ImportKeys.DBOBJECT);
        String string = "\"" + this._dbo.getSchemaName() + "\".\"" + this._dbo.getObjectName() + "\"";
        String string2 = HadoopWizArb.format("OSCH_EXEC_STEP_DESCRIBE", string);
        this.log("\n" + HadoopWizArb.format("OSCH_EXEC_STEP_START", string2));
        if (this._script == null) {
            this.doScriptUtility(action);
        }
        this.executeAsScript(this._script);
        this.log("*** SCRIPT ***\n" + this._script + "\n\n" + this.getFormattedOutput(this._result));
        ExitCode exitCode = ExitCode.EXIT_SUCCESS;
        if (this._result.rc != 0) {
            exitCode = ExitCode.EXIT_ERROR;
            this.signalCancel();
            this.setExitCodeHighest(exitCode);
        }
        this.deleteDeploy();
        String string3 = this.getFinalMessage();
        this.log(string3);
        if (action == Action.ACTION_DROP) {
            this.getPostProcessCallback().run();
            this.getPostProcessDropViewCallback().run();
        }
        return this._exitCode;
    }

    private String getDescribeScript() {
        StringBuilder stringBuilder = this.getUtilityScriptBase();
        stringBuilder.append(DESCRIBE);
        return stringBuilder.toString();
    }

    private String getDropScript() {
        StringBuilder stringBuilder = this.getUtilityScriptBase();
        stringBuilder.append(DROP);
        return stringBuilder.toString();
    }

    private String getPublishScript() {
        StringBuilder stringBuilder = this.getUtilityScriptBase();
        stringBuilder.append("-D oracle.hadoop.exttab.dataPaths=" + (String)this._hProps.get(HadoopKeys.SOURCE_ROOT_DIR) + SEP);
        stringBuilder.append(PUBLISH);
        return stringBuilder.toString();
    }

    private StringBuilder getUtilityScriptBase() {
        String string = "\"" + this._dbo.getSchemaName() + "\".\"" + this._dbo.getObjectName() + "\"";
        return this.getUtilityScriptBase(string);
    }

    private StringBuilder getUtilityScriptBase(String string) {
        String string2 = "${OSCH_HOME}";
        StringBuilder stringBuilder = new StringBuilder(EXEC_EXTTAB1 + string2 + "/jlib/orahdfs.jar oracle.hadoop.exttab.ExternalTable  \\\n");
        stringBuilder.append("-D oracle.hadoop.exttab.tableName=" + string + SEP);
        this.doCredentials(stringBuilder);
        return stringBuilder;
    }

    private void doColumnNames(StringBuilder stringBuilder) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this._loadFile.getFieldCount();
        if (this._loadFile != null) {
            for (LoadField loadField : this._loadFile.getFields()) {
                stringBuffer.append(loadField.getColumn().getName());
                if (--n == 0) continue;
                stringBuffer.append(",");
            }
        }
        stringBuilder.append("-D oracle.hadoop.exttab.columnNames=" + stringBuffer + SEP);
    }

    private void doDirs(StringBuilder stringBuilder) {
        stringBuilder.append("-D oracle.hadoop.exttab.defaultDirectory=" + (String)this._hProps.get(ImportKeys.ORADIRNAME) + SEP);
        if (this._hProps.getValueBoolean(ImportKeys.USELOGFILE).booleanValue()) {
            stringBuilder.append("-D oracle.hadoop.exttab.createLogFiles=true \\\n");
            stringBuilder.append("-D oracle.hadoop.exttab.logDirectory=" + (String)this._hProps.get(ImportKeys.LOGDIRNAME) + SEP);
        } else {
            stringBuilder.append("-D oracle.hadoop.exttab.createLogFiles=false \\\n");
        }
        if (this._hProps.getValueBoolean(ImportKeys.USEBADFILE).booleanValue()) {
            stringBuilder.append("-D oracle.hadoop.exttab.createBadFiles=true \\\n");
        } else {
            stringBuilder.append("-D oracle.hadoop.exttab.createBadFiles=false \\\n");
        }
    }

    private void doColumns(StringBuilder stringBuilder) {
        if (this._loadFile != null) {
            for (LoadField loadField : this._loadFile.getFields()) {
                Column column = loadField.getColumn();
                stringBuilder.append("-D oracle.hadoop.exttab.colMap." + column.getName() + P_HIVE_COLMAP_SUFFIX_TYPE + column.getType() + SEP);
                if (column.getType().equals("VARCHAR2") || column.getType().equals("CHAR") || column.getType().equals("NCHAR") || column.getType().equals("NVARCHAR2") || column.getType().equals("RAW")) {
                    if (column.getPrecision() == 0) continue;
                    stringBuilder.append("-D oracle.hadoop.exttab.colMap." + column.getName() + P_HIVE_COLMAP_SUFFIX_LENGTH + column.getPrecision() + SEP);
                    continue;
                }
                if (column.getType().equals("DATE")) {
                    stringBuilder.append("-D oracle.hadoop.exttab.colMap." + column.getName() + ".dateMask=\"" + column.getFormat() + "\" \\\n");
                    continue;
                }
                if (column.getType().equals("TIMESTAMP")) {
                    stringBuilder.append("-D oracle.hadoop.exttab.colMap." + column.getName() + ".timestampMask=\"" + column.getFormat() + "\" \\\n");
                    continue;
                }
                if (!column.getType().equals("TIMESTAMP")) continue;
                stringBuilder.append("-D oracle.hadoop.exttab.colMap." + column.getName() + "timestampTZMask=\"" + column.getFormat() + "\" \\\n");
            }
        }
    }

    private void doCredentials(StringBuilder stringBuilder) {
        this._isWallet = (Boolean)this._hProps.get(HadoopKeys.IS_USE_WALLET);
        if (this._isWallet) {
            stringBuilder.append("-D oracle.hadoop.connection.wallet_location=${WALLET_LOCATION} \\\n");
            stringBuilder.append("-D oracle.hadoop.connection.tns_admin=${TNS_ADMIN} \\\n");
            stringBuilder.append("-D oracle.hadoop.connection.tnsEntryName=" + (String)this._hProps.get(HadoopKeys.WALLET_CREDENTIAL) + SEP);
        } else {
            stringBuilder.append("-D oracle.hadoop.connection.url=" + this._destConnUrl + SEP);
            stringBuilder.append("-D oracle.hadoop.connection.user=" + this._destUser + SEP);
            this.setPasswordXml();
            stringBuilder.append("-conf " + this._xmlName + SEP);
        }
    }

    private void setPasswordXml() {
        String string = HadoopEncryption.getRandomUUID();
        String string2 = this._destDbo.getSchemaName() + "." + (this._isStaging ? (String)this._hProps.get(ImportKeys.STAGING_TABLE_NAME) : (String)this._hProps.get(ImportKeys.TABLE_NAME));
        String string3 = HadoopEncryption.encryptPassword(HadoopUtils.getOraclePass(this._hProps), string, HadoopEncryption.getOSCHSalt(string2));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version=\"1.0\"?>" + this.getTerm());
        stringBuffer.append("  <configuration>" + this.getTerm());
        stringBuffer.append("    <property>" + this.getTerm());
        stringBuffer.append("      <name>oracle.hadoop.connection.system.id</name>" + this.getTerm());
        stringBuffer.append("      <value>" + string + "</value>" + this.getTerm());
        stringBuffer.append("    </property>" + this.getTerm());
        stringBuffer.append("    <property>" + this.getTerm());
        stringBuffer.append("      <name>oracle.hadoop.connection.encryptedPassword</name>" + this.getTerm());
        stringBuffer.append("      <value>" + string3 + "</value>" + this.getTerm());
        stringBuffer.append("    </property>" + this.getTerm());
        stringBuffer.append("  </configuration>" + this.getTerm());
        this._xml = stringBuffer.toString();
        this._xmlName = this._tempDir + this._tempName + "_conf.xml";
    }

    private void doStaging() {
        if (this._isStaging) {
            String string = "\"" + this._destDbo.getSchemaName() + "\"." + (String)this._hProps.get(ImportKeys.TABLE_NAME);
            String string2 = "\"" + this._destDbo.getSchemaName() + "\"." + (String)this._hProps.get(ImportKeys.STAGING_TABLE_NAME);
            String string3 = HadoopWizArb.format("OSCH_EXEC_STEP_STAGING", string, string2);
            this.log("\n" + HadoopWizArb.format("OSCH_EXEC_STEP_START", string3));
            this.setMessage(string3);
            if (this._hProps.getValueBoolean(HadoopKeys.IS_SOURCE_PARTITIONED).booleanValue()) {
                Object object;
                Vector<String> vector = HadoopUtils.getPartitionViews(this._destConnName, string2);
                boolean bl = true;
                boolean bl2 = false;
                boolean bl3 = false;
                ExitCode exitCode = ExitCode.EXIT_SUCCESS;
                String string4 = "";
                for (String string5 : vector) {
                    String string6;
                    if (bl) {
                        bl = false;
                        string6 = "CREATE TABLE " + string + " AS SELECT * FROM \"" + string5 + "\"";
                        this.log(string6);
                        string4 = HadoopUtils.execDDL(this._destConn, this._destConnDisplayName, string6);
                        if (string4 == null) {
                            bl3 = true;
                            continue;
                        }
                        bl2 = true;
                        this.log(HadoopWizArb.format("OSCH_EXEC_CREATE_TABLE_FAILED", string, string2, string4));
                        exitCode = ExitCode.EXIT_WARNING;
                        this.setExitCodeHighest(ExitCode.EXIT_WARNING);
                        continue;
                    }
                    if (bl2) break;
                    string6 = "insert into " + string + " select * from \"" + string5 + "\"";
                    this.log(string6);
                    this.setMessage(string6);
                    string4 = HadoopUtils.execUpdate(this._destConnName, string6);
                    if (string4 == null) continue;
                    bl2 = true;
                    this.log(HadoopWizArb.format("OSCH_EXEC_INSERT_FAILED", string, string4, string5));
                    exitCode = ExitCode.EXIT_WARNING;
                    this.setExitCodeHighest(ExitCode.EXIT_WARNING);
                }
                if (bl2) {
                    object = "DROP TABLE " + string + " PURGE";
                    this.log((String)object);
                    this.setMessage((String)object);
                    string4 = HadoopUtils.execDDL(this._destConn, this._destConnDisplayName, (String)object);
                    if (string4 != null) {
                        bl2 = true;
                        this.log(HadoopWizArb.format("OSCH_EXEC_DROP_TABLE_FAILED", string, string4));
                        exitCode = ExitCode.EXIT_WARNING;
                        this.setExitCodeHighest(ExitCode.EXIT_WARNING);
                    }
                }
                try {
                    if (bl3) {
                        this._destConn.commit();
                    }
                }
                catch (SQLException sQLException) {
                    this.log(HadoopWizArb.format("OSCH_EXEC_COMMIT_FAILED", sQLException.getMessage()));
                    this.setExitCodeHighest(ExitCode.EXIT_WARNING);
                }
                if (this._hProps.getValueBoolean(ImportKeys.DROP_STAGING_TABLE).booleanValue()) {
                    object = this.getUtilityScriptBase(string2);
                    ((StringBuilder)object).append(DROP);
                    this.setMessage("-drop " + string2);
                    this._script = ((StringBuilder)object).toString();
                    this.executeAsScript(this._script, 2);
                    this.log("*** SCRIPT ***\n" + this._script + "\n\n" + this.getFormattedOutput(this._result));
                    exitCode = ExitCode.EXIT_SUCCESS;
                    if (this._result.rc != 0) {
                        exitCode = ExitCode.EXIT_ERROR;
                        this.signalCancel();
                        this.setExitCodeHighest(exitCode);
                    }
                    this.deleteDeploy(2);
                }
                this.log("\n" + HadoopWizArb.format("OSCH_EXEC_STEP_END", exitCode == ExitCode.EXIT_SUCCESS ? HadoopWizArb.getString("OSCH_EXEC_SUCCESS") : HadoopWizArb.getString("OSCH_EXEC_WARN"), string3));
            } else {
                String string7 = "CREATE TABLE " + string + " AS SELECT * FROM " + string2;
                String string8 = "DROP TABLE " + string2;
                ExitCode exitCode = ExitCode.EXIT_SUCCESS;
                boolean bl = false;
                this.log(string7);
                this.setMessage(string7);
                String string9 = HadoopUtils.execDDL(this._destConn, this._destConnDisplayName, string7);
                if (string9 != null) {
                    this.log(HadoopWizArb.format("OSCH_EXEC_CREATE_TABLE_FAILED", string, string2, string9));
                    exitCode = ExitCode.EXIT_WARNING;
                    this.setExitCodeHighest(ExitCode.EXIT_WARNING);
                } else if (this._hProps.getValueBoolean(ImportKeys.DROP_STAGING_TABLE).booleanValue()) {
                    bl = true;
                    this.log(string8);
                    this.setMessage(string8);
                    string9 = HadoopUtils.execDDL(this._destConn, this._destConnDisplayName, string8);
                    if (string9 != null) {
                        this.log(HadoopWizArb.format("OSCH_EXEC_DROP_STAGING_FAILED", string2, string9));
                        exitCode = ExitCode.EXIT_WARNING;
                        this.setExitCodeHighest(ExitCode.EXIT_WARNING);
                    }
                } else {
                    bl = true;
                }
                try {
                    if (bl) {
                        this._destConn.commit();
                    }
                }
                catch (SQLException sQLException) {
                    this.log(HadoopWizArb.format("OSCH_EXEC_COMMIT_FAILED", sQLException.getMessage()));
                    this.setExitCodeHighest(ExitCode.EXIT_WARNING);
                }
                this.log("\n" + HadoopWizArb.format("OSCH_EXEC_STEP_END", exitCode == ExitCode.EXIT_SUCCESS ? HadoopWizArb.getString("OSCH_EXEC_SUCCESS") : HadoopWizArb.getString("OSCH_EXEC_WARN"), string3));
            }
        }
    }

    public String getScript() {
        return this._script;
    }

    public String getDDL() {
        return this._ddl;
    }

    public void doWithRaptorTask() {
        String string = HadoopWizArb.getString("OSCH_MAIN_TITLE");
        this._task = new RaptorTask<Void>(string, true, IRaptorTaskRunMode.MODAL_OPTIONAL){

            public Void doWork() {
                try {
                    OSCHExec.this.doOSCH(false);
                    ExitCode exitCode = ExitCode.EXIT_SUCCESS;
                    if (OSCHExec.this._result.rc != 0) {
                        exitCode = ExitCode.EXIT_ERROR;
                        OSCHExec.this.signalCancel();
                        OSCHExec.this.setExitCodeHighest(exitCode);
                    } else {
                        OSCHExec.this.doStaging();
                    }
                    OSCHExec.this.deleteDeploy();
                }
                catch (Exception exception) {
                    Logger.warn(((Object)((Object)this)).getClass(), (String)exception.getStackTrace()[0].toString(), (Throwable)exception);
                }
                this.finish();
                return null;
            }

            public boolean cancel() {
                OSCHExec.this._cancel = true;
                return true;
            }

            public String getConnectionName() {
                return OSCHExec.this._srcConnName;
            }

            public String getQuery() {
                return "";
            }

            private void finish() {
                String string = OSCHExec.this.getFinalMessage();
                OSCHExec.this.log(string);
                OSCHExec.this.closeLog();
                try {
                    HadoopExec.openLogNode(OSCHExec.this.getLogFile().toURI().toURL());
                }
                catch (Exception exception) {
                    Logger.warn(((Object)((Object)this)).getClass(), (String)exception.getStackTrace()[0].toString(), (Throwable)exception);
                }
                if (!OSCHExec.this._isExistingTable) {
                    OSCHExec.this.getPostProcessCallback().run();
                    if (OSCHExec.this._hProps.getValueBoolean(HadoopKeys.IS_SOURCE_PARTITIONED).booleanValue()) {
                        OSCHExec.this.getPostProcessViewCallback().run();
                    }
                }
                Logger.info(((Object)((Object)this)).getClass(), (String)string);
                this.showFinalMsg(string);
            }

            private void showFinalMsg(String string) {
                final String string2 = string == null || string.length() == 0 ? "" : string;
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            MessageDialog.information((Component)Ide.getMainWindow(), (Object)string2, (String)ImportResources.getString((String)"TASK_SHORT_NAME"), null);
                        }
                        catch (Exception exception) {
                            Logger.warn(this.getClass(), (String)exception.getStackTrace()[0].toString(), (Throwable)exception);
                        }
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        };
        this._task.setCancellable(true);
        this._task.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                OSCHExec.this._task = null;
            }
        });
        RaptorTaskManager.getInstance().addTask(this._task);
    }

    private ObjectActionController.ObjectActionPostProcess getPostProcessCallback() {
        ObjectAction objectAction = (ObjectAction)this._hProps.get(ImportKeys.OBJECTACTION);
        objectAction.setReload(true);
        DBObject dBObject = (DBObject)this._hProps.get(ImportKeys.DBOBJECT);
        ObjectActionController.ObjectActionPostProcess objectActionPostProcess = ObjectActionController.getPostProcessCallback((ObjectAction)objectAction, (DBObject)dBObject);
        return objectActionPostProcess;
    }

    private ObjectActionController.ObjectActionPostProcess getPostProcessViewCallback() {
        ObjectAction objectAction = (ObjectAction)this._hProps.get(ImportKeys.OBJECTACTION);
        objectAction.setReload(true);
        DBObject dBObject = (DBObject)this._hProps.get(ImportKeys.DBOBJECT);
        URL uRL = DBURLFormatHelper.getURL((String)"sqldev.nav", (String)dBObject.getConnectionName(), null, (String)dBObject.getSchemaName(), (String)"VIEW");
        URL uRL2 = DBURLFormatHelper.getURL((URL)uRL, (String)dBObject.getObjectName());
        DBObject dBObject2 = new DBObject(uRL);
        ObjectActionController.ObjectActionPostProcess objectActionPostProcess = ObjectActionController.getPostProcessCallback((ObjectAction)objectAction, (DBObject)dBObject2);
        return objectActionPostProcess;
    }

    private ObjectActionController.ObjectActionPostProcess getPostProcessDropViewCallback() {
        ObjectAction objectAction = (ObjectAction)this._hProps.get(ImportKeys.OBJECTACTION);
        objectAction.setReload(true);
        objectAction.setReloadParent(false);
        objectAction.setRemoveFromParent(false);
        DBObject dBObject = (DBObject)this._hProps.get(ImportKeys.DBOBJECT);
        URL uRL = DBURLFormatHelper.getURL((String)"sqldev.nav", (String)dBObject.getConnectionName(), null, (String)dBObject.getSchemaName(), (String)"VIEW");
        URL uRL2 = DBURLFormatHelper.getURL((URL)uRL, (String)dBObject.getObjectName());
        DBObject dBObject2 = new DBObject(uRL);
        ObjectActionController.ObjectActionPostProcess objectActionPostProcess = ObjectActionController.getPostProcessCallback((ObjectAction)objectAction, (DBObject)dBObject2);
        return objectActionPostProcess;
    }

    public void cancelExport() {
    }

    private void setMessage(String string) {
        if (this._task != null) {
            this._task.setMessage(string);
        }
    }

    private boolean executeAsScript(String string) {
        return this.executeAsScript(string, 1);
    }

    private boolean executeAsScript(String string, int n) {
        try {
            Object object;
            Object object2;
            String string2 = n == 1 ? this._tempName : this._tempName + "_" + Integer.toString(n);
            ExitCode exitCode = ExitCode.EXIT_SUCCESS;
            this.log("SSH HOST: " + this._host);
            if (n == 1) {
                object2 = MKDIR + this._tempDir + "\n";
                object = HadoopUtils.executeCommand(this._session, (String)object2);
                if (((ScriptOutput)object).rc != 0) {
                    this.log(HadoopWizArb.format("OSCH_EXEC_MKTEMPDIR_FAILED", this._tempDir, this.getFormattedOutput((ScriptOutput)object)));
                    exitCode = ExitCode.EXIT_WARNING;
                    this.setExitCodeHighest(ExitCode.EXIT_WARNING);
                }
            }
            if (!this._isWallet && n == 1) {
                try {
                    object2 = new ByteArrayInputStream(this._xml.getBytes("UTF-8"));
                    object = HadoopUtils.putFile(this._session, this._xmlName, (ByteArrayInputStream)object2);
                    if ((Long)object < 1L) {
                        this.log(HadoopWizArb.format("OSCH_EXEC_PUT_FAILED", this._xmlName));
                        exitCode = ExitCode.EXIT_ERROR;
                        this.setExitCodeHighest(ExitCode.EXIT_ERROR);
                        return false;
                    }
                }
                catch (Exception exception) {
                    this.log(HadoopWizArb.format("OSCH_EXEC_PUT_FAILED", this._xmlName, exception.getMessage()));
                    exitCode = ExitCode.EXIT_ERROR;
                    this.setExitCodeHighest(ExitCode.EXIT_ERROR);
                    return false;
                }
            }
            object2 = "#!/bin/bash\nsource .sqldev_osch_env\nenv\nmkdir -p " + this._tempDir + "\n" + string;
            object = (SshSessionLocation)this._hProps.get(HadoopKeys.SSH_SESSION_LOCATION);
            this._result = HadoopUtils.copyAndExecuteScript((SshLocation)object, (String)object2, string2 + ".deploy", this._tempDir);
            return this._result.rc == 0;
        }
        catch (Exception exception) {
            this.log(HadoopWizArb.getString("OLH_EXEC_SCRIPT_FAIL") + " " + exception.getMessage());
            Logger.warn(this.getClass(), (Throwable)exception);
            return false;
        }
    }

    private boolean deleteDeploy() {
        return this.deleteDeploy(1);
    }

    private boolean deleteDeploy(int n) {
        String string;
        boolean bl = true;
        String string2 = string = n == 1 ? this._tempName : this._tempName + "_" + Integer.toString(n);
        if (this._hProps.getValueBoolean(HadoopKeys.DELETE_DEPLOY).booleanValue()) {
            String string3 = HadoopWizArb.getString("OSCH_EXEC_STEP_DELETE_DEPLOY_PUT");
            this.log("\n" + HadoopWizArb.format("OSCH_EXEC_STEP_START", string3));
            ExitCode exitCode = ExitCode.EXIT_SUCCESS;
            Object object = !this._isWallet ? "rm " + this._xmlName + "\n" : "";
            object = (String)object + "rm " + this._tempDir + string + ".deploy\n";
            this.log((String)object);
            ScriptOutput scriptOutput = HadoopUtils.executeCommand(this._session, (String)object);
            if (scriptOutput.rc != 0) {
                this.log(HadoopWizArb.format("OSCH_EXEC_REMOVE_FAILED", this.getFormattedOutput(scriptOutput)));
                exitCode = ExitCode.EXIT_WARNING;
                this.setExitCodeHighest(ExitCode.EXIT_WARNING);
                bl = true;
            }
            this.log("\n" + HadoopWizArb.format("OSCH_EXEC_STEP_END", scriptOutput.rc == 0 ? HadoopWizArb.getString("OSCH_EXEC_SUCCESS") : HadoopWizArb.getString("OSCH_EXEC_FAIL"), string3));
        }
        return bl;
    }

    private String getFinalMessage() {
        String string = HadoopWizArb.getString("OSCH_SUCCESS");
        if (this._cancel) {
            string = HadoopWizArb.getString("OSCH_CANCELLED");
        } else if (this._exitCode == ExitCode.EXIT_WARNING) {
            string = HadoopWizArb.getString("OSCH_WARNING");
        } else if (this._exitCode == ExitCode.EXIT_ERROR) {
            string = HadoopWizArb.getString("OSCH_ERROR");
        }
        return "\n" + string;
    }

    private String getTerm() {
        return "\n";
    }

    public static enum Action {
        ACTION_DESCRIBE(0),
        ACTION_PUBLISH(1),
        ACTION_DROP(2);

        private int _action;

        private Action(int n2) {
            this._action = n2;
        }
    }
}

