/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.validate;

import java.awt.Component;
import java.util.Collections;
import java.util.Set;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.validate.ValidationComponent;
import oracle.bali.ewt.validate.ValidationMessagePane;
import oracle.ide.db.components.ComponentFactory;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ideimpl.db.validate.DBValidationComponent;
import oracle.ideimpl.db.validate.DBValidationHandler;
import oracle.ideimpl.db.validate.DBValidationManager;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.db.validators.DBObjectValidationModel;
import oracle.javatools.db.validators.ValidationException;

public class ModalValidationManager
extends DBValidationManager {
    private DBObjectValidationModel m_model;
    private final ValidationMessagePane m_pane = new ValidationMessagePane();

    public ModalValidationManager(JEWTDialog jEWTDialog) {
        jEWTDialog.setValidationMessagePane(this.m_pane);
    }

    @Override
    public DBValidationHandler createHandler(DBEditorConfig dBEditorConfig, ComponentFactory componentFactory) {
        return new ModalValidationHandler(dBEditorConfig, componentFactory);
    }

    @Override
    public DBObjectValidationModel getValidationModel() {
        return this.m_model;
    }

    private class ModalValidationHandler
    extends DBValidationHandler {
        private DBObjectListener m_list;

        public ModalValidationHandler(DBEditorConfig dBEditorConfig, ComponentFactory componentFactory) {
            super(dBEditorConfig, componentFactory);
            this.m_list = new DBObjectListener(){

                public void objectUpdated(DBObjectChange dBObjectChange) {
                    ComponentFactory componentFactory = ModalValidationHandler.this.getComponentFactory();
                    if (componentFactory != null) {
                        for (String string : dBObjectChange.getPropertiesChanged().keySet()) {
                            ComponentWrapper componentWrapper = componentFactory.findComponentWrapper(string);
                            if (componentWrapper == null) continue;
                            Set<ValidationException> set = null;
                            try {
                                ModalValidationHandler.this.getEditorConfig().getProvider().validateObjectProperty(ModalValidationHandler.this.getOriginalObject(), ModalValidationHandler.this.getUpdatedObject(), string);
                            }
                            catch (ValidationException validationException) {
                                set = Collections.singleton(validationException);
                            }
                            componentWrapper.setValidationStatus(set, ModalValidationHandler.this);
                        }
                    }
                }
            };
        }

        @Override
        protected void startValidationImpl() {
            ModalValidationManager.this.m_pane.removeAllValidationComponents();
            this.getUpdatedObject().addObjectListener(this.m_list);
        }

        @Override
        protected void stopValidationImpl() {
            this.getUpdatedObject().removeObjectListener(this.m_list);
            ModalValidationManager.this.m_pane.removeAllValidationComponents();
        }

        @Override
        protected DBValidationComponent findOrCreateValidationComponent(Component component, ComponentWrapper componentWrapper) {
            DBValidationComponent dBValidationComponent = super.findOrCreateValidationComponent(component, componentWrapper);
            ModalValidationManager.this.m_pane.addValidationComponent((ValidationComponent)dBValidationComponent);
            return dBValidationComponent;
        }
    }
}

