/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.validate;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.validate.ValidationComponent;
import oracle.ide.db.components.ComponentFactory;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ideimpl.db.validate.DBValidationComponent;
import oracle.ideimpl.db.validate.IconValidationPainter;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.validators.DBObjectValidationModel;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.ui.table.TableToolbar;

public abstract class DBValidationHandler {
    private final DBEditorConfig m_config;
    private final ComponentFactory m_componentFactory;
    private final Collection<Listener> m_listeners = new CopyOnWriteArraySet<Listener>();
    private DBObject m_originalObject;
    private DBObject m_updatedObject;
    private DBObjectValidationModel m_model;

    public DBValidationHandler(DBEditorConfig dBEditorConfig, ComponentFactory componentFactory) {
        this.m_config = dBEditorConfig;
        this.m_componentFactory = componentFactory;
    }

    protected final Logger getLogger() {
        return DBLog.getLogger((Object)this);
    }

    public final void addListener(Listener listener) {
        this.m_listeners.add(listener);
    }

    public final void removeListener(Listener listener) {
        this.m_listeners.remove(listener);
    }

    protected final DBEditorConfig getEditorConfig() {
        return this.m_config;
    }

    protected final DBObject getOriginalObject() {
        return this.m_originalObject;
    }

    protected final DBObject getUpdatedObject() {
        return this.m_updatedObject;
    }

    protected final ComponentFactory getComponentFactory() {
        return this.m_componentFactory;
    }

    public final void startValidation(DBObject dBObject, DBObject dBObject2) {
        if (this.m_updatedObject != dBObject2) {
            if (this.m_updatedObject != null) {
                this.stopValidation();
            }
            this.m_originalObject = dBObject;
            this.m_updatedObject = dBObject2;
            this.startValidationImpl();
        }
    }

    public final void stopValidation() {
        if (this.m_updatedObject != null) {
            this.stopValidationImpl();
            this.clearValidation();
            this.m_originalObject = null;
            this.m_updatedObject = null;
        }
    }

    protected abstract void startValidationImpl();

    protected abstract void stopValidationImpl();

    public final DBObjectValidationModel getValidationModel() {
        return this.m_model;
    }

    public final void setValidationModel(final DBObjectValidationModel dBObjectValidationModel) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setModelImpl(dBObjectValidationModel);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DBValidationHandler.this.setModelImpl(dBObjectValidationModel);
                }
            });
        }
    }

    private void setModelImpl(DBObjectValidationModel dBObjectValidationModel) {
        this.clearValidation();
        this.m_model = dBObjectValidationModel;
        Map map = dBObjectValidationModel.getValidationMap(this.m_updatedObject);
        if (map != null && this.m_componentFactory != null) {
            for (Map.Entry object : map.entrySet()) {
                String string = Property.stripProperties((String)((String)object.getKey()));
                ComponentWrapper componentWrapper = this.m_componentFactory.findComponentWrapper(string);
                if (componentWrapper == null) continue;
                componentWrapper.setValidationStatus((Collection)object.getValue(), this);
            }
        }
        for (Listener listener : this.m_listeners) {
            try {
                listener.validationModelChanged(dBObjectValidationModel, this);
            }
            catch (Exception exception) {
                this.getLogger().log(Level.SEVERE, listener.getClass().getName() + " failed!", exception);
            }
        }
    }

    public void processValidation(Component component, ComponentWrapper componentWrapper, Collection<ValidationException> collection) {
        Object object;
        if (component instanceof TableToolbar) {
            try {
                object = (JPanel)((BorderLayout)((JPanel)component).getLayout()).getLayoutComponent("North");
                JPanel jPanel = (JPanel)((BorderLayout)((Container)object).getLayout()).getLayoutComponent("North");
                component = (JLabel)((BorderLayout)jPanel.getLayout()).getLayoutComponent("West");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (component != null) {
            object = this.findOrCreateValidationComponent((JComponent)component, componentWrapper);
            ((DBValidationComponent)((Object)object)).clearValidation();
            if (collection != null) {
                for (ValidationException validationException : collection) {
                    ((DBValidationComponent)((Object)object)).addValidationException(validationException);
                }
            }
        }
    }

    protected DBValidationComponent findOrCreateValidationComponent(Component component, ComponentWrapper componentWrapper) {
        DBValidationComponent dBValidationComponent = null;
        if (component instanceof JComponent && IconValidationPainter.supportsComponent((ValidationComponent)(dBValidationComponent = DBValidationComponent.findOrCreateValidationComponent((JComponent)component, componentWrapper)))) {
            dBValidationComponent.setValidationPainter(new IconValidationPainter());
        }
        return dBValidationComponent;
    }

    public final void clearValidation() {
        if (this.m_componentFactory != null) {
            for (ComponentWrapper componentWrapper : this.m_componentFactory.getComponentWrappers()) {
                componentWrapper.setValidationStatus(null, this);
            }
        }
    }

    @FunctionalInterface
    public static interface Listener {
        public void validationModelChanged(DBObjectValidationModel var1, DBValidationHandler var2);
    }
}

