/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.table;

import java.awt.Component;
import oracle.ide.dialogs.ProgressBar;
import oracle.ideimpl.db.panels.ChildListEditorPanel;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.ideimpl.db.panels.ChildSelectableComponentEditorPanel;
import oracle.ideimpl.db.panels.table.IndexInTableContextPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.Column;
import oracle.javatools.db.ConstraintIndexHelper;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Index;
import oracle.javatools.db.NameInUseException;
import oracle.javatools.db.Table;
import oracle.javatools.db.property.DisplayNames;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.util.Holder;

public class IndexesPanel
extends ChildListEditorPanel<Index, Table> {
    public IndexesPanel() {
        super("IndexesPanel");
    }

    @Override
    protected Class getChildClass() {
        return Index.class;
    }

    @Override
    protected String getListLabel() {
        return DisplayNames.getPropertyDisplayName((String)"indexes") + ":";
    }

    @Override
    protected ChildObjectEditorPanel createChildPanel() {
        return new IndexInTableContextPanel();
    }

    @Override
    protected String getChildProperty() {
        return "indexes";
    }

    @Override
    protected boolean preserveListOrder() {
        return false;
    }

    @Override
    protected ChildSelectableComponentEditorPanel.DefaultButtonsHelper createButtonsHelper() {
        return new ChildSelectableComponentEditorPanel.DefaultButtonsHelper(){

            @Override
            public boolean includeReorderButtons() {
                return false;
            }

            @Override
            public boolean canAdd() {
                if (super.canAdd()) {
                    return ((Table)IndexesPanel.this.getUpdatedObject()).getColumns().length > 0;
                }
                return false;
            }

            @Override
            public boolean canRemove(Object object) {
                boolean bl = super.canRemove(object);
                if (bl && object instanceof Index) {
                    bl = !ConstraintIndexHelper.isForAConstraint((Index)((Index)object));
                }
                return bl;
            }
        };
    }

    @Override
    protected Index newChild() {
        Index index = (Index)super.newChild();
        index.setIndexType(Index.IndexType.NORMAL);
        index.setColumnExpressions(IndexesPanel.getDefaultExpressions(index, this.getProvider(), (Component)((Object)this)));
        return index;
    }

    @Override
    protected String getNewChildBaseName() {
        return ((Table)this.getUpdatedObject()).getName() + "_" + super.getNewChildBaseName();
    }

    public static IndexObject[] getDefaultExpressions(final Index index, final DBObjectProvider dBObjectProvider, Component component) {
        final Holder holder = new Holder((Object)new IndexObject[0]);
        final ProgressBar progressBar = new ProgressBar(component, UIBundle.get("INDEX_COL_EXPRESSIONS_TITLE"), null, true);
        progressBar.setRunnable(new Runnable(){

            @Override
            public void run() {
                IndexObject[] indexObjectArray = (IndexObject[])holder.get();
                String string = index.getName();
                String string2 = null;
                int n = 0;
                while (true) {
                    string2 = "INDEX" + n++;
                    try {
                        dBObjectProvider.validateUniqueName("INDEX", (DBObject)index.getSchema(), string2);
                        index.setName(string2);
                    }
                    catch (NameInUseException nameInUseException) {
                        continue;
                    }
                    break;
                }
                IndexObject[] indexObjectArray2 = IndexesPanel.getDefaultExpressions(index, indexObjectArray, dBObjectProvider);
                index.setName(string);
                if (indexObjectArray2 != null) {
                    holder.set((Object)indexObjectArray2);
                }
                progressBar.setDoneStatus();
            }
        });
        progressBar.start(UIBundle.get("INDEX_COL_EXPRESSIONS_TEXT"), null, 1500);
        return (IndexObject[])holder.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IndexObject[] getDefaultExpressions(Index index, IndexObject[] indexObjectArray, DBObjectProvider dBObjectProvider) {
        IndexObject indexObject;
        int n;
        if (index == null || index.getTable() == null) {
            return null;
        }
        IndexObject[] indexObjectArray2 = new IndexObject[indexObjectArray.length + 1];
        for (n = 0; n < indexObjectArray.length; ++n) {
            indexObjectArray2[n] = indexObjectArray[n];
        }
        n = 0;
        Table table = index.getTable();
        DBObjectID dBObjectID = null;
        if (indexObjectArray.length > 0) {
            dBObjectID = ((ColumnUsage)indexObjectArray[indexObjectArray.length - 1].getExpression()).getObjectID();
        }
        for (Column column : table.getColumns()) {
            if (dBObjectID == null) {
                ColumnUsage columnUsage = (ColumnUsage)dBObjectProvider.getObjectFactory().newObject(ColumnUsage.class);
                columnUsage.setObjectID(column.getID());
                indexObject = (IndexObject)dBObjectProvider.getObjectFactory().newObject(IndexObject.class);
                indexObject.setExpression((SQLFragment)columnUsage);
                indexObjectArray2[indexObjectArray2.length - 1] = indexObject;
                index.setColumnExpressions(indexObjectArray2);
                try {
                    dBObjectProvider.validateObjectProperty((DBObject)index, "columnExpressions");
                    n = 1;
                    break;
                }
                catch (DBException dBException) {
                    boolean bl = false;
                    continue;
                }
                finally {
                    index.setColumnExpressions(null);
                }
            }
            if (!dBObjectID.equals(column.getID())) continue;
            dBObjectID = null;
        }
        if (n != 0) {
            return indexObjectArray2;
        }
        Column[] columnArray = new IndexObject[indexObjectArray.length + 1];
        for (int i = 0; i < indexObjectArray.length; ++i) {
            columnArray[i] = indexObjectArray[i];
        }
        dBObjectID = null;
        if (indexObjectArray.length > 0) {
            dBObjectID = ((ColumnUsage)indexObjectArray[indexObjectArray.length - 1].getExpression()).getObjectID();
        }
        for (Column column : table.getColumns()) {
            if (dBObjectID == null) {
                indexObject = new IndexObject((SQLFragment)new ColumnUsage(column.getID()));
                columnArray[columnArray.length - 1] = indexObject;
                indexObjectArray2 = IndexesPanel.getDefaultExpressions(index, (IndexObject[])columnArray, dBObjectProvider);
                if (indexObjectArray2 == null) continue;
                return indexObjectArray2;
            }
            if (!dBObjectID.equals(column.getID())) continue;
            dBObjectID = null;
        }
        return null;
    }

    @Override
    protected void initialisePanel() {
        super.initialisePanel();
        this.getListButtons().enableButtons();
    }
}

