/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.table;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.table.AbstractTableModel;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.ui.table.ReorderableTableWithTitleBar;
import oracle.javatools.ui.table.TableToolbar;
import oracle.javatools.util.ModelUtil;

public final class FKMappingsTable
extends GenericTable {
    private final DBObjectRenderer m_renderer = new DBObjectRenderer(false);
    private final ReorderableTableWithTitleBar m_parent;
    private final DBUIResourceHelper m_resHelp = new DBUIResourceHelper("FKMappingsTable");
    private JButton m_addButton;
    private JButton m_removeButton;
    private DBObjectProvider m_pro;
    private boolean m_standalone;
    private FKConstraint m_fk;
    private UniqueConstraint m_refCon;
    private final Collection<Column> m_newCols = new ArrayList<Column>();

    public FKMappingsTable() {
        this.setModel(new MappingsTableModel());
        this.setDefaultRenderer(DBObjectID.class, this.m_renderer);
        this.setDefaultEditor(DBObjectID.class, new LocalColumnCellEditor());
        this.setDefaultEditor(String.class, new ReferenceColumnCellEditor());
        this.setColumnSelectorAvailable(false);
        this.setColumnHeaderSelectionEnabled(false);
        this.setColumnSelectionAllowed(false);
        this.setPreferredVisibleRowCount(3);
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this));
        this.m_resHelp.setName(jScrollPane, "table");
        this.m_parent = new ReorderableTableWithTitleBar((JTable)((Object)this));
        this.m_resHelp.setName((Component)this.m_parent, "parent");
        TableToolbar tableToolbar = this.createToolbar();
        this.m_parent.setTableToolbar(tableToolbar);
        this.m_resHelp.setName((Component)tableToolbar, "toolbar");
    }

    public ReorderableTableWithTitleBar getTableAndToolbar() {
        return this.m_parent;
    }

    public String[] getReferencedColumnNames() {
        String[] stringArray = null;
        if (this.isRealRefCon()) {
            stringArray = this.getMappingsModel().m_refCols.toArray(new String[0]);
        }
        return stringArray;
    }

    public DBObjectID[] getLocalColumnIDs() {
        List<DBObjectID> list = this.getMappingsModel().m_localCols;
        this.removeUnusedLocalColumns(list);
        return list.toArray(new DBObjectID[list.size()]);
    }

    private void removeUnusedLocalColumns(Collection<DBObjectID> collection) {
        if (!this.m_newCols.isEmpty() && this.m_fk != null) {
            Relation relation = this.m_fk.getRelation();
            Iterator<Column> iterator = this.m_newCols.iterator();
            while (iterator.hasNext()) {
                Column column = iterator.next();
                if (collection.contains(column.getID())) continue;
                relation.removeColumn(column);
                iterator.remove();
            }
        }
    }

    private MappingsTableModel getMappingsModel() {
        return (MappingsTableModel)super.getModel();
    }

    private TableToolbar createToolbar() {
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FKMappingsTable.this.getMappingsModel().addNameBasedRow();
            }
        };
        abstractAction.putValue("SmallIcon", OracleIcons.getIcon((String)"add.png"));
        this.m_addButton = new JButton(abstractAction);
        this.m_resHelp.setName(this.m_addButton, "addAssoc");
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FKMappingsTable.this.getMappingsModel().removeSelectedRows();
            }
        };
        abstractAction2.putValue("SmallIcon", OracleIcons.getIcon((String)"delete.png"));
        this.m_removeButton = new JButton(abstractAction2);
        this.m_resHelp.setName(this.m_removeButton, "removeAssoc");
        TableToolbar tableToolbar = new TableToolbar((JTable)((Object)this), null);
        tableToolbar.setLabel(StringUtils.stripMnemonic((String)UIBundle.get("FK_LABEL_ASSOCIATIONS")));
        tableToolbar.addActionControl((Component)this.m_addButton);
        tableToolbar.addActionControl((Component)this.m_removeButton);
        return tableToolbar;
    }

    public void setProvider(DBObjectProvider dBObjectProvider) {
        this.m_pro = dBObjectProvider;
    }

    public void setStandalone(boolean bl) {
        this.m_standalone = bl;
    }

    private boolean isRealRefCon() {
        return this.m_refCon == null;
    }

    public void setFK(FKConstraint fKConstraint) {
        this.removeEditor();
        if (this.m_fk != fKConstraint) {
            this.m_newCols.clear();
        }
        this.m_fk = fKConstraint;
        UniqueConstraint uniqueConstraint = this.m_refCon;
        this.m_refCon = null;
        if (fKConstraint == null) {
            this.clearAndDisable();
        } else {
            DBObjectID dBObjectID = fKConstraint.getReferenceID();
            if (dBObjectID == null) {
                this.clearAndDisable();
            } else {
                boolean bl;
                try {
                    DBObject dBObject = dBObjectID.resolveID();
                    if (dBObject instanceof UniqueConstraint) {
                        if (uniqueConstraint != null && uniqueConstraint != dBObject) {
                            this.removeUnusedLocalColumns(Arrays.asList(fKConstraint.getColumnIDs()));
                        }
                        this.m_refCon = (UniqueConstraint)dBObject;
                    }
                }
                catch (DBException dBException) {
                    this.log(dBException);
                }
                boolean bl2 = bl = this.m_refCon == null || this.m_refCon.getParent() == null;
                if (!(!bl || dBObjectID instanceof ReferenceID && ModelUtil.hasLength((String)((ReferenceID)dBObjectID).getName()))) {
                    this.clearAndDisable();
                } else {
                    this.setRowSelectionAllowed(bl);
                    this.getMappingsModel().init();
                }
            }
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.checkButtons();
    }

    private void checkButtons() {
        if (this.m_addButton != null) {
            boolean bl = false;
            boolean bl2 = false;
            DBObjectID dBObjectID = this.m_fk == null ? null : this.m_fk.getReferenceID();
            boolean bl3 = this.m_refCon == null && dBObjectID instanceof ReferenceID && ModelUtil.hasLength((String)((ReferenceID)dBObjectID).getName());
            TableToolbar tableToolbar = this.m_parent.getTableToolbar();
            tableToolbar.removeActionControl((Component)this.m_addButton);
            tableToolbar.removeActionControl((Component)this.m_removeButton);
            if (bl3) {
                tableToolbar.addActionControl((Component)this.m_addButton);
                tableToolbar.addActionControl((Component)this.m_removeButton);
                if (this.isEnabled() && bl3) {
                    bl = this.getRowCount() < this.m_fk.getRelation().getColumns().length;
                    bl2 = this.getSelectedRowCount() > 0;
                }
                this.m_addButton.setEnabled(bl);
                this.m_removeButton.setEnabled(bl2);
            }
            tableToolbar.validate();
        }
    }

    private void clearAndDisable() {
        this.clearSelection();
        this.getMappingsModel().clear(true);
        this.checkButtons();
    }

    private DataType getDataType(Column column) {
        DataType dataType = null;
        try {
            dataType = DataTypeHelper.getDataType((DataTypeUsage)column.getDataTypeUsage(), (boolean)false);
        }
        catch (DBException dBException) {
            this.log(dBException);
        }
        return dataType;
    }

    private Column getReferencedColumn(int n) {
        Column column = null;
        if (this.m_refCon != null) {
            DBObjectID dBObjectID = this.m_refCon.getColumnIDs()[n];
            column = (Column)this.m_refCon.getRelation().findOwnedObject(dBObjectID);
        }
        return column;
    }

    private DBObjectID createColumn(String string, Relation relation, Column column) {
        Column column2 = (Column)this.m_pro.getObjectFactory().newObject(Column.class, (DBObject)relation, string);
        TemporaryObjectID.setID((DBObject)column2, (boolean)false);
        relation.addColumn(column2);
        DataTypeUsage dataTypeUsage = column.getDataTypeUsage();
        if (dataTypeUsage == null) {
            column2.setDataTypeUsage(this.m_pro.getDescriptor().createDefaultTypeUsage());
        } else {
            column2.setDataTypeUsage((DataTypeUsage)dataTypeUsage.copyTo(null));
        }
        column2.setNotNull(column.isNotNull());
        this.m_newCols.add(column2);
        return column2.getID();
    }

    private Collection<DBObjectID> getCompatibleColumns(int n) {
        ArrayList<DBObjectID> arrayList = new ArrayList<DBObjectID>();
        DataType dataType = null;
        Column column = this.getReferencedColumn(n);
        if (column != null) {
            dataType = this.getDataType(column);
        }
        DatabaseDescriptor databaseDescriptor = this.m_pro.getDescriptor();
        for (Column column2 : this.m_fk.getRelation().getColumns()) {
            DataType dataType2 = this.getDataType(column2);
            if (dataType != null && (dataType2 == null || !databaseDescriptor.isValidFKDataType(dataType2, dataType))) continue;
            arrayList.add(column2.getID());
        }
        return arrayList;
    }

    private void log(DBException dBException) {
        this.getLogger().log(Level.WARNING, dBException.getMessage(), dBException);
    }

    private Logger getLogger() {
        return DBLog.getLogger((Object)((Object)this));
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        super.tableChanged(tableModelEvent);
        this.checkButtons();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        super.valueChanged(listSelectionEvent);
        this.checkButtons();
    }

    private class MappingsTableModel
    extends AbstractTableModel {
        private final List<DBObjectID> m_localCols = new ArrayList<DBObjectID>();
        private final List<String> m_refCols = new ArrayList<String>();

        private MappingsTableModel() {
        }

        public void clear(boolean bl) {
            this.m_localCols.clear();
            this.m_refCols.clear();
            if (bl) {
                this.fireTableDataChanged();
            }
        }

        public void init() {
            Object object;
            String[] stringArray;
            ReferenceID referenceID;
            this.clear(false);
            DBObjectID[] dBObjectIDArray = FKMappingsTable.this.m_fk.getColumnIDs();
            if (FKMappingsTable.this.m_refCon != null) {
                referenceID = FKMappingsTable.this.m_refCon.getColumnIDs();
                Relation relation = FKMappingsTable.this.m_refCon.getRelation();
                stringArray = new String[((ReferenceID)referenceID).length];
                for (int i = 0; i < ((ReferenceID)referenceID).length; ++i) {
                    object = (Column)relation.findOwnedObject((DBObjectID)referenceID[i]);
                    if (object == null) continue;
                    stringArray[i] = object.getName();
                }
            } else {
                referenceID = (ReferenceID)FKMappingsTable.this.m_fk.getReferenceID();
                stringArray = referenceID.getChildObjectNames();
            }
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                DBObjectID dBObjectID;
                DBObjectID dBObjectID2 = dBObjectID = dBObjectIDArray.length > i ? dBObjectIDArray[i] : null;
                if (dBObjectID == null && dBObjectIDArray.length == 0) {
                    DBObjectID dBObjectID3;
                    object = FKMappingsTable.this.getCompatibleColumns(i);
                    object.removeAll(this.m_localCols);
                    Relation relation = object.iterator();
                    while (relation.hasNext()) {
                        dBObjectID3 = (DBObjectID)relation.next();
                        if (!ModelUtil.areEqual((Object)stringArray[i], (Object)DBUtil.getDBObjectName((DBObjectID)dBObjectID3))) continue;
                        dBObjectID = dBObjectID3;
                        break;
                    }
                    if (dBObjectID == null) {
                        if (FKMappingsTable.this.m_standalone) {
                            relation = FKMappingsTable.this.m_fk.getRelation();
                            dBObjectID3 = FKMappingsTable.this.getReferencedColumn(i);
                            ArrayList<String> arrayList = new ArrayList<String>();
                            for (Column column : relation.getColumns()) {
                                arrayList.add(column.getName());
                            }
                            String object2 = DBUtil.getUniqueName(arrayList, (String)dBObjectID3.getName());
                            dBObjectID = FKMappingsTable.this.createColumn(object2, relation, (Column)dBObjectID3);
                        } else if (!object.isEmpty()) {
                            dBObjectID = (DBObjectID)object.iterator().next();
                        }
                    }
                    if (dBObjectID != null) {
                        bl = true;
                    }
                }
                this.m_localCols.add(dBObjectID);
                this.m_refCols.add(stringArray[i]);
            }
            if (bl && this.m_localCols.size() > 0) {
                FKMappingsTable.this.m_fk.setColumnIDs(this.m_localCols.toArray(new DBObjectID[this.m_localCols.size()]));
            }
            this.fireTableDataChanged();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0 || FKMappingsTable.this.isRealRefCon();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.m_refCols.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Object object = null;
            switch (n2) {
                case 0: {
                    object = this.m_localCols.get(n);
                    break;
                }
                case 1: {
                    object = this.m_refCols.get(n);
                }
            }
            return object;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            Object object2;
            List<Object> list;
            if (object instanceof String) {
                object = FKMappingsTable.this.m_pro.getInternalName((String)object);
            }
            List<Object> list2 = list = n2 == 0 ? this.m_localCols : this.m_refCols;
            if (list.size() > n && ModelUtil.areDifferent((Object)(object2 = list.set(n, object)), (Object)object)) {
                this.fireTableRowsUpdated(n, n);
            }
        }

        @Override
        public Class<?> getColumnClass(int n) {
            Class clazz = null;
            switch (n) {
                case 0: {
                    clazz = DBObjectID.class;
                    break;
                }
                case 1: {
                    clazz = String.class;
                }
            }
            return clazz;
        }

        @Override
        public String getColumnName(int n) {
            String string = null;
            switch (n) {
                case 0: {
                    string = UIBundle.get("FK_HEADER_COL");
                    break;
                }
                case 1: {
                    string = UIBundle.get("FK_HEADER_REF");
                }
            }
            return string;
        }

        public void addNameBasedRow() {
            if (FKMappingsTable.this.isRealRefCon()) {
                int n = this.m_refCols.size();
                DBObjectID dBObjectID = null;
                for (Column column : FKMappingsTable.this.m_fk.getRelation().getColumns()) {
                    DBObjectID dBObjectID2 = column.getID();
                    if (dBObjectID2 == null || this.m_localCols.contains(dBObjectID2)) continue;
                    dBObjectID = dBObjectID2;
                    break;
                }
                this.m_localCols.add(dBObjectID);
                this.m_refCols.add("REFCOL" + (n + 1));
                this.fireTableRowsInserted(n, n);
            }
        }

        public void removeSelectedRows() {
            int[] nArray;
            if (FKMappingsTable.this.isRealRefCon() && (nArray = FKMappingsTable.this.getSelectedRows()) != null && nArray.length > 0) {
                Arrays.sort(nArray);
                for (int i = nArray.length - 1; i >= 0; --i) {
                    int n = nArray[i];
                    this.m_refCols.remove(n);
                    this.m_localCols.remove(n);
                    this.fireTableRowsDeleted(n, n);
                }
            }
        }
    }

    private class ReferenceColumnCellEditor
    extends DefaultCellEditor {
        ReferenceColumnCellEditor() {
            super(new JTextField());
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            Component component = super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            component.setName("FKMappingsTable.TextEditor." + n + "." + n2);
            if (object instanceof String) {
                String string = FKMappingsTable.this.m_pro.getExternalName((String)object);
                ((JTextField)component).setText(string);
            }
            return component;
        }
    }

    private class LocalColumnCellEditor
    extends DefaultCellEditor {
        private final DefaultComboBoxModel m_model;

        LocalColumnCellEditor() {
            super(new JComboBox(new DefaultComboBoxModel()));
            JComboBox jComboBox = (JComboBox)this.getComponent();
            this.m_model = (DefaultComboBoxModel)jComboBox.getModel();
            jComboBox.setRenderer(FKMappingsTable.this.m_renderer);
            jComboBox.setEditor(new BasicComboBoxEditor(){

                @Override
                public void setItem(Object object) {
                    if (object instanceof DBObjectID) {
                        object = FKMappingsTable.this.m_pro.getExternalName(DBUtil.getDBObjectName((DBObjectID)((DBObjectID)object)));
                    }
                    super.setItem(object);
                }

                @Override
                public Object getItem() {
                    Object object = super.getItem();
                    if (object instanceof String) {
                        Column column;
                        String string = FKMappingsTable.this.m_pro.getInternalName((String)object);
                        Relation relation = FKMappingsTable.this.m_fk.getRelation();
                        Column column2 = (Column)DBUtil.findChildByName((DBObject)relation, (String)"columns", (String)string, (DBObjectProvider)FKMappingsTable.this.m_pro);
                        Object object2 = column2 == null ? ((column = FKMappingsTable.this.getReferencedColumn(FKMappingsTable.this.getSelectedRow())) == null ? null : FKMappingsTable.this.createColumn(string, relation, column)) : column2.getID();
                        object = object2;
                    }
                    return object;
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.m_model.removeAllElements();
            for (DBObjectID object22 : FKMappingsTable.this.getCompatibleColumns(n)) {
                this.m_model.addElement(object22);
            }
            boolean bl2 = FKMappingsTable.this.m_standalone && !FKMappingsTable.this.isRealRefCon();
            ((JComboBox)this.getComponent()).setEditable(bl2);
            Component component = super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            component.setName("FKMappingsTable.ComboEditor." + n + "." + n2);
            return component;
        }
    }
}

