/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.table;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.dialogs.DBEditorFactoryRegistry;
import oracle.ide.db.event.SwingDBObjectListener;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.components.ConstraintColumnIDsComponentWrapper;
import oracle.ideimpl.db.extension.DatabaseExtensionHook;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.ideimpl.db.panels.table.ConstraintsPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.Column;
import oracle.javatools.db.ColumnConstraint;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.ConstraintIndexHelper;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.validators.ValidationException;

public class ConstraintEditorPanel
extends ChildObjectEditorPanel<Constraint, Relation> {
    private Component m_horizGap;
    private JButton m_newPKButton;
    private JCheckBox m_identifyingBox;
    private BaseObjectID m_lastGoodRef;

    public ConstraintEditorPanel() {
        super("ConstraintEditorPanel", "constraints");
    }

    @Override
    protected DBObjectListener createComponentFactoryObjectListener() {
        return new SwingDBObjectListener(){

            @Override
            public void updateUI(DBObjectChange dBObjectChange) {
                DBObject dBObject = dBObjectChange.getDBObject();
                Map map = dBObjectChange.getPropertiesChanged();
                if (dBObject instanceof FKConstraint) {
                    boolean bl = map.containsKey("referenceID");
                    boolean bl2 = map.containsKey("columnIDs");
                    if (bl || bl2) {
                        if (!bl2) {
                            ((FKConstraint)dBObject).setColumnIDs(null);
                        }
                        ConstraintEditorPanel.this.fkRefChanged();
                    }
                }
                if (dBObject instanceof ColumnConstraint && map.containsKey("columnIDs")) {
                    ConstraintEditorPanel.this.ensureColumnsNotNull((ColumnConstraint)dBObject);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initialiseChildComponents() {
        Object object;
        Object object2;
        Iterator<PropertyInfo> iterator;
        Collection<PropertyInfo> collection;
        Object object3;
        Constraint constraint = (Constraint)this.getChildObject();
        DBUILayoutHelper dBUILayoutHelper = this.getDBUILayoutHelper();
        boolean bl = this.getEditorConfig().isChildEditOnly();
        if (bl) {
            if (this.getOriginalChildObject() == null && (object3 = (JEWTDialog)this.getDataContext().find(JEWTDialog.class)) != null) {
                if (constraint instanceof FKConstraint) {
                    object3.setTitle(UIBundle.get("FK_TITLE"));
                } else if (constraint instanceof PKConstraint) {
                    object3.setTitle(UIBundle.get("PK_TITLE"));
                }
                object3.setName("create" + constraint.getConstraintType());
            }
            dBUILayoutHelper.add(this.getOrCreateWrapper("name"));
            dBUILayoutHelper.nextRow();
            dBUILayoutHelper.add(this.getOrCreateWrapper("enabled"));
            dBUILayoutHelper.nextRow();
            dBUILayoutHelper.add(this.getOrCreateWrapper("deferrableState"));
        }
        dBUILayoutHelper.nextRow();
        dBUILayoutHelper.add(this.getOrCreateWrapper("indexID"));
        object3 = this.getOrCreateWrapper("checkCondition");
        dBUILayoutHelper.nextRow();
        dBUILayoutHelper.add(((ComponentWrapper)object3).getLabel(), 2, 1);
        dBUILayoutHelper.nextRow();
        dBUILayoutHelper.add(((ComponentWrapper)object3).getComponent(), 2, 1, true, true);
        Component component = this.getOrCreateWrapper("referenceID").getComponent();
        Component component2 = this.getOrCreateWrapper("columnIDs").getComponent();
        component2.setPreferredSize(new Dimension(200, 150));
        ComponentWrapper componentWrapper = this.getOrCreateWrapper("onDeleteAction");
        if (bl) {
            collection = this.getComponentFactory().getResourceHelper();
            dBUILayoutHelper.nextRow();
            dBUILayoutHelper.addChildren(component, new Integer[0]);
            iterator = DBEditorFactoryRegistry.getEditFactory((SchemaObject)this.getUpdatedObject(), this.getProvider());
            boolean bl2 = false;
            object2 = PKConstraint.getPrimaryKey((Relation)((Relation)this.getUpdatedObject()));
            if (object2 == null) {
                object2 = new PKConstraint();
                ((Relation)this.getUpdatedObject()).addConstraint((Constraint)object2);
                bl2 = true;
            }
            try {
                if (iterator.canEditDBObject((DBObject)object2, this.getProvider())) {
                    dBUILayoutHelper.nextRow();
                    object = new AbstractAction(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            ConstraintEditorPanel.this.createPK();
                        }
                    };
                    this.m_newPKButton = new JButton((Action)object);
                    ((DBUIResourceHelper)((Object)collection)).resButton(this.m_newPKButton, UIBundle.get("FK_BUTTON_ADD_PK"), "AddPK");
                    dBUILayoutHelper.add(this.m_newPKButton, 2, 1, false, false);
                    dBUILayoutHelper.getConstraints((Component)this.m_newPKButton).anchor = 13;
                }
            }
            finally {
                if (bl2) {
                    ((Relation)this.getUpdatedObject()).removeConstraint((Constraint)object2);
                }
            }
            dBUILayoutHelper.nextRow();
            dBUILayoutHelper.add(component2, 2, 1, true, true);
            dBUILayoutHelper.nextRow();
            dBUILayoutHelper.add(componentWrapper);
            this.m_identifyingBox = new JCheckBox();
            ((DBUIResourceHelper)((Object)collection)).resButton(this.m_identifyingBox, UIBundle.get("FK_LABEL_PUT_FK_COLS_IN_PK"), "Identifying");
            dBUILayoutHelper.nextRow();
            dBUILayoutHelper.add(this.m_identifyingBox, 2, 1);
        } else {
            collection = new JPanel();
            iterator = new DBUILayoutHelper((JPanel)((Object)collection), this.isInFlatEditor());
            ((DBUILayoutHelper)((Object)iterator)).setMarginTop(0);
            ((DBUILayoutHelper)((Object)iterator)).addChildren(component, new Integer[0]);
            ((DBUILayoutHelper)((Object)iterator)).nextRowWithGap();
            ((DBUILayoutHelper)((Object)iterator)).add(componentWrapper);
            ((DBUILayoutHelper)((Object)iterator)).pushUp();
            ((DBUILayoutHelper)((Object)iterator)).add(component2, 1, 10, true, true);
            GridBagConstraints gridBagConstraints = ((DBUILayoutHelper)((Object)iterator)).getConstraints(component2);
            gridBagConstraints.gridx = 10;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets.left = 0;
            this.m_horizGap = Box.createHorizontalStrut(24);
            ((DBUILayoutHelper)((Object)iterator)).add(this.m_horizGap, 1, 1, false, false);
            object2 = ((DBUILayoutHelper)((Object)iterator)).getConstraints(this.m_horizGap);
            object2.gridx = 9;
            ((DBUILayoutHelper)((Object)iterator)).getConstraints((Component)this.m_horizGap).gridy = 0;
            ((DBUILayoutHelper)((Object)iterator)).getConstraints((Component)this.m_horizGap).insets.left = 0;
            ((DBUILayoutHelper)((Object)iterator)).layout();
            dBUILayoutHelper.nextRow();
            dBUILayoutHelper.add((Component)((Object)collection), 2, 1, true, true);
        }
        collection = DatabaseExtensionHook.getHook().getAutoIncludedProperties(this.getProvider(), Constraint.class);
        for (PropertyInfo propertyInfo : collection) {
            object2 = propertyInfo.getPropertyName();
            try {
                object = this.getOrCreateWrapper((String)object2);
                dBUILayoutHelper.nextRow();
                dBUILayoutHelper.add((ComponentWrapper)object);
            }
            catch (Exception exception) {
                DBLog.getLogger((Object)this).log(Level.WARNING, "Could not add extra property " + (String)object2, exception);
            }
        }
        dBUILayoutHelper.layout();
    }

    @Override
    protected void initialisePanel() {
        super.initialisePanel();
        this.setLastRef();
        Constraint constraint = (Constraint)this.getChildObject();
        boolean bl = constraint instanceof FKConstraint;
        this.setVisible(this.m_horizGap, bl);
        this.setVisible(this.m_newPKButton, bl);
        this.setVisible(this.m_identifyingBox, bl);
        if (bl && this.m_identifyingBox != null) {
            this.m_identifyingBox.setSelected(this.isIdentifying((FKConstraint)constraint));
        }
    }

    private boolean isIdentifying(FKConstraint fKConstraint) {
        boolean bl = false;
        DBObjectID[] dBObjectIDArray = fKConstraint.getColumnIDs();
        PKConstraint pKConstraint = PKConstraint.getPrimaryKey((Relation)fKConstraint.getRelation());
        if (dBObjectIDArray.length > 0 && pKConstraint != null) {
            DBObjectID[] dBObjectIDArray2 = pKConstraint.getColumnIDs();
            bl = Arrays.asList(dBObjectIDArray2).containsAll(Arrays.asList(dBObjectIDArray));
        }
        return bl;
    }

    private void setVisible(Component component, boolean bl) {
        if (component != null) {
            component.setVisible(bl);
        }
    }

    @Override
    protected void commitPanel() throws TraversalException {
        Constraint constraint = (Constraint)this.getChildObject();
        Relation relation = constraint.getRelation();
        if (constraint instanceof FKConstraint && this.m_identifyingBox != null && this.m_identifyingBox.isSelected()) {
            boolean bl = false;
            PKConstraint pKConstraint = PKConstraint.getPrimaryKey((Relation)relation);
            if (pKConstraint == null) {
                bl = true;
                pKConstraint = (PKConstraint)ConstraintsPanel.newConstraint(relation, "PKConstraint", this.getProvider());
            }
            ArrayList<DBObjectID> arrayList = new ArrayList<DBObjectID>();
            for (DBObjectID dBObjectID : pKConstraint.getColumnIDs()) {
                arrayList.add(dBObjectID);
            }
            for (DBObjectID dBObjectID : ((FKConstraint)constraint).getColumnIDs()) {
                if (arrayList.contains(dBObjectID)) continue;
                arrayList.add(dBObjectID);
            }
            pKConstraint.setColumnIDs(arrayList.toArray(new DBObjectID[arrayList.size()]));
            if (bl) {
                relation.addConstraint((Constraint)pKConstraint);
            }
            this.ensureColumnsNotNull((ColumnConstraint)pKConstraint);
        }
        if (!this.isInFlatEditor() && constraint instanceof UniqueConstraint) {
            ConstraintIndexHelper constraintIndexHelper = ConstraintEditorPanel.getIndexHelper(this.getDataContext());
            try {
                constraintIndexHelper.ensureAndValidateIndexes((UniqueConstraint)constraint, this.getValidationLevel());
            }
            catch (ValidationException validationException) {
                throw new TraversalException(validationException.getMessage());
            }
        }
        super.commitPanel();
    }

    private void setLastRef() {
        DBObjectID dBObjectID;
        Constraint constraint = (Constraint)this.getChildObject();
        if (constraint instanceof FKConstraint && (dBObjectID = ((FKConstraint)constraint).getReferenceID()) instanceof BaseObjectID) {
            this.m_lastGoodRef = (BaseObjectID)dBObjectID;
        }
    }

    private void fkRefChanged() {
        this.setLastRef();
        ConstraintColumnIDsComponentWrapper constraintColumnIDsComponentWrapper = (ConstraintColumnIDsComponentWrapper)this.getOrCreateWrapper("columnIDs");
        if (!constraintColumnIDsComponentWrapper.getFKWrapper().isCommiting()) {
            constraintColumnIDsComponentWrapper.refreshObject((DBObject)this.getChildObject());
        }
        if (this.m_newPKButton != null) {
            Relation relation = this.getReferencedRelation();
            boolean bl = relation != null && PKConstraint.getPrimaryKey((Relation)relation) == null;
            this.m_newPKButton.setEnabled(bl);
        }
    }

    private Relation getReferencedRelation() {
        Relation relation = null;
        Constraint constraint = (Constraint)this.getChildObject();
        if (constraint instanceof FKConstraint) {
            DBObjectID dBObjectID = ((FKConstraint)constraint).getReferenceID();
            if (dBObjectID == null) {
                dBObjectID = this.m_lastGoodRef;
            }
            if (dBObjectID instanceof BaseObjectID) {
                DBObjectID dBObjectID2 = dBObjectID.getParent();
                try {
                    DBObject dBObject = dBObjectID2.resolveID();
                    if (dBObject instanceof Relation) {
                        relation = (Relation)dBObject;
                    }
                }
                catch (DBException dBException) {
                    DBLog.getLogger((Object)this).warning(dBException.getMessage());
                }
            } else if (dBObjectID != null) {
                DBObject dBObject;
                DBObject dBObject2 = null;
                try {
                    dBObject2 = dBObjectID.resolveID();
                }
                catch (DBException dBException) {
                    DBLog.getLogger((Object)this).warning(dBException.getMessage());
                }
                if (dBObject2 != null && (dBObject = dBObject2.getParent()) instanceof Relation) {
                    relation = (Relation)dBObject;
                }
            }
        }
        return relation;
    }

    private void ensureColumnsNotNull(ColumnConstraint columnConstraint) {
        if (!this.getProvider().getDescriptor().isNullConstraintColumnAllowed(columnConstraint)) {
            Relation relation = columnConstraint.getRelation();
            for (DBObjectID dBObjectID : columnConstraint.getColumnIDs()) {
                Column column = (Column)relation.findOwnedObject(dBObjectID);
                if (column == null || column.isNotNull()) continue;
                column.setNotNull(true);
            }
        }
    }

    private void createPK() {
        DBEditorFactory dBEditorFactory;
        Relation relation = this.getReferencedRelation();
        if (relation != null && (dBEditorFactory = DBEditorFactoryRegistry.getEditFactory((SchemaObject)relation, this.getProvider())) != null) {
            PKConstraint pKConstraint;
            boolean bl = relation == this.getUpdatedObject();
            DBEditorConfig dBEditorConfig = DBEditorConfig.newEditConfig(this.getProvider(), (DBObject)relation);
            Relation relation2 = (Relation)dBEditorConfig.getUpdatedObject();
            PKConstraint pKConstraint2 = (PKConstraint)ConstraintsPanel.newConstraint(relation2, "PKConstraint", this.getProvider());
            relation2.addConstraint((Constraint)pKConstraint2);
            dBEditorConfig.setObjectType(pKConstraint2.getType());
            dBEditorConfig.setChildObject((DBObject)pKConstraint2);
            dBEditorConfig.setChildEditOnly(true);
            dBEditorConfig.setCommitToProvider(!bl);
            dBEditorFactory.launchDialog(dBEditorConfig);
            if (dBEditorConfig.getResult() == DBEditorConfig.Result.SUCCESS && (pKConstraint = PKConstraint.getPrimaryKey((Relation)relation)) != null) {
                FKConstraint fKConstraint = (FKConstraint)this.getChildObject();
                fKConstraint.setReferenceID(pKConstraint.getID());
                ComponentWrapper componentWrapper = this.getComponentFactory().findComponentWrapper("referenceID");
                if (componentWrapper != null) {
                    componentWrapper.refreshObject((DBObject)fKConstraint);
                }
            }
        }
    }

    static ConstraintIndexHelper getIndexHelper(Namespace namespace) {
        ConstraintIndexHelper constraintIndexHelper = (ConstraintIndexHelper)namespace.find(ConstraintIndexHelper.class);
        if (constraintIndexHelper == null) {
            DBEditorConfig dBEditorConfig = (DBEditorConfig)namespace.find(DBEditorConfig.class);
            constraintIndexHelper = new ConstraintIndexHelper(dBEditorConfig.getProvider(), (Table)dBEditorConfig.getUpdatedObject());
            namespace.put(ConstraintIndexHelper.class.getName(), (Object)constraintIndexHelper);
        }
        return constraintIndexHelper;
    }
}

