/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.table;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.ideimpl.db.panels.TableWithTabbedChildSplitPane;
import oracle.ideimpl.db.panels.table.ColumnsTabsPanel;
import oracle.ideimpl.db.panels.table.CopyColumnPanel;
import oracle.ideimpl.db.panels.table.SimpleCreateTablePanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.LOBDescriptor;
import oracle.javatools.db.ora.OracleColumnProperties;
import oracle.javatools.db.ora.OracleNestedTableProperties;
import oracle.javatools.dialogs.DialogUtil;
import oracle.javatools.icons.OracleIcons;

public class ColumnsTableEditorPanel
extends SimpleCreateTablePanel {
    private static final int NO_TAB = -1;
    private static final int DEFAULT_TAB = 0;

    public ColumnsTableEditorPanel() {
        super("ColumnsTableEditorPanel");
    }

    @Override
    protected void initialiseComponents() {
        super.initialiseComponents();
        this.addToolBarButton(this.createCopyButton());
    }

    @Override
    protected boolean stopCellEditingWhenChildPanelFocused() {
        return true;
    }

    @Override
    protected boolean useSplitter() {
        return true;
    }

    @Override
    protected JComponent createSplitPane(Component component, Component component2) {
        TableWithTabbedChildSplitPane tableWithTabbedChildSplitPane = new TableWithTabbedChildSplitPane(component, (ColumnsTabsPanel)((Object)component2));
        return tableWithTabbedChildSplitPane;
    }

    @Override
    protected ChildObjectEditorPanel<Column, Table> createChildPanel() {
        return new ColumnsTabsPanel(this.isInFlatEditor() ? 0 : -1);
    }

    protected JButton createCopyButton() {
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColumnsTableEditorPanel.this.showCopyDialog();
            }
        };
        abstractAction.putValue("SmallIcon", OracleIcons.getIcon((String)"copy.png"));
        abstractAction.putValue("ShortDescription", UIBundle.get("COLUMN_INFO_TOOLTIP_COPY_COLS"));
        JButton jButton = new JButton();
        jButton.setAction(abstractAction);
        return jButton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showCopyDialog() {
        if (this.exitChildPanel()) {
            JEWTDialog jEWTDialog = JEWTDialog.createDialog((Component)DialogUtil.getAncestorDialog((Component)((Object)this)), (String)UIBundle.format("COPY_COLUMN_TITLE", ((Table)this.getUpdatedObject()).getName()), (int)7);
            DBObjectProvider dBObjectProvider = this.getProvider();
            Table table = (Table)this.getUpdatedObject();
            CopyColumnPanel copyColumnPanel = new CopyColumnPanel(dBObjectProvider, (Relation)table, this.isEditing());
            jEWTDialog.setContent((Component)copyColumnPanel);
            try {
                List<Column> list;
                if (jEWTDialog.runDialog() && (list = copyColumnPanel.getSelectedColumns()) != null && !list.isEmpty()) {
                    Collection<String> collection = this.getChildNames();
                    for (Column column : list) {
                        OracleNestedTableProperties oracleNestedTableProperties;
                        LOBDescriptor lOBDescriptor;
                        String string = DBUtil.getUniqueName(collection, (String)column.getName());
                        column.setName(string);
                        collection.add(string);
                        OracleColumnProperties oracleColumnProperties = (OracleColumnProperties)column.getProperty("OracleColumnProperties");
                        if (oracleColumnProperties == null) continue;
                        LOBDescriptor lOBDescriptor2 = oracleColumnProperties.getLOBProperties();
                        if (lOBDescriptor2 != null) {
                            lOBDescriptor2.setLOBSegName(null);
                        }
                        if ((lOBDescriptor = oracleColumnProperties.getVAProperties()) != null) {
                            lOBDescriptor.setLOBSegName(null);
                        }
                        if ((oracleNestedTableProperties = oracleColumnProperties.getNestedTableProperties()) == null) continue;
                        oracleNestedTableProperties.setTableName(null);
                    }
                    this.addChildRow((ChildDBObject[])list.toArray(new Column[list.size()]));
                }
            }
            finally {
                jEWTDialog.dispose();
            }
        }
    }
}

