/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.sql;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import oracle.ide.db.dialogs.DBExceptionDialog;
import oracle.ide.db.panels.sql.SQLQueryEditDialog;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.db.util.TreeNodeMaker;
import oracle.ide.insight.completion.CompletionSupport;
import oracle.ide.util.FastStringBuffer;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.panels.sql.BaseSQLQueryBuilderPanel;
import oracle.ideimpl.db.panels.sql.ExpressionPanel;
import oracle.ideimpl.db.panels.sql.FunctionComboBox;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Relation;
import oracle.javatools.db.sql.BuiltInFunction;
import oracle.javatools.db.sql.Comparison;
import oracle.javatools.db.sql.FKUsage;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.RelationUsage;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SetOperation;
import oracle.javatools.db.sql.SynonymUsage;
import oracle.javatools.db.sql.WhereObject;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ModelUtil;

public class WhereEditor
extends JPanel
implements MouseListener,
TreeSelectionListener,
ActionListener,
FocusListener {
    public static final String AND = WhereObject.WhereOperator.AND.getSQLText();
    public static final String OR = WhereObject.WhereOperator.OR.getSQLText();
    public static final String PRIOR = "PRIOR";
    public static final String LEVEL = "LEVEL";
    private DBUIResourceHelper reshelp;
    private final BaseSQLQueryBuilderPanel m_basePanel;
    private CompletionSupport m_completionSupport;
    private JTextArea m_where = new JTextArea();
    private JScrollPane m_scrollPane = new JScrollPane(this.m_where, 20, 31);
    private DefaultMutableTreeNode m_top = new DefaultMutableTreeNode("WHERE_TEMPS");
    private DefaultTreeModel m_templatesModel = new DefaultTreeModel(this.m_top);
    private JTree m_templates = new JTree(this.m_templatesModel);
    private JLabel m_tempDesc = new JLabel();
    private JButton m_insertTempl = new JButton(OracleIcons.getIcon((String)"shuttle_left.png"));
    private JButton m_insertFunc = new JButton(OracleIcons.getIcon((String)"shuttle_left.png"));
    private FunctionComboBox m_functions = new FunctionComboBox();
    private TreeNodeMaker m_nodeMaker = new TreeNodeMaker(false);
    private DBObjectRenderer m_rend = new DBObjectRenderer();
    private String m_cachedWhere;
    private boolean m_includePrior;
    private Collection<String> m_bindVariables;
    private JButton m_and = new JButton();
    private JButton m_or = new JButton();
    private JButton m_pars = new JButton();
    private JButton m_prior = new JButton();
    private JButton m_subQuery = new JButton();
    private transient DBObjectProvider m_pro;

    public WhereEditor(String string) {
        this(string, null);
    }

    WhereEditor(String string, BaseSQLQueryBuilderPanel baseSQLQueryBuilderPanel) {
        this.m_rend.setIncludeIcon(true);
        this.m_basePanel = baseSQLQueryBuilderPanel;
        try {
            this.layoutComponents(string);
        }
        catch (Exception exception) {
            DBLog.getLogger((Object)this).log(Level.SEVERE, "layout failed", exception);
        }
    }

    private void layoutComponents(String string) {
        this.reshelp = new DBUIResourceHelper(string);
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        this.setLayout(new GridBagLayout());
        this.m_where.setEditable(true);
        this.m_where.setLineWrap(true);
        this.m_where.setWrapStyleWord(true);
        this.m_scrollPane.setSize(60, 40);
        this.m_where.setSize(60, 40);
        this.add((Component)this.m_scrollPane, new GridBagConstraints(1, 0, 1, 5, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 15), 0, 0));
        this.reshelp.setName(this.m_scrollPane, "Where");
        this.setTemplatesLabel(UIBundle.get("EXP_PALETTE"));
        this.add((Component)this.m_tempDesc, new GridBagConstraints(2, 0, 5, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
        ExpressionPanel.setupButton(this.m_insertTempl, this, null, ExpressionPanel.EMPTY_INSETS);
        this.m_insertTempl.setMnemonic('c');
        this.m_insertTempl.setEnabled(false);
        toolTipManager.registerComponent(this.m_insertTempl);
        this.reshelp.setName(this.m_insertTempl, "InsertTemplate");
        DBObjectRenderer.setToolTipText(this.m_insertTempl, UIBundle.get("WHERE_TEMPL_TT"));
        this.add((Component)this.m_insertTempl, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add(Box.createHorizontalStrut(220), new GridBagConstraints(1, 1, 1, 2, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(Box.createVerticalStrut(50), new GridBagConstraints(1, 1, 1, 2, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_templates.setRootVisible(false);
        this.m_templates.setShowsRootHandles(true);
        this.m_templates.setEditable(false);
        this.m_templates.setExpandsSelectedPaths(true);
        this.m_templates.setCellRenderer(this.m_rend);
        this.m_templates.addMouseListener(this);
        this.m_templates.addTreeSelectionListener(this);
        this.m_templates.getSelectionModel().setSelectionMode(1);
        this.m_templates.setScrollsOnExpand(true);
        ToolTipManager.sharedInstance().registerComponent(this.m_templates);
        JScrollPane jScrollPane = new JScrollPane(this.m_templates);
        this.add((Component)jScrollPane, new GridBagConstraints(3, 1, 5, 2, 0.5, 1.0, 18, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.reshelp.setName(jScrollPane, "Templates");
        ExpressionPanel.setupButton(this.m_insertFunc, this, null, ExpressionPanel.EMPTY_INSETS);
        this.m_templates.addFocusListener(this);
        this.m_insertFunc.setMnemonic('f');
        toolTipManager.registerComponent(this.m_insertFunc);
        this.reshelp.setName(this.m_insertFunc, "InsertFunction");
        DBObjectRenderer.setToolTipText(this.m_insertFunc, UIBundle.get("WHERE_FUNC_TT"));
        this.add((Component)this.m_insertFunc, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.reshelp.setName(this.m_functions, "Functions");
        this.add((Component)this.m_functions, new GridBagConstraints(3, 3, 5, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.reshelp.resButton(this.m_and, "&" + AND, "And");
        this.m_and.addActionListener(this);
        toolTipManager.registerComponent(this.m_and);
        DBObjectRenderer.setToolTipText(this.m_and, UIBundle.get("WHERE_AND_TT"));
        this.add((Component)this.m_and, new GridBagConstraints(2, 4, 2, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.reshelp.resButton(this.m_or, "&" + OR, "Or");
        this.m_or.addActionListener(this);
        toolTipManager.registerComponent(this.m_or);
        DBObjectRenderer.setToolTipText(this.m_or, UIBundle.get("WHERE_OR_TT"));
        this.add((Component)this.m_or, new GridBagConstraints(4, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.m_pars.setText("(...)");
        this.m_pars.addActionListener(this);
        this.m_pars.setMnemonic('9');
        toolTipManager.registerComponent(this.m_pars);
        this.reshelp.setName(this.m_pars, "Brackets");
        DBObjectRenderer.setToolTipText(this.m_pars, UIBundle.get("WHERE_PARENTH_TT"));
        this.add((Component)this.m_pars, new GridBagConstraints(5, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 5, 5), 0, 0));
        toolTipManager.registerComponent(this.m_subQuery);
        DBObjectRenderer.setToolTipText(this.m_subQuery, UIBundle.get("WHERE_ADD_SUBQUERY_TT"));
        this.reshelp.resButton(this.m_subQuery, UIBundle.get("SUBQUERY_BUTTON"), "SubQuery");
        this.m_subQuery.addActionListener(this);
        this.add((Component)this.m_subQuery, new GridBagConstraints(6, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.reshelp.resButton(this.m_prior, "&PRIOR", "Prior");
        this.m_prior.addActionListener(this);
        toolTipManager.registerComponent(this.m_prior);
        DBObjectRenderer.setToolTipText(this.m_prior, UIBundle.get("WHERE_PRIOR_TT"));
        this.add((Component)this.m_prior, new GridBagConstraints(2, 5, 2, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 5, 0), 0, 0));
    }

    public void setDBObjectProvider(DBObjectProvider dBObjectProvider) {
        this.m_pro = dBObjectProvider;
    }

    public void setTemplatesLabel(String string) {
        this.reshelp.resLabel(this.m_tempDesc, this.m_templates, string, "Templates");
    }

    public void setTemplates(FromObject[] fromObjectArray, FKUsage[] fKUsageArray) {
        ArrayList<FKUsage> arrayList;
        Object object;
        int n;
        this.m_top.removeAllChildren();
        HashMap<FromObject, ArrayList<FKUsage>> hashMap = new HashMap<FromObject, ArrayList<FKUsage>>();
        for (n = 0; fKUsageArray != null && n < fKUsageArray.length; ++n) {
            object = fKUsageArray[n].resolveLeftFromObject();
            arrayList = (ArrayList<FKUsage>)hashMap.get(object);
            if (arrayList == null) {
                arrayList = new ArrayList<FKUsage>();
                hashMap.put((FromObject)object, arrayList);
            }
            arrayList.add(fKUsageArray[n]);
        }
        for (n = 0; fromObjectArray != null && n < fromObjectArray.length; ++n) {
            if (fromObjectArray[n] == null || !(fromObjectArray[n].getExpression() instanceof RelationUsage) && !(fromObjectArray[n].getExpression() instanceof SynonymUsage) && !(fromObjectArray[n].getExpression() instanceof SQLQuery)) continue;
            object = this.m_nodeMaker.createTreeNode((SQLFragment)fromObjectArray[n], true);
            this.m_top.add((MutableTreeNode)object);
            if (!hashMap.containsKey(fromObjectArray[n])) continue;
            arrayList = (List)hashMap.get(fromObjectArray[n]);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                ((DefaultMutableTreeNode)object).add(this.m_nodeMaker.createTreeNode((SQLFragment)((FKUsage)iterator.next())));
            }
        }
        if (this.m_bindVariables != null && this.m_bindVariables.size() > 0) {
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Bind Variables", true);
            this.m_top.add(defaultMutableTreeNode);
            object = this.m_bindVariables.iterator();
            while (object.hasNext()) {
                arrayList = new DefaultMutableTreeNode(object.next(), false);
                defaultMutableTreeNode.add((MutableTreeNode)((Object)arrayList));
            }
        }
        this.m_templatesModel.reload();
    }

    public void setFunctions(Collection collection) {
        Object object2;
        this.m_functions.removeAllItems();
        HashSet<String> hashSet = new HashSet<String>();
        for (Object object2 : collection) {
            if (!(object2 instanceof BuiltInFunction)) continue;
            hashSet.add(((BuiltInFunction)object2).getSignature(false));
        }
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(hashSet);
        Collections.sort(arrayList);
        object2 = arrayList.iterator();
        while (object2.hasNext()) {
            String string = (String)object2.next();
            this.m_functions.addItem(string);
        }
    }

    public void setBindVariables(Collection<String> collection) {
        this.m_bindVariables = collection;
    }

    private void insertCurrentFunction() {
        Object object = this.m_functions.getSelectedItem();
        if (object instanceof SQLFragment) {
            this.addToWhere(((SQLFragment)object).getSQLText());
        } else {
            this.addToWhere(object.toString());
        }
        this.m_where.requestFocus();
    }

    private void insertCurrentTemplate() {
        Object object;
        TreePath treePath;
        if (this.m_templates != null && (treePath = this.m_templates.getSelectionPath()) != null && (object = treePath.getLastPathComponent()) != null && ((DefaultMutableTreeNode)object).isLeaf()) {
            Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
            String string = null;
            if (object2 instanceof Column) {
                Object object3;
                Object object4;
                FastStringBuffer fastStringBuffer = new FastStringBuffer();
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)((DefaultMutableTreeNode)object).getParent();
                Object object5 = object4 = defaultMutableTreeNode == null ? null : defaultMutableTreeNode.getUserObject();
                if (object4 != null && object4 instanceof FromObject) {
                    fastStringBuffer.append(((FromObject)object4).getName());
                    fastStringBuffer.append(".");
                } else {
                    object3 = ((Column)object2).getRelation();
                    if (object3 != null) {
                        String string2 = ((Relation)object2).getName();
                        if (this.m_pro != null) {
                            string2 = this.m_pro.getExternalName(string2);
                        }
                        fastStringBuffer.append(string2).append(".");
                    }
                }
                object3 = ((Column)object2).getName();
                if (this.m_pro != null) {
                    object3 = this.m_pro.getExternalName((String)object3);
                }
                fastStringBuffer.append((String)object3);
                string = fastStringBuffer.toString();
            } else if (object2 instanceof SQLFragment) {
                string = ((SQLFragment)object2).getSQLText();
            } else if (object2 instanceof DBObject) {
                string = DBUtil.getFullyQualifiedName((DBObject)((DBObject)object2));
            } else if (object2 instanceof String) {
                string = (String)object2;
            }
            this.addToWhere(string);
            this.m_where.requestFocus();
        }
    }

    private void addToWhere(String string) {
        BaseSQLQueryBuilderPanel.addText(this.m_where, string);
    }

    public boolean hasTextChanged() {
        String string = this.m_where.getText();
        if (ModelUtil.hasLength((String)string)) {
            return ModelUtil.areDifferent((Object)this.m_cachedWhere, (Object)string);
        }
        return ModelUtil.hasLength((String)this.m_cachedWhere);
    }

    public void init(SQLFragment sQLFragment, SQLQueryBuilder sQLQueryBuilder, boolean bl) {
        this.m_includePrior = bl;
        if (this.m_includePrior) {
            this.m_cachedWhere = null;
            if (sQLFragment != null) {
                this.m_cachedWhere = (this.hasPrior(sQLFragment) ? "" : "PRIOR ") + sQLFragment.getSQLText();
            }
        } else {
            this.m_cachedWhere = sQLFragment == null ? null : sQLFragment.getSQLText();
        }
        this.init(sQLQueryBuilder);
    }

    private boolean hasPrior(SQLFragment sQLFragment) {
        boolean bl = false;
        if (sQLFragment instanceof WhereObject) {
            SQLFragment[] sQLFragmentArray;
            for (SQLFragment sQLFragment2 : sQLFragmentArray = ((WhereObject)sQLFragment).getArguments()) {
                if (!this.hasPrior(sQLFragment2)) continue;
                bl = true;
                break;
            }
        } else if (sQLFragment instanceof Comparison) {
            bl = ((Comparison)sQLFragment).getPriorOnLeft() || ((Comparison)sQLFragment).getPriorOnRight();
        }
        return bl;
    }

    public void init(WhereObject whereObject, SQLQueryBuilder sQLQueryBuilder) {
        this.m_cachedWhere = whereObject == null ? null : whereObject.getSQLText();
        this.init(sQLQueryBuilder);
    }

    private void init(SQLQueryBuilder sQLQueryBuilder) {
        this.m_where.setText(this.m_cachedWhere);
        if (this.m_includePrior) {
            this.m_prior.setVisible(true);
        } else {
            this.m_prior.setVisible(false);
        }
        if (sQLQueryBuilder != null) {
            HashSet<Object> hashSet = new HashSet<Object>();
            FromObject[] fromObjectArray = sQLQueryBuilder.listAllFromObjects();
            for (int i = 0; i < fromObjectArray.length; ++i) {
                hashSet.add(fromObjectArray[i]);
            }
            if (this.m_functions.getModel().getSize() == 0) {
                List list = this.m_pro.getDescriptor().listBuiltInFunctions();
                this.setFunctions(list);
                hashSet.addAll(list);
            }
            hashSet.add(AND);
            hashSet.add(OR);
            if (this.m_includePrior) {
                hashSet.add(PRIOR);
                hashSet.add(LEVEL);
            }
            hashSet.add(Comparison.Comparator.LIKE.getSQLText());
            hashSet.add(Comparison.Comparator.NOT_LIKE.getSQLText());
            hashSet.add(Comparison.Comparator.NULL.getSQLText());
            hashSet.add(Comparison.Comparator.NOT_NULL.getSQLText());
            hashSet.add(SetOperation.Operator.BETWEEN.getSQLText());
            hashSet.add(SetOperation.Operator.NOT_BETWEEN.getSQLText());
            hashSet.add(SetOperation.Operator.IN.getSQLText());
            hashSet.add(SetOperation.Operator.NOT_IN.getSQLText());
            if (this.m_bindVariables != null) {
                hashSet.addAll(this.m_bindVariables);
            }
            if (this.m_basePanel != null && this.m_completionSupport == null) {
                this.m_completionSupport = this.m_basePanel.getCompletionSupport(this.m_where);
            }
        }
    }

    public Component getDefaultComponent() {
        return this.m_where;
    }

    public String getWhereText() {
        return this.m_where.getText();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        TreePath treePath;
        Object object = mouseEvent.getSource();
        if (mouseEvent.getClickCount() % 2 == 0 && object == this.m_templates && (treePath = this.m_templates.getPathForLocation(mouseEvent.getX(), mouseEvent.getY())) != null) {
            this.insertCurrentTemplate();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath treePath = treeSelectionEvent.getPath();
        this.m_templates.scrollPathToVisible(treePath);
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        this.m_insertTempl.setEnabled(defaultMutableTreeNode.isLeaf());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_and) {
            this.addToWhere(AND);
        } else if (object == this.m_or) {
            this.addToWhere(OR);
        } else if (object == this.m_pars) {
            this.addToWhere("()");
        } else if (object == this.m_prior) {
            this.addToWhere(PRIOR);
        } else if (object == this.m_insertFunc) {
            this.insertCurrentFunction();
        } else if (object == this.m_insertTempl) {
            this.insertCurrentTemplate();
        } else if (object == this.m_subQuery) {
            this.addSubQueryToWhere();
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.m_and.setEnabled(bl);
        this.m_or.setEnabled(bl);
        this.m_pars.setEnabled(bl);
        this.m_prior.setEnabled(bl);
        this.m_templates.setEnabled(bl);
        this.m_scrollPane.setEnabled(bl);
        this.m_where.setEnabled(bl);
        this.m_subQuery.setEnabled(bl);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        int[] nArray;
        if (focusEvent.getComponent() == this.m_templates && (nArray = this.m_templates.getSelectionRows()) == null) {
            this.m_templates.setSelectionRow(0);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    private void addSubQueryToWhere() {
        try {
            SQLQueryEditDialog sQLQueryEditDialog = new SQLQueryEditDialog();
            sQLQueryEditDialog.setBindVariables(this.m_bindVariables);
            SQLQuery sQLQuery = sQLQueryEditDialog.editQuery(new SQLQuery(), this.m_pro, this.m_pro.getDefaultSchema());
            if (sQLQuery != null) {
                this.addToWhere("(" + sQLQuery.getSQLText() + ")");
            }
        }
        catch (SQLQueryException sQLQueryException) {
            DBExceptionDialog.showErrorDialog((Component)this.m_templates, UIBundle.get("FROM_EDIT_QUERY_ERR"), (DBException)((Object)sQLQueryException));
        }
        catch (DBException dBException) {
            // empty catch block
        }
    }
}

