/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.sql;

import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.ide.db.controls.DBObjectSourcePicker;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.panels.sql.BaseSQLQueryPickerPanel;
import oracle.ideimpl.db.panels.sql.QueryTargetPicker;
import oracle.ideimpl.db.panels.sql.QuickPickSourcePicker;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryOwner;

public class QuickPickObjectsPanel
extends BaseSQLQueryPickerPanel {
    public static final String SETTINGS_KEY_DB = "QuickPickObjectsPanel_DB";
    public static final String SETTINGS_KEY_OTHER = "QuickPickObjectsPanel";
    private QueryTargetPicker m_toPick = new QueryTargetPicker();
    private QuickPickSourcePicker m_fromPick;

    public QuickPickObjectsPanel() {
        this(true);
    }

    public QuickPickObjectsPanel(boolean bl) {
        super(bl);
        this.getShuttle().setButtonsShown(13);
    }

    @Override
    protected ItemPicker getToPicker() {
        return this.m_toPick;
    }

    @Override
    protected DBObjectSourcePicker getFromPicker() {
        if (this.m_fromPick == null) {
            DBEditorConfig dBEditorConfig;
            DBObject dBObject;
            this.m_fromPick = new QuickPickSourcePicker(this.getProvider(), true, false);
            SchemaObject schemaObject = this.getSchemaObject();
            if (schemaObject == null && (dBObject = (dBEditorConfig = (DBEditorConfig)this.getDataContext().get(DBEditorConfig.class)).getChildObject()) instanceof SQLQuery) {
                schemaObject = dBObject.getParent();
            }
            if (schemaObject instanceof SQLQueryOwner) {
                this.m_fromPick.setSQLQueryOwner((SQLQueryOwner)schemaObject);
            }
        }
        return this.m_fromPick;
    }

    @Override
    protected void clearToPicker() {
        this.m_toPick.clear();
    }

    @Override
    protected void initToPicker(SQLQueryBuilder sQLQueryBuilder, DBObjectProvider dBObjectProvider, Schema schema) {
        this.m_toPick.setQueryBuilder(sQLQueryBuilder);
        this.m_toPick.loadQuery();
    }

    @Override
    protected void commitToPicker(TraversableContext traversableContext) throws TraversalException {
        SQLQueryBuilder sQLQueryBuilder = this.getBuilder();
        if (sQLQueryBuilder != null && this.m_toPick.hasChanged()) {
            sQLQueryBuilder.getSQLQuery().setSelectObjects(this.m_toPick.getSelectList());
            this.m_toPick.removeNewEmptyFroms();
        }
    }

    @Override
    protected String getSettingsKey() {
        return this.getProvider() instanceof Database ? SETTINGS_KEY_DB : SETTINGS_KEY_OTHER;
    }

    @Override
    protected String getPanelName() {
        return SETTINGS_KEY_OTHER;
    }
}

