/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.sql;

import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.ToolTipManager;
import oracle.bali.ewt.shuttle.ReorderableListPicker;
import oracle.ide.Ide;
import oracle.ide.db.DBObjectTransferable;
import oracle.ide.db.dialogs.DBExceptionDialog;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.DBObjectUsage;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.JoinObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.db.sql.SynonymUsage;
import oracle.javatools.db.util.IdentitySet;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.util.ModelUtil;

public final class QueryTargetPicker
extends ReorderableListPicker {
    public static final String REMOVE_HELP_ID = null;
    private SQLQueryBuilder m_builder;
    private ComponentWithTitlebar m_compTitleBar = null;
    private final PathCache m_cache = new PathCache();
    private final Collection<DBObject> m_newToMe = new IdentitySet();
    private final Collection<FromObject> m_newFroms = new IdentitySet();
    private boolean m_changed;

    public QueryTargetPicker() {
        this(new JList());
    }

    public QueryTargetPicker(JList jList) {
        super(jList);
        ToolTipManager.sharedInstance().registerComponent(jList);
    }

    public void setQueryBuilder(SQLQueryBuilder sQLQueryBuilder) {
        this.clear();
        this.m_builder = sQLQueryBuilder;
        this.m_changed = false;
    }

    public SQLQueryBuilder getQueryBuilder() {
        return this.m_builder;
    }

    public synchronized void loadQuery() {
        DefaultListModel defaultListModel = (DefaultListModel)this.getList().getModel();
        defaultListModel.removeAllElements();
        this.m_newToMe.clear();
        this.m_newFroms.clear();
        SQLQuery sQLQuery = this.m_builder.getSQLQuery();
        SelectObject[] selectObjectArray = sQLQuery.getSelectObjects();
        this.m_cache.prunePaths();
        for (int i = 0; i < selectObjectArray.length; ++i) {
            defaultListModel.addElement(selectObjectArray[i]);
        }
        this.m_changed = false;
    }

    private FromObject findOrCreateFromPath(List<DBObject> list) {
        FromObject fromObject = null;
        if (list != null && list.size() > 0 && (fromObject = this.m_cache.findFrom(list)) == null) {
            ArrayList<DBObject> arrayList = new ArrayList<DBObject>(list);
            try {
                FromObject fromObject2 = null;
                for (int i = list.size() - 1; i >= 0; --i) {
                    boolean bl;
                    DBObject dBObject = list.get(i);
                    if (dBObject instanceof Relation || dBObject instanceof Synonym) {
                        fromObject2 = fromObject = this.findOrCreateFromObject((SchemaObject)dBObject, arrayList);
                        arrayList.remove(i);
                        continue;
                    }
                    if (!(dBObject instanceof FKConstraint)) continue;
                    arrayList.remove(i);
                    Relation relation = (Relation)list.get(--i);
                    FromObject fromObject3 = this.m_cache.findFrom(arrayList);
                    boolean bl2 = bl = fromObject3 != null;
                    if (!bl) {
                        fromObject3 = this.findOrCreateFromObject((SchemaObject)relation, arrayList);
                    }
                    arrayList.remove(i);
                    if (fromObject2.getExpression() instanceof JoinObject) {
                        fromObject2 = ((JoinObject)fromObject2.getExpression()).getLeftExpression();
                    }
                    this.m_builder.constructFKJoin((FKConstraint)dBObject, fromObject3, fromObject2);
                    fromObject2 = (FromObject)fromObject3.getParent().getParent();
                    if (!bl) {
                        continue;
                    }
                    break;
                }
            }
            catch (SQLQueryException sQLQueryException) {
                this.showExceptionDialog(sQLQueryException);
            }
        }
        return fromObject;
    }

    private FromObject findFromObject(DBObject dBObject, DBObjectUsage[] dBObjectUsageArray) {
        FromObject fromObject = null;
        for (DBObjectUsage dBObjectUsage : dBObjectUsageArray) {
            DBObject dBObject2;
            if (!ModelUtil.areEqual((Object)dBObjectUsage.getObjectID(), (Object)dBObject.getID()) || !((dBObject2 = dBObjectUsage.getParent()) instanceof FromObject)) continue;
            if (fromObject == null) {
                fromObject = (FromObject)dBObject2;
                continue;
            }
            fromObject = null;
            break;
        }
        return fromObject;
    }

    private FromObject findOrCreateFromObject(SchemaObject schemaObject, List<DBObject> list) throws SQLQueryException {
        SQLQueryBuilder.SQLQueryObjectSet sQLQueryObjectSet;
        FromObject fromObject = null;
        if (schemaObject instanceof Synonym) {
            sQLQueryObjectSet = DBUtil.findChildren((DBObject)this.m_builder.getSQLQuery(), SynonymUsage.class);
            if (sQLQueryObjectSet.size() > 0) {
                fromObject = this.findFromObject((DBObject)schemaObject, (DBObjectUsage[])sQLQueryObjectSet.toArray(new SynonymUsage[sQLQueryObjectSet.size()]));
            }
        } else if (schemaObject instanceof Relation) {
            fromObject = this.findFromObject((DBObject)schemaObject, (DBObjectUsage[])this.m_builder.getRelationUsages());
        }
        if (fromObject != null && (sQLQueryObjectSet = this.m_cache.findPath(fromObject)) != null && !this.m_cache.areEqual((List<DBObject>)sQLQueryObjectSet, list)) {
            fromObject = null;
        }
        if (fromObject == null) {
            sQLQueryObjectSet = this.m_builder.constructFromObject(schemaObject, false, false, null);
            fromObject = (FromObject)sQLQueryObjectSet.getObject();
        }
        this.m_cache.cachePath(list, fromObject);
        this.m_newFroms.add(fromObject);
        return fromObject;
    }

    public SelectObject[] getSelectList() {
        DefaultListModel defaultListModel = (DefaultListModel)this.getList().getModel();
        SelectObject[] selectObjectArray = new SelectObject[defaultListModel.getSize()];
        for (int i = 0; i < selectObjectArray.length; ++i) {
            selectObjectArray[i] = (SelectObject)defaultListModel.get(i);
        }
        return selectObjectArray;
    }

    private void showExceptionDialog(SQLQueryException sQLQueryException) {
        DBExceptionDialog.showErrorDialog(this.getComponent(), UIBundle.get("PICKER_ERROR_TITLE"), (DBException)((Object)sQLQueryException));
    }

    public boolean addSelectedItems(Transferable[] transferableArray) {
        for (int i = 0; i < transferableArray.length && this.m_builder != null; ++i) {
            if (!(transferableArray[i] instanceof DBObjectTransferable)) continue;
            this.m_changed = true;
            DBObject dBObject = ((DBObjectTransferable)transferableArray[i]).getDBObject();
            DBObject[] dBObjectArray = ((DBObjectTransferable)transferableArray[i]).getPath();
            if (dBObject instanceof Synonym) {
                dBObject = DBUtil.getSynonymReference((Synonym)((Synonym)dBObject));
            }
            if (!(dBObject instanceof Relation) && !(dBObject instanceof Column)) continue;
            ArrayList<DBObject> arrayList = new ArrayList<DBObject>(Arrays.asList(dBObjectArray));
            try {
                SelectObject selectObject;
                SQLQueryBuilder.SQLQueryObjectSet sQLQueryObjectSet;
                FromObject fromObject;
                if (dBObject instanceof Relation) {
                    fromObject = this.findOrCreateFromPath(arrayList);
                    if (this.m_builder.getFromObject(fromObject.getName()) != fromObject) {
                        this.m_builder.addFromObject(fromObject);
                        this.m_newFroms.add(fromObject);
                    }
                    sQLQueryObjectSet = ((Relation)dBObject).getColumns();
                    selectObject = this.m_builder.constructSelectObjects((Column[])sQLQueryObjectSet, new FromObject[]{fromObject});
                    SelectObject[] selectObjectArray = selectObject.getSelectObjects();
                    for (int j = 0; j < selectObjectArray.length; ++j) {
                        this.addSelectObject(selectObjectArray[j]);
                    }
                    continue;
                }
                if (!(dBObject instanceof Column)) continue;
                arrayList.remove(dBObject);
                fromObject = this.findOrCreateFromPath(arrayList);
                sQLQueryObjectSet = this.m_builder.constructSelectObject((Column)dBObject, fromObject);
                selectObject = (SelectObject)sQLQueryObjectSet.getObject();
                this.addSelectObject(selectObject);
                continue;
            }
            catch (SQLQueryException sQLQueryException) {
                this.showExceptionDialog(sQLQueryException);
            }
        }
        return true;
    }

    private void addSelectObject(SelectObject selectObject) throws SQLQueryException {
        selectObject.setID(TemporaryObjectID.createID((DBObject)selectObject));
        ((DefaultListModel)this.getList().getModel()).addElement(selectObject);
        this.m_newToMe.add((DBObject)selectObject);
    }

    protected Transferable createTransferable(Object object) {
        SQLFragment sQLFragment;
        if (object instanceof SelectObject && (sQLFragment = ((SelectObject)object).getExpression()) instanceof ColumnUsage) {
            DBObjectID dBObjectID = ((ColumnUsage)sQLFragment).getObjectID();
            try {
                return new DBObjectTransferable(dBObjectID.resolveID());
            }
            catch (DBException dBException) {
                dBException.printStackTrace();
            }
        }
        return new DBObjectTransferable(null);
    }

    public void removeAllSelectableItems() {
        this.getList().setSelectionInterval(0, this.getList().getModel().getSize() - 1);
        this.removeSelectedItems();
    }

    public void removeSelectedItems() {
        int n;
        this.m_changed = true;
        ListModel listModel = this.getList().getModel();
        if (!(listModel instanceof DefaultListModel)) {
            return;
        }
        boolean bl = true;
        DefaultListModel defaultListModel = (DefaultListModel)listModel;
        Object[] objectArray = this.getList().getSelectedValues();
        for (n = 0; n < objectArray.length; ++n) {
            if (this.m_newToMe.contains(objectArray[n])) continue;
            bl = false;
        }
        if (!bl) {
            bl = MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)UIBundle.get("PICKER_CONFIRM_REMOVE"), (String)UIBundle.get("PICKER_CONFIRM_REMOVE_TITLE"), (String)REMOVE_HELP_ID, (boolean)true);
        }
        if (bl) {
            for (n = 0; n < objectArray.length; ++n) {
                if (!(objectArray[n] instanceof SelectObject)) continue;
                this.m_builder.removeSelectObject((SelectObject)objectArray[n]);
                defaultListModel.removeElement(objectArray[n]);
            }
        }
    }

    void clear() {
        super.removeAllSelectableItems();
        this.m_changed = false;
    }

    boolean hasChanged() {
        return this.m_changed;
    }

    void removeNewEmptyFroms() {
        boolean bl = false;
        FromObject[] fromObjectArray = this.m_builder.getSQLQuery().getFromObjects();
        for (int i = 0; i < fromObjectArray.length; ++i) {
            if (!this.canRemove(fromObjectArray[i])) continue;
            this.m_builder.removeFromObject(fromObjectArray[i]);
            bl = true;
        }
        if (bl) {
            this.m_cache.prunePaths();
        }
    }

    private boolean canRemove(FromObject fromObject) {
        SQLFragment sQLFragment = fromObject.getExpression();
        if (sQLFragment instanceof JoinObject) {
            FromObject fromObject2 = ((JoinObject)sQLFragment).getLeftExpression();
            if (!this.canRemove(fromObject2)) {
                return false;
            }
            FromObject fromObject3 = ((JoinObject)sQLFragment).getRightExpression();
            return this.canRemove(fromObject3);
        }
        if (this.m_newFroms.contains(fromObject)) {
            Object[] objectArray = this.m_builder.getDependentObjects(fromObject);
            return !ModelUtil.hasNonNullElement((Object[])objectArray);
        }
        return false;
    }

    public Component getComponent() {
        if (this.m_compTitleBar == null) {
            this.m_compTitleBar = new ComponentWithTitlebar();
            this.m_compTitleBar.setComponent((JComponent)super.getComponent());
        }
        return this.m_compTitleBar;
    }

    public void moveSelectionBottom() {
        super.moveSelectionBottom();
        this.m_changed = true;
    }

    public void moveSelectionDown() {
        super.moveSelectionDown();
        this.m_changed = true;
    }

    public void moveSelectionTop() {
        super.moveSelectionTop();
        this.m_changed = true;
    }

    public void moveSelectionUp() {
        super.moveSelectionUp();
        this.m_changed = true;
    }

    public void processDnDReorder() {
        super.processDnDReorder();
        this.m_changed = true;
    }

    private class PathCache {
        private final List<List<DBObject>> m_pathKeys = new ArrayList<List<DBObject>>();
        private final List<FromObject> m_pathValues = new ArrayList<FromObject>();

        private PathCache() {
        }

        public void cachePath(List<DBObject> list, FromObject fromObject) {
            this.m_pathKeys.add(new ArrayList<DBObject>(list));
            this.m_pathValues.add(fromObject);
        }

        public void prunePaths() {
            if (this.m_pathKeys.size() > 0) {
                FromObject[] fromObjectArray = QueryTargetPicker.this.m_builder.listAllFromObjects();
                IdentitySet identitySet = new IdentitySet();
                for (FromObject fromObject : fromObjectArray) {
                    identitySet.add(fromObject);
                }
                for (int i = this.m_pathKeys.size() - 1; i >= 0; --i) {
                    FromObject fromObject = this.m_pathValues.get(i);
                    if (identitySet.contains(fromObject)) continue;
                    this.m_pathKeys.remove(i);
                    this.m_pathValues.remove(i);
                }
            }
        }

        public FromObject findFrom(List<DBObject> list) {
            FromObject fromObject = null;
            for (int i = 0; i < this.m_pathKeys.size(); ++i) {
                if (!this.areEqual(list, this.m_pathKeys.get(i))) continue;
                fromObject = this.m_pathValues.get(i);
                break;
            }
            return fromObject;
        }

        public List<DBObject> findPath(FromObject fromObject) {
            List<DBObject> list = null;
            for (int i = 0; i < this.m_pathValues.size(); ++i) {
                if (fromObject != this.m_pathValues.get(i)) continue;
                list = this.m_pathKeys.get(i);
                break;
            }
            return list;
        }

        public boolean areEqual(List<DBObject> list, List<DBObject> list2) {
            boolean bl = false;
            if (list.size() == list2.size()) {
                bl = true;
                for (int i = 0; i < list.size(); ++i) {
                    DBObject dBObject;
                    DBObject dBObject2 = list.get(i);
                    if (dBObject2 == (dBObject = list2.get(i))) continue;
                    bl = false;
                    break;
                }
            }
            return bl;
        }
    }
}

