/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.sql;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.ide.Ide;
import oracle.ide.db.DBObjectTransferable;
import oracle.ide.db.controls.AbstractTreePicker;
import oracle.ide.db.dialogs.DBExceptionDialog;
import oracle.ide.db.panels.sql.SQLQueryEditDialog;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.db.util.IconWithSmallOverlay;
import oracle.ide.db.util.TreeNodeMaker;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Assert;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.Namespace;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.panels.sql.JoinObjectEditDialog;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.JoinObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryBuilderFactory;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.util.ModelUtil;

public class FromJoinToPicker
extends AbstractTreePicker
implements DocumentListener {
    public static final String REMOVE_FROM_HELP_ID = "f1_offdbremovefromfromlist_html";
    private JPanel m_panel;
    private DefaultMutableTreeNode m_treeRoot = new DefaultMutableTreeNode("ROOT");
    private DefaultTreeModel m_treeModel = new DefaultTreeModel(this.m_treeRoot);
    private JTree m_tree = new JTree(this.m_treeModel);
    private ControlBar m_toolbar = new ControlBar();
    private ComponentWithTitlebar m_compTitleBar = new ComponentWithTitlebar();
    private DBObjectRenderer m_rend = new DBObjectRenderer();
    private TreeNodeMaker m_nodeMaker = new TreeNodeMaker(true);
    private JLabel m_aliasLabel = new JLabel();
    private JTextField m_alias = new JTextField();
    private JButton m_joinButton = new JButton(new JoinAction());
    private JButton m_editButton = new JButton(new EditQueryAction());
    private JButton m_addSubQueryButton = new JButton(new AddQueryAction());
    private JButton m_removeButton = new JButton(new RemoveAction());
    private boolean m_commitPending;
    private boolean m_ignoreTree;
    private DefaultMutableTreeNode m_current;
    private SQLQueryBuilder m_builder;
    private DBObjectProvider m_pro;
    private Schema m_schema;
    private Namespace m_dataContext;

    public FromJoinToPicker() {
        this.m_rend.setIncludeIcon(true);
        this.setTree(this.m_tree);
        this.m_tree.setShowsRootHandles(true);
        this.m_tree.setRootVisible(false);
        this.m_tree.setCellRenderer(this.m_rend);
        this.m_compTitleBar.setControlBar(this.m_toolbar);
        this.m_compTitleBar.setComponent((JComponent)new JScrollPane(this.m_tree));
        try {
            this.layoutComponents();
        }
        catch (Exception exception) {
            DBLog.getLogger((Object)this).log(Level.SEVERE, "layout failed", exception);
        }
    }

    private void layoutComponents() {
        DBUIResourceHelper dBUIResourceHelper = new DBUIResourceHelper("FromJoinToPicker");
        JLabel jLabel = new JLabel();
        dBUIResourceHelper.resLabel(jLabel, this.m_compTitleBar.getComponent(), UIBundle.get("PICKER_SELECTED"), "Selected");
        this.m_compTitleBar.setLabel(jLabel);
        this.m_panel = new JPanel();
        this.m_panel.setLayout(new GridBagLayout());
        this.m_toolbar.removeAll();
        this.m_toolbar.add((Component)this.m_removeButton);
        this.m_toolbar.add((Component)this.m_addSubQueryButton);
        this.m_toolbar.add((Component)this.m_joinButton);
        this.m_toolbar.add((Component)this.m_editButton);
        dBUIResourceHelper.setName(this.m_joinButton, "Join");
        dBUIResourceHelper.setName(this.m_editButton, "Edit");
        dBUIResourceHelper.setName(this.m_removeButton, "Remove");
        int n = 0;
        this.m_panel.add((Component)this.m_compTitleBar, new GridBagConstraints(1, n, 4, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 5, 0), 0, 0));
        dBUIResourceHelper.setName(this.m_tree, "Tree");
        dBUIResourceHelper.resLabel(this.m_aliasLabel, this.m_alias, UIBundle.get("EXP_ALIAS"), "Alias");
        this.m_panel.add((Component)this.m_aliasLabel, new GridBagConstraints(1, ++n, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.m_alias.getDocument().addDocumentListener(this);
        this.m_panel.add((Component)this.m_alias, new GridBagConstraints(2, n, 3, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.m_panel.add(Box.createHorizontalGlue(), new GridBagConstraints(1, ++n, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
    }

    protected void init(SQLQueryBuilder sQLQueryBuilder, DBObjectProvider dBObjectProvider, Schema schema, Namespace namespace) {
        this.m_builder = sQLQueryBuilder;
        this.m_pro = dBObjectProvider;
        this.m_schema = schema;
        this.m_dataContext = namespace;
        this.m_aliasLabel.setEnabled(false);
        this.m_alias.setEnabled(false);
        this.m_joinButton.setEnabled(false);
        this.m_editButton.setEnabled(false);
        this.m_addSubQueryButton.setEnabled(true);
        this.loadTree();
        this.m_removeButton.setEnabled(this.m_treeModel.getChildCount(this.m_treeModel.getRoot()) > 0);
    }

    private void loadTree() {
        this.m_treeRoot.removeAllChildren();
        FromObject[] fromObjectArray = this.m_builder.getSQLQuery().getFromObjects();
        for (int i = 0; i < fromObjectArray.length; ++i) {
            this.m_treeRoot.add(this.m_nodeMaker.createTreeNode((SQLFragment)fromObjectArray[i]));
        }
        this.reloadTreeUI();
    }

    private void reloadTreeUI() {
        this.m_treeModel.reload();
        IdeUtil.expandAllTreeRows((JTree)this.m_tree);
    }

    protected void setSelectedObject(FromObject fromObject) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        if (fromObject != null && (defaultMutableTreeNode = this.findNode(fromObject, this.m_treeRoot)) != null) {
            TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
            this.m_tree.setSelectionPath(treePath);
        }
    }

    private DefaultMutableTreeNode findNode(FromObject fromObject, DefaultMutableTreeNode defaultMutableTreeNode) {
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!fromObject.equals(defaultMutableTreeNode2.getUserObject())) continue;
            return defaultMutableTreeNode2;
        }
        enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            this.findNode(fromObject, (DefaultMutableTreeNode)enumeration.nextElement());
        }
        return null;
    }

    protected void commit() throws SQLQueryException {
        if (this.m_commitPending) {
            FromObject fromObject = (FromObject)this.m_current.getUserObject();
            String string = this.m_alias.getText();
            if (ModelUtil.areDifferent((Object)string, (Object)fromObject.getAlias())) {
                FromObject fromObject2 = (FromObject)fromObject.copyTo(null);
                fromObject2.setAlias(string);
                this.m_builder.replaceFromObject(fromObject, fromObject2);
                this.m_treeModel.nodeChanged(this.m_current);
            }
            this.m_commitPending = false;
        }
    }

    protected void exit() throws TraversalException {
        try {
            this.commit();
        }
        catch (SQLQueryException sQLQueryException) {
            this.m_alias.requestFocus();
            throw new TraversalException(sQLQueryException.getMessage());
        }
    }

    private boolean isJoinNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof FromObject) {
            return ((FromObject)object).getExpression() instanceof JoinObject;
        }
        return false;
    }

    private boolean isSubQueryNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof FromObject) {
            return ((FromObject)object).getExpression() instanceof SQLQuery;
        }
        return false;
    }

    private void join(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2) {
        JoinObject joinObject = new JoinObject();
        FromObject fromObject = new FromObject((SQLFragment)joinObject, null);
        FromObject fromObject2 = (FromObject)defaultMutableTreeNode.getUserObject();
        FromObject fromObject3 = (FromObject)defaultMutableTreeNode2.getUserObject();
        joinObject.setLeftExpression(fromObject2);
        joinObject.setRightExpression(fromObject3);
        if (JoinObjectEditDialog.editJoin(fromObject, this.m_editButton, this.m_builder, this.m_pro)) {
            DefaultMutableTreeNode defaultMutableTreeNode3 = this.m_nodeMaker.createTreeNode((SQLFragment)fromObject);
            DefaultMutableTreeNode defaultMutableTreeNode4 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            defaultMutableTreeNode4.insert(defaultMutableTreeNode3, defaultMutableTreeNode4.getIndex(defaultMutableTreeNode));
            defaultMutableTreeNode4.remove(defaultMutableTreeNode);
            defaultMutableTreeNode4.remove(defaultMutableTreeNode2);
            this.reloadTreeUI();
            this.m_tree.scrollPathToVisible(new TreePath(defaultMutableTreeNode3.getPath()));
            SQLQuery sQLQuery = this.m_builder.getSQLQuery();
            if (sQLQuery != null && sQLQuery.isDeclarative()) {
                sQLQuery.removeFromObject(fromObject2);
                sQLQuery.removeFromObject(fromObject3);
                try {
                    this.m_builder.addFromObject(fromObject);
                }
                catch (SQLQueryException sQLQueryException) {
                    Assert.printStackTrace((Throwable)sQLQueryException);
                    sQLQuery.addFromObject(fromObject2);
                    sQLQuery.addFromObject(fromObject3);
                }
            }
        }
    }

    private boolean edit(DefaultMutableTreeNode defaultMutableTreeNode) {
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof FromObject) {
            SQLFragment sQLFragment = ((FromObject)object).getExpression();
            if (sQLFragment instanceof SQLQuery) {
                try {
                    SQLQueryEditDialog sQLQueryEditDialog = this.newSQLQueryEditDialog();
                    SQLQuery sQLQuery = sQLQueryEditDialog.editQuery((SQLQuery)sQLFragment, this.m_pro, this.m_schema);
                    if (sQLQuery != null) {
                        FromObject fromObject = new FromObject();
                        fromObject.setAlias(((FromObject)object).getAlias());
                        fromObject.setExpression((SQLFragment)sQLQuery);
                        this.m_builder.replaceFromObject((FromObject)object, fromObject);
                    }
                }
                catch (SQLQueryException sQLQueryException) {
                    DBExceptionDialog.showErrorDialog((Component)this.m_tree, UIBundle.get("FROM_EDIT_QUERY_ERR"), (DBException)((Object)sQLQueryException));
                }
                return true;
            }
            if (sQLFragment instanceof JoinObject) {
                if (JoinObjectEditDialog.editJoin((FromObject)object, this.m_editButton, this.m_builder, this.m_pro)) {
                    sQLFragment = ((FromObject)object).getExpression();
                    DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(0);
                    DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(1);
                    FromObject fromObject = ((JoinObject)sQLFragment).getLeftExpression();
                    if (fromObject == defaultMutableTreeNode3.getUserObject()) {
                        defaultMutableTreeNode2.removeFromParent();
                        defaultMutableTreeNode.add(defaultMutableTreeNode2);
                        this.m_treeModel.reload(defaultMutableTreeNode);
                    } else {
                        this.m_treeModel.nodeStructureChanged(defaultMutableTreeNode);
                    }
                }
                return true;
            }
        }
        return false;
    }

    private SQLQueryEditDialog newSQLQueryEditDialog() {
        SQLQueryEditDialog sQLQueryEditDialog = new SQLQueryEditDialog();
        if (this.m_dataContext != null) {
            sQLQueryEditDialog.setBindVariables((Collection)this.m_dataContext.find("bindVariables"));
        }
        return sQLQueryEditDialog;
    }

    private void addNewSubQuery() {
        String string;
        String string2;
        SQLQueryEditDialog sQLQueryEditDialog = this.newSQLQueryEditDialog();
        SQLQuery sQLQuery = sQLQueryEditDialog.editQuery(new SQLQuery(), this.m_pro, this.m_schema);
        if (sQLQuery != null && sQLQuery != null && sQLQuery.getSQLText() != null && !(string2 = sQLQuery.getSQLText().replaceAll(" ", "").replaceAll("\n", "")).startsWith(string = "SELECT \n    \nFROM \n    \n".replaceAll(" ", "").replaceAll("\n", ""))) {
            FromObject fromObject = new FromObject();
            fromObject.setExpression((SQLFragment)sQLQuery);
            try {
                SQLQueryBuilder sQLQueryBuilder = SQLQueryBuilderFactory.findOrCreateBuilder((SQLQuery)sQLQuery, (DBObjectProvider)this.m_pro, (Schema)this.m_schema);
                sQLQueryBuilder.buildQuery(sQLQuery);
                this.m_builder.addFromObject(fromObject);
            }
            catch (SQLQueryException sQLQueryException) {
                DBExceptionDialog.showErrorDialog((Component)this.m_tree, UIBundle.get("FROM_EDIT_QUERY_ERR"), (DBException)((Object)sQLQueryException));
            }
            this.loadTree();
            int n = this.m_treeModel.getChildCount(this.m_treeModel.getRoot());
            this.m_tree.setSelectionRow(n - 1);
        }
    }

    private void addJoinToSelection(DefaultMutableTreeNode defaultMutableTreeNode, List list) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(0);
        DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(1);
        list.add(new TreePath(defaultMutableTreeNode.getPath()));
        if (this.isJoinNode(defaultMutableTreeNode2)) {
            this.addJoinToSelection(defaultMutableTreeNode2, list);
        } else {
            list.add(new TreePath(defaultMutableTreeNode2.getPath()));
        }
        if (this.isJoinNode(defaultMutableTreeNode3)) {
            this.addJoinToSelection(defaultMutableTreeNode3, list);
        } else {
            list.add(new TreePath(defaultMutableTreeNode3.getPath()));
        }
    }

    private void addRelation(SchemaObject schemaObject, List list, DefaultMutableTreeNode defaultMutableTreeNode) throws SQLQueryException {
        SQLQueryBuilder.SQLQueryObjectSet sQLQueryObjectSet = this.m_builder.constructFromObject(schemaObject, false, false, null);
        FromObject fromObject = (FromObject)sQLQueryObjectSet.getObject();
        DefaultMutableTreeNode defaultMutableTreeNode2 = this.m_nodeMaker.createTreeNode((SQLFragment)fromObject);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        list.add(new TreePath(defaultMutableTreeNode2.getPath()));
    }

    private void addFKs(DBObject[] dBObjectArray, List list) throws SQLQueryException {
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        for (int i = 0; i < dBObjectArray.length; ++i) {
            if (!(dBObjectArray[i] instanceof FKConstraint)) continue;
            arrayList.add(dBObjectArray[i]);
        }
        FKConstraint[] fKConstraintArray = arrayList.toArray(new FKConstraint[arrayList.size()]);
        SQLQueryBuilder.SQLQueryObjectSet sQLQueryObjectSet = this.m_builder.constructFKJoins(fKConstraintArray, null);
        FromObject[] fromObjectArray = sQLQueryObjectSet.getFromObjects();
        if (fromObjectArray != null && fromObjectArray.length > 0) {
            DefaultMutableTreeNode defaultMutableTreeNode = this.m_nodeMaker.createTreeNode((SQLFragment)fromObjectArray[0], false);
            this.m_treeRoot.add(defaultMutableTreeNode);
            this.addJoinToSelection(defaultMutableTreeNode, list);
        }
    }

    @Override
    public boolean addSelectedItems(Transferable[] transferableArray) {
        try {
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < transferableArray.length; ++i) {
                DBObject dBObject = ((DBObjectTransferable)transferableArray[i]).getDBObject();
                DBObject[] dBObjectArray = ((DBObjectTransferable)transferableArray[i]).getPath();
                if (dBObjectArray == null || dBObjectArray.length == 1) {
                    if (!(dBObject instanceof Relation) && !(dBObject instanceof Synonym)) continue;
                    this.addRelation((SchemaObject)dBObject, arrayList, this.m_treeRoot);
                    continue;
                }
                this.addFKs(dBObjectArray, arrayList);
            }
            this.reloadTreeUI();
            this.m_tree.setSelectionPaths(arrayList.toArray(new TreePath[arrayList.size()]));
            return true;
        }
        catch (SQLQueryException sQLQueryException) {
            DBExceptionDialog.showErrorDialog(this.getComponent(), null, (DBException)((Object)sQLQueryException));
            return false;
        }
    }

    @Override
    public Transferable createTransferable(TreePath treePath) {
        Object object = treePath.getLastPathComponent();
        if (object instanceof DefaultMutableTreeNode && ((DefaultMutableTreeNode)object).getUserObject() instanceof SQLFragment) {
            return new DBObjectTransferable(null);
        }
        return null;
    }

    @Override
    public Transferable[] getAllSelectableItems() {
        return new DBObjectTransferable[]{new DBObjectTransferable(null)};
    }

    @Override
    public void removeAllSelectableItems() {
        if (this.m_builder != null) {
            ArrayList<SQLFragment> arrayList = new ArrayList<SQLFragment>();
            FromObject[] fromObjectArray = this.m_builder.listAllFromObjects();
            for (int i = 0; fromObjectArray != null && i < fromObjectArray.length; ++i) {
                arrayList.addAll(Arrays.asList(this.m_builder.getDependentObjects(fromObjectArray[i])));
            }
            String string = UIBundle.get("FROM_DEPS");
            if (arrayList.size() < 1 || MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)string, (String)UIBundle.get("FROM_DEPS_TITLE"), (String)REMOVE_FROM_HELP_ID, (boolean)true)) {
                for (int i = 0; fromObjectArray != null && i < fromObjectArray.length; ++i) {
                    this.m_builder.removeFromObject(fromObjectArray[i]);
                }
                this.clear();
            }
        }
    }

    protected void clear() {
        this.m_treeRoot.removeAllChildren();
        this.m_treeModel.reload();
    }

    @Override
    public void removeSelectedItems() {
        boolean bl;
        Object object;
        Object object2;
        ArrayList<SQLFragment> arrayList = new ArrayList<SQLFragment>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        HashSet<DBObject> hashSet = new HashSet<DBObject>();
        TreePath[] treePathArray = this.m_tree.getSelectionPaths();
        for (int i = 0; i < treePathArray.length; ++i) {
            DBObject dBObject;
            Object object3 = treePathArray[i].getLastPathComponent();
            if (!(object3 instanceof DefaultMutableTreeNode) || !((object2 = ((DefaultMutableTreeNode)object3).getUserObject()) instanceof FromObject)) continue;
            object = (FromObject)object2;
            SQLFragment sQLFragment = object.getExpression();
            if (sQLFragment instanceof JoinObject) {
                arrayList3.add(object2);
                continue;
            }
            SQLFragment[] sQLFragmentArray = this.m_builder.getDependentObjects(object);
            if (sQLFragmentArray != null) {
                arrayList.addAll(Arrays.asList(sQLFragmentArray));
            }
            if ((dBObject = object.getParent()) instanceof JoinObject) {
                hashSet.add(dBObject);
            }
            arrayList2.add(object2);
        }
        for (JoinObject joinObject : hashSet) {
            if (!(joinObject.getParent() instanceof FromObject) || !arrayList2.contains(object2 = joinObject.getLeftExpression()) || !arrayList2.contains(object = joinObject.getRightExpression())) continue;
            arrayList2.remove(object2);
            arrayList2.remove(object);
            arrayList2.add(joinObject.getParent());
            if (!arrayList3.contains(joinObject)) continue;
            arrayList3.remove(joinObject);
        }
        boolean bl2 = true;
        if (arrayList.size() > 0) {
            object2 = UIBundle.get("FROM_DEPS");
            bl = MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)object2, (String)UIBundle.get("FROM_DEPS_TITLE"), (String)REMOVE_FROM_HELP_ID, (boolean)true);
        }
        if (bl) {
            int n;
            for (n = 0; n < arrayList2.size(); ++n) {
                object = arrayList2.get(n);
                if (!(object instanceof FromObject)) continue;
                this.m_builder.removeFromObject(object);
            }
            for (n = 0; n < arrayList3.size(); ++n) {
                object = arrayList3.get(n);
                if (!(object instanceof FromObject)) continue;
                this.m_builder.removeJoinObject(object);
            }
            this.m_commitPending = false;
            this.loadTree();
            this.m_removeButton.setEnabled(this.m_treeModel.getChildCount(this.m_treeModel.getRoot()) > 0);
        }
    }

    @Override
    public Component getComponent() {
        return this.m_panel;
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.m_commitPending = true;
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.m_commitPending = true;
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.m_commitPending = true;
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (!this.m_ignoreTree) {
            if (this.m_alias.isEnabled()) {
                try {
                    this.commit();
                }
                catch (SQLQueryException sQLQueryException) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)sQLQueryException.getMessage(), (String)"", null);
                    this.m_ignoreTree = true;
                    this.m_tree.setSelectionPath(treeSelectionEvent.getOldLeadSelectionPath());
                    this.m_ignoreTree = false;
                    this.m_alias.requestFocus();
                    return;
                }
            }
            super.valueChanged(treeSelectionEvent);
            this.m_joinButton.setEnabled(false);
            this.m_editButton.setEnabled(false);
            this.m_removeButton.setEnabled(this.m_treeModel.getChildCount(this.m_treeModel.getRoot()) > 0);
            DefaultMutableTreeNode defaultMutableTreeNode = null;
            FromObject fromObject = null;
            TreePath[] treePathArray = this.m_tree.getSelectionPaths();
            if (treePathArray != null) {
                if (treePathArray.length == 1) {
                    DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treePathArray[0].getLastPathComponent();
                    if (this.isJoinNode(defaultMutableTreeNode2) || this.isSubQueryNode(defaultMutableTreeNode2)) {
                        this.m_editButton.setEnabled(true);
                        defaultMutableTreeNode = defaultMutableTreeNode2;
                        fromObject = (FromObject)defaultMutableTreeNode2.getUserObject();
                    } else if (defaultMutableTreeNode2.getUserObject() instanceof FromObject) {
                        fromObject = (FromObject)defaultMutableTreeNode2.getUserObject();
                        defaultMutableTreeNode = defaultMutableTreeNode2;
                    }
                } else if (treePathArray.length == 2) {
                    DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)treePathArray[0].getLastPathComponent();
                    DefaultMutableTreeNode defaultMutableTreeNode4 = (DefaultMutableTreeNode)treePathArray[1].getLastPathComponent();
                    DefaultMutableTreeNode defaultMutableTreeNode5 = (DefaultMutableTreeNode)defaultMutableTreeNode3.getParent();
                    if (defaultMutableTreeNode5 == defaultMutableTreeNode4.getParent() && !this.isJoinNode(defaultMutableTreeNode5)) {
                        this.m_joinButton.setEnabled(true);
                    }
                }
            }
            if (fromObject != null) {
                if (defaultMutableTreeNode != this.m_current) {
                    this.m_current = defaultMutableTreeNode;
                    if (this.isJoinNode(this.m_current)) {
                        this.m_alias.setEnabled(false);
                    } else {
                        this.m_alias.setEnabled(true);
                    }
                    this.m_aliasLabel.setEnabled(true);
                    this.m_alias.setText(fromObject.getAlias());
                    this.m_alias.requestFocus();
                    this.m_commitPending = false;
                }
            } else {
                this.m_current = null;
                this.m_alias.setText(null);
                this.m_alias.setEnabled(false);
                this.m_aliasLabel.setEnabled(false);
                this.m_commitPending = false;
            }
        }
    }

    @Override
    protected boolean handleDefaultAction(TreePath treePath) {
        Object object = treePath.getLastPathComponent();
        if (object instanceof DefaultMutableTreeNode) {
            Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
            if (this.isJoinNode((DefaultMutableTreeNode)object) || this.isSubQueryNode((DefaultMutableTreeNode)object)) {
                return this.edit((DefaultMutableTreeNode)object);
            }
        }
        return super.handleDefaultAction(treePath);
    }

    class JoinAction
    extends AbstractAction {
        public JoinAction() {
            this.putValue("SmallIcon", OracleIcons.getIcon((String)"join_object.png"));
            this.putValue("ShortDescription", UIBundle.get("FROM_JOIN"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TreePath[] treePathArray = FromJoinToPicker.this.m_tree.getSelectionPaths();
            if (treePathArray.length == 2) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[0].getLastPathComponent();
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treePathArray[1].getLastPathComponent();
                FromJoinToPicker.this.join(defaultMutableTreeNode, defaultMutableTreeNode2);
            }
        }
    }

    class RemoveAction
    extends AbstractAction {
        public RemoveAction() {
            this.putValue("SmallIcon", OracleIcons.getIcon((String)"delete.png"));
            this.putValue("ShortDescription", UIBundle.get("FROM_REMOVE_SELECTED"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FromJoinToPicker.this.removeSelectedItems();
        }
    }

    class AddQueryAction
    extends AbstractAction {
        public AddQueryAction() {
            IconWithSmallOverlay iconWithSmallOverlay = new IconWithSmallOverlay(OracleIcons.getIcon((String)"view.png"), OracleIcons.getIcon((String)"add.png"));
            this.putValue("SmallIcon", iconWithSmallOverlay);
            this.putValue("ShortDescription", UIBundle.get("FROM_ADD_INLINE_VIEW"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FromJoinToPicker.this.addNewSubQuery();
        }
    }

    class EditQueryAction
    extends AbstractAction {
        public EditQueryAction() {
            this.putValue("SmallIcon", OracleIcons.getIcon((String)"edit.png"));
            this.putValue("ShortDescription", UIBundle.get("FROM_EDIT"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TreePath[] treePathArray = FromJoinToPicker.this.m_tree.getSelectionPaths();
            if (treePathArray.length == 1) {
                FromJoinToPicker.this.edit((DefaultMutableTreeNode)treePathArray[0].getLastPathComponent());
            }
        }
    }
}

