/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.plsql;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.SwingUtilities;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.panels.plsql.PlSqlPanel;
import oracle.ideimpl.db.panels.plsql.TriggerBaseObjectIdPanel;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.db.plsql.Trigger;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.property.PropertyManager;

public class TriggerPanel
extends PlSqlPanel<Trigger> {
    public TriggerPanel() {
        super("TriggerPanel");
    }

    @Override
    protected void initialiseComponents() {
        ComponentWrapper componentWrapper = this.getOrCreateWrapper("enabled");
        ComponentWrapper componentWrapper2 = this.getOrCreateWrapper("baseType");
        ComponentWrapper componentWrapper3 = this.getOrCreateWrapper("baseObjectID");
        ComponentWrapper componentWrapper4 = this.getOrCreateWrapper("timing");
        ComponentWrapper componentWrapper5 = this.getOrCreateWrapper("events");
        ComponentWrapper componentWrapper6 = this.getOrCreateWrapper("statementLevel");
        ComponentWrapper componentWrapper7 = this.getOrCreateWrapper("referencingNewAs");
        ComponentWrapper componentWrapper8 = this.getOrCreateWrapper("referencingOldAs");
        ComponentWrapper componentWrapper9 = this.getOrCreateWrapper("whenClause");
        ComponentWrapper componentWrapper10 = this.getOrCreateWrapper("columnIDs");
        DBUILayoutHelper dBUILayoutHelper = this.getDBUILayoutHelper();
        if (this.isInFlatEditor()) {
            dBUILayoutHelper.add(componentWrapper.getComponent());
            dBUILayoutHelper.nextRow();
        }
        dBUILayoutHelper.add(componentWrapper2.getLabel());
        dBUILayoutHelper.add(componentWrapper2.getComponent(), 3, 1);
        dBUILayoutHelper.nextRow();
        dBUILayoutHelper.addChildren(componentWrapper3, 1, 3);
        dBUILayoutHelper.nextRow();
        dBUILayoutHelper.add(componentWrapper4.getLabel());
        dBUILayoutHelper.add(componentWrapper4.getComponent(), 3, 1);
        dBUILayoutHelper.nextRow();
        dBUILayoutHelper.add(componentWrapper5.getLabel());
        dBUILayoutHelper.add(componentWrapper5.getComponent(), 3, 1, true, true);
        dBUILayoutHelper.nextRow();
        dBUILayoutHelper.add(componentWrapper10.getLabel());
        dBUILayoutHelper.add(componentWrapper10.getComponent(), 3, 1, true, true);
        dBUILayoutHelper.nextRow();
        dBUILayoutHelper.add(componentWrapper8.getLabel());
        dBUILayoutHelper.add(componentWrapper8.getComponent());
        dBUILayoutHelper.add(componentWrapper6.getComponent(), 2, 1);
        dBUILayoutHelper.nextRow();
        dBUILayoutHelper.add(componentWrapper7.getLabel());
        dBUILayoutHelper.add(componentWrapper7.getComponent());
        dBUILayoutHelper.add(componentWrapper9.getLabel());
        dBUILayoutHelper.add(componentWrapper9.getComponent());
        dBUILayoutHelper.pushUp();
        dBUILayoutHelper.layout();
        if (!this.isEditing()) {
            componentWrapper2.addListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    TriggerPanel.this.baseTypeChanged(propertyChangeEvent);
                }
            });
        }
    }

    @Override
    protected DBObjectListener createObjectListener() {
        DBObjectListener dBObjectListener = null;
        if (!this.isInFlatEditor()) {
            dBObjectListener = new DBObjectListener(){

                public void objectUpdated(DBObjectChange dBObjectChange) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TriggerPanel.this.initialisePanel();
                        }
                    });
                }
            };
        }
        return dBObjectListener;
    }

    @Override
    protected void initialisePanel() {
        super.initialisePanel();
        ComponentWrapper componentWrapper = this.getOrCreateWrapper("baseType");
        ComponentWrapper componentWrapper2 = this.getOrCreateWrapper("baseObjectID");
        Trigger trigger = (Trigger)this.getUpdatedObject();
        Trigger.BaseType baseType = trigger.getBaseType();
        componentWrapper.setEnabled(!this.isEditing());
        ((TriggerBaseObjectIdPanel)componentWrapper2.getActiveComponent()).setBaseType(baseType);
        PropertyManager propertyManager = this.getProvider().getPropertyManager();
        PropertyHelper propertyHelper = this.getPropertyHelper();
        if (propertyManager != null) {
            for (ComponentWrapper object : this.getComponentFactory().getComponentWrappers()) {
                if (object == componentWrapper) continue;
                object.processComponent(this.isEditable(), true);
                object.setPropertyValue(propertyHelper.getPropertyValue((Object)trigger, object.getPropertyName()));
            }
        }
        if (baseType == Trigger.BaseType.TABLE) {
            ComponentWrapper componentWrapper3 = this.getOrCreateWrapper("columnIDs");
            List<String> list = Arrays.asList(trigger.getEvents());
            boolean bl = list.contains("UPDATE");
            componentWrapper3.setEnabled(bl);
            if (!bl) {
                componentWrapper3.setPropertyValue(null);
            }
            ComponentWrapper componentWrapper4 = this.getOrCreateWrapper("whenClause");
            componentWrapper4.setEnabled(!trigger.isStatementLevel());
        }
    }

    private void eventsChanged(PropertyChangeEvent propertyChangeEvent) {
        this.getComponentFactory().forceProcessComponents();
    }

    private void baseTypeChanged(PropertyChangeEvent propertyChangeEvent) {
        Schema schema;
        this.resetPropertyValue("columnIDs", new DBObjectID[0]);
        this.resetPropertyValue("events", new String[0]);
        if (propertyChangeEvent.getNewValue() == Trigger.BaseType.VIEW) {
            this.resetPropertyValue("timing", Trigger.Timing.INSTEAD_OF);
        } else if (propertyChangeEvent.getOldValue() == Trigger.BaseType.VIEW) {
            this.resetPropertyValue("timing", Trigger.Timing.BEFORE);
        }
        DBObjectID dBObjectID = null;
        if (propertyChangeEvent.getNewValue() == Trigger.BaseType.SCHEMA && (dBObjectID = (schema = ((Trigger)this.getUpdatedObject()).getSchema()).getID()) == null) {
            try {
                schema = this.getProvider().getSchema(schema.getName());
                dBObjectID = schema.getID();
            }
            catch (DBException dBException) {
                this.getLogger().warning(dBException.getMessage());
            }
        }
        this.resetPropertyValue("baseObjectID", dBObjectID);
        this.getComponentFactory().forceProcessComponents();
    }

    private void resetPropertyValue(String string, Object object) {
        this.getComponentFactory().findComponentWrapper(string).resetPropertyValue(object);
    }
}

