/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.partition;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.ora.IndexPartition;
import oracle.javatools.db.ora.OracleIndexPartitions;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.TablePartition;

class PartitionRenderer
extends DBObjectRenderer {
    PartitionRenderer() {
        super(false);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        DBObject dBObject = (DBObject)((DefaultMutableTreeNode)object).getUserObject();
        boolean bl5 = false;
        if (dBObject instanceof TablePartition) {
            TablePartition tablePartition = (TablePartition)dBObject;
            jLabel.setText(this.getText(tablePartition));
            if (tablePartition.getPartitionType() == OracleTablePartitions.PartitionType.REFERENCE && tablePartition.getParent() == null || tablePartition.getObjectType() == OracleTablePartitions.ObjectType.SUBPARTITION_TEMPLATE) {
                bl5 = true;
            }
        } else if (dBObject instanceof IndexPartition) {
            OracleIndexPartitions oracleIndexPartitions;
            IndexPartition indexPartition = (IndexPartition)dBObject;
            DBObject dBObject2 = indexPartition.getParent();
            if (dBObject2 == null) {
                bl5 = true;
            } else if (dBObject2 instanceof OracleIndexPartitions && (oracleIndexPartitions = (OracleIndexPartitions)dBObject2).getPartitionType() == OracleIndexPartitions.PartitionType.SUBPARTITION && dBObject2.getParent().getParent() == null) {
                bl5 = true;
            }
            jLabel.setText(indexPartition.getName());
        }
        if (bl5) {
            jLabel.setForeground(UIManager.getColor("Button.disabled"));
            jLabel.setEnabled(false);
        }
        jLabel.setIcon(null);
        return jLabel;
    }

    @Override
    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        JLabel jLabel = (JLabel)super.getListCellRendererComponent(jList, object, n, bl, bl2);
        TablePartition tablePartition = (TablePartition)object;
        jLabel.setText(this.getText(tablePartition));
        return jLabel;
    }

    private String getText(TablePartition tablePartition) {
        StringBuilder stringBuilder = new StringBuilder(tablePartition.getName());
        Object[] objectArray = tablePartition.getValues();
        if (objectArray != null && objectArray.length > 0) {
            stringBuilder.append(" (");
            for (Object object : objectArray) {
                stringBuilder.append(object);
                stringBuilder.append(", ");
            }
            stringBuilder.delete(stringBuilder.length() - ", ".length(), stringBuilder.length());
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }
}

