/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.partition;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.Box;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.ideimpl.db.panels.ChildSelectableComponentEditorPanel;
import oracle.ideimpl.db.panels.partition.GlobalIndexPartitionListEditorPanel;
import oracle.ideimpl.db.panels.partition.HashPartitionComboBox;
import oracle.ideimpl.db.panels.partition.HashPartitionComboBoxListener;
import oracle.ideimpl.db.panels.partition.OraclePartitionsHandler;
import oracle.ideimpl.db.panels.partition.PartitionProperty;
import oracle.ideimpl.db.panels.partition.PartitionTreeEditorPanel;
import oracle.ideimpl.db.panels.partition.SubpartitionsListEditorPanel;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Index;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.OracleIndexPartitions;
import oracle.javatools.db.ora.OracleTablePartitions;

abstract class HashPartitionPanel<T extends DBObject>
extends BaseEditorPanel<T> {
    private final HashPartitionComboBox m_combo;
    private final ChildSelectableComponentEditorPanel m_panel;
    private final HashPartitionComboBoxListener m_listener;
    private final Component m_glue = Box.createHorizontalGlue();

    HashPartitionPanel(ChildSelectableComponentEditorPanel childSelectableComponentEditorPanel) {
        super("HashPartitionPanel");
        DBUIResourceHelper dBUIResourceHelper = new DBUIResourceHelper(this.getName());
        this.m_combo = new HashPartitionComboBox(dBUIResourceHelper, "HashPartitionType", this.isSubpartition());
        this.m_panel = childSelectableComponentEditorPanel;
        this.m_listener = new HashPartitionComboBoxListenerImpl();
    }

    @Override
    protected void initialisePanel() {
        this.m_combo.getComboBox().removeActionListener(this.m_listener);
        this.m_combo.getComboBox().setSelectedItem((Object)this.getHashType());
        this.m_combo.getComboBox().addActionListener(this.m_listener);
        this.showAndHideControls();
        this.m_panel.onEntry((TraversableContext)this.getDataContext());
    }

    @Override
    protected void commitPanel() throws TraversalException {
        super.commitPanel();
        HashPartitionComboBox.Item item = this.m_combo.getSelectedItem();
        if (item == HashPartitionComboBox.Item.Individual) {
            this.m_panel.onEntry((TraversableContext)this.getDataContext());
        }
    }

    @Override
    protected void initialiseComponents() {
        DBUILayoutHelper dBUILayoutHelper = this.getDBUILayoutHelper();
        dBUILayoutHelper.add(this.m_combo.getLabel(), 1, 1, false, false);
        dBUILayoutHelper.add(this.m_combo.getComboBox(), 1, 1, true, false);
        dBUILayoutHelper.nextRow();
        ComponentWrapper componentWrapper = this.getOrCreateWrapper(this.getHashQuantityProperty());
        dBUILayoutHelper.add(componentWrapper.getLabel(), 1, 1, false, false);
        dBUILayoutHelper.add(componentWrapper.getComponent(), 1, 1, true, false);
        dBUILayoutHelper.nextRow();
        ComponentWrapper componentWrapper2 = this.getOrCreateWrapper(this.getHashTablespacesProperty());
        dBUILayoutHelper.add(componentWrapper2.getLabel(), 1, 1, false, false);
        dBUILayoutHelper.add(componentWrapper2.getComponent(), 1, 1, true, true);
        dBUILayoutHelper.nextRow();
        dBUILayoutHelper.add((Component)((Object)this.m_panel), 2, 1, true, true);
        dBUILayoutHelper.add(this.m_glue, 2, 1, true, true);
        dBUILayoutHelper.layout();
    }

    protected OraclePartitionsHandler getPartitionsHandler() {
        return OraclePartitionsHandler.create(this.getUpdatedObject());
    }

    protected boolean isSubpartition() {
        return false;
    }

    protected abstract String getHashQuantityProperty();

    protected abstract String getHashTablespacesProperty();

    protected abstract HashPartitionComboBox.Item getHashType();

    private void showAndHideControls() {
        ComponentWrapper componentWrapper = this.getOrCreateWrapper(this.getHashQuantityProperty());
        ComponentWrapper componentWrapper2 = this.getOrCreateWrapper(this.getHashTablespacesProperty());
        switch (this.m_combo.getSelectedItem()) {
            case Default: {
                componentWrapper.setVisible(false);
                componentWrapper2.setVisible(false);
                this.m_glue.setVisible(true);
                this.m_panel.setVisible(false);
                break;
            }
            case Individual: {
                componentWrapper.setVisible(false);
                componentWrapper2.setVisible(false);
                this.m_glue.setVisible(false);
                this.m_panel.setVisible(true);
                this.m_panel.onEntry((TraversableContext)this.getDataContext());
                break;
            }
            case Quantity: {
                componentWrapper.setVisible(true);
                componentWrapper2.setVisible(true);
                this.m_glue.setVisible(false);
                this.m_panel.setVisible(false);
            }
        }
    }

    private final class HashPartitionComboBoxListenerImpl
    extends HashPartitionComboBoxListener {
        private HashPartitionComboBoxListenerImpl() {
        }

        @Override
        final OraclePartitionsHandler getPartitionsHandler() {
            return HashPartitionPanel.this.getPartitionsHandler();
        }

        @Override
        final void actionPerformedImpl(ActionEvent actionEvent) {
            HashPartitionPanel.this.showAndHideControls();
        }
    }

    static class IndexPartition
    extends HashPartitionPanel<Index> {
        IndexPartition() {
            super(new GlobalIndexPartitionListEditorPanel());
        }

        @Override
        protected String getHashQuantityProperty() {
            return PartitionProperty.INDEX_HASH_QUANTITY;
        }

        @Override
        protected String getHashTablespacesProperty() {
            return PartitionProperty.INDEX_HASH_TABLESPACES;
        }

        @Override
        protected HashPartitionComboBox.Item getHashType() {
            HashPartitionComboBox.Item item = HashPartitionComboBox.Item.Default;
            OracleIndexPartitions oracleIndexPartitions = (OracleIndexPartitions)((Index)this.getUpdatedObject()).getProperty("OracleIndexPartitions");
            if (oracleIndexPartitions != null && oracleIndexPartitions.getGlobalHashQuantity() != null) {
                item = HashPartitionComboBox.Item.Quantity;
            } else if (oracleIndexPartitions != null && oracleIndexPartitions.getPartitions() != null && oracleIndexPartitions.getPartitions().length > 0) {
                item = HashPartitionComboBox.Item.Individual;
            }
            return item;
        }
    }

    static class TableSubpartition
    extends HashPartitionPanel<Table> {
        TableSubpartition() {
            super(new SubpartitionsListEditorPanel());
        }

        @Override
        protected OraclePartitionsHandler getPartitionsHandler() {
            OracleTablePartitions oracleTablePartitions = (OracleTablePartitions)((Table)this.getUpdatedObject()).getProperty("OracleTablePartitions");
            OracleTablePartitions oracleTablePartitions2 = oracleTablePartitions.getSubpartitionModel();
            return OraclePartitionsHandler.create((DBObject)oracleTablePartitions2);
        }

        @Override
        protected boolean isSubpartition() {
            return true;
        }

        @Override
        protected String getHashQuantityProperty() {
            return PartitionProperty.SUBPARTITION_TEMPLATE_HASH_QUANTITY;
        }

        @Override
        protected String getHashTablespacesProperty() {
            return PartitionProperty.SUBPARTITION_TEMPLATE_HASH_TABLESPACES;
        }

        @Override
        protected HashPartitionComboBox.Item getHashType() {
            OracleTablePartitions oracleTablePartitions = (OracleTablePartitions)((Table)this.getUpdatedObject()).getProperty("OracleTablePartitions");
            HashPartitionComboBox.Item item = HashPartitionComboBox.Item.Default;
            if (oracleTablePartitions != null) {
                OracleTablePartitions oracleTablePartitions2 = oracleTablePartitions.getSubpartitionModel();
                if (oracleTablePartitions2 != null && oracleTablePartitions2.getHashQuantity() != null) {
                    item = HashPartitionComboBox.Item.Quantity;
                } else if (oracleTablePartitions2 != null && oracleTablePartitions2.getPartitions() != null && oracleTablePartitions2.getPartitions().length > 0) {
                    item = HashPartitionComboBox.Item.Individual;
                }
            }
            return item;
        }
    }

    static class TablePartition
    extends HashPartitionPanel<Table> {
        TablePartition() {
            super(new PartitionTreeEditorPanel());
        }

        @Override
        protected String getHashQuantityProperty() {
            return PartitionProperty.HASH_QUANTITY;
        }

        @Override
        protected String getHashTablespacesProperty() {
            return PartitionProperty.HASH_TABLESPACES;
        }

        @Override
        protected HashPartitionComboBox.Item getHashType() {
            OracleTablePartitions oracleTablePartitions = (OracleTablePartitions)((Table)this.getUpdatedObject()).getProperty("OracleTablePartitions");
            HashPartitionComboBox.Item item = HashPartitionComboBox.Item.Default;
            if (oracleTablePartitions != null && oracleTablePartitions.getHashQuantity() != null) {
                item = HashPartitionComboBox.Item.Quantity;
            } else if (oracleTablePartitions != null && oracleTablePartitions.getPartitions() != null && oracleTablePartitions.getPartitions().length > 0) {
                item = HashPartitionComboBox.Item.Individual;
            }
            return item;
        }
    }
}

