/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.partition;

import oracle.javatools.db.DBObject;
import oracle.javatools.db.Index;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.IndexPartition;
import oracle.javatools.db.ora.OracleIndexPartitions;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.TablePartition;

public enum ExtendedPartitionType {
    UNDEFINED(null, null),
    TABLE_RANGE(Location.TABLE, Definition.RANGE),
    TABLE_LIST(Location.TABLE, Definition.LIST),
    TABLE_HASH(Location.TABLE, Definition.HASH),
    TABLE_REFERENCE(Location.TABLE, Definition.REFERENCE),
    INDEX_GLOBAL_RANGE(Location.INDEX_GLOBAL, Definition.RANGE),
    INDEX_GLOBAL_HASH(Location.INDEX_GLOBAL, Definition.HASH),
    INDEX_LOCAL_HASH(Location.INDEX_LOCAL, Definition.HASH),
    INDEX_LOCAL_COMP(Location.INDEX_LOCAL, Definition.COMPOSITE),
    INDEX_LOCAL_OTHER(Location.INDEX_LOCAL, Definition.OTHER),
    INDEX_SUBPARTITION(Location.INDEX_LOCAL, Definition.SUBPARTITION);

    private final Location m_loc;
    private final Definition m_def;

    private ExtendedPartitionType(Location location, Definition definition) {
        this.m_loc = location;
        this.m_def = definition;
    }

    public boolean isRange() {
        return this.m_def == Definition.RANGE;
    }

    public boolean isList() {
        return this.m_def == Definition.LIST;
    }

    public boolean isHash() {
        return this.m_def == Definition.HASH;
    }

    public boolean isReference() {
        return this.m_def == Definition.REFERENCE;
    }

    public boolean isTable() {
        return this.m_loc == Location.TABLE;
    }

    public boolean isIndex() {
        return this.m_loc == Location.INDEX_GLOBAL || this.m_loc == Location.INDEX_LOCAL;
    }

    public boolean isLocalIndex() {
        return this.m_loc == Location.INDEX_LOCAL;
    }

    public static ExtendedPartitionType getType(DBObject dBObject) {
        if (dBObject instanceof IndexPartition) {
            dBObject = dBObject.getParent();
        }
        if (dBObject instanceof Table) {
            dBObject = (OracleTablePartitions)dBObject.getProperty("OracleTablePartitions");
        }
        if (dBObject instanceof Index) {
            dBObject = (OracleIndexPartitions)dBObject.getProperty("OracleIndexPartitions");
        }
        if (dBObject instanceof OracleTablePartitions || dBObject instanceof TablePartition) {
            OracleTablePartitions.PartitionType partitionType = (OracleTablePartitions.PartitionType)dBObject.getProperty("partitionType");
            if (partitionType == OracleTablePartitions.PartitionType.RANGE) {
                return TABLE_RANGE;
            }
            if (partitionType == OracleTablePartitions.PartitionType.LIST) {
                return TABLE_LIST;
            }
            if (partitionType == OracleTablePartitions.PartitionType.HASH) {
                return TABLE_HASH;
            }
            if (partitionType == OracleTablePartitions.PartitionType.REFERENCE) {
                return TABLE_REFERENCE;
            }
        } else if (dBObject instanceof OracleIndexPartitions) {
            OracleIndexPartitions oracleIndexPartitions = (OracleIndexPartitions)dBObject;
            OracleIndexPartitions.PartitionType partitionType = oracleIndexPartitions.getPartitionType();
            if (partitionType == OracleIndexPartitions.PartitionType.GLOBAL_RANGE) {
                return INDEX_GLOBAL_RANGE;
            }
            if (partitionType == OracleIndexPartitions.PartitionType.GLOBAL_HASH) {
                return INDEX_GLOBAL_HASH;
            }
            if (partitionType == OracleIndexPartitions.PartitionType.LOCAL_HASH) {
                return INDEX_LOCAL_HASH;
            }
            if (partitionType == OracleIndexPartitions.PartitionType.LOCAL_COMP) {
                return INDEX_LOCAL_COMP;
            }
            if (partitionType == OracleIndexPartitions.PartitionType.LOCAL_OTHER) {
                return INDEX_LOCAL_OTHER;
            }
            if (partitionType == OracleIndexPartitions.PartitionType.SUBPARTITION) {
                return INDEX_SUBPARTITION;
            }
        }
        return UNDEFINED;
    }

    private static enum Definition {
        RANGE,
        LIST,
        HASH,
        REFERENCE,
        COMPOSITE,
        SUBPARTITION,
        OTHER;

    }

    private static enum Location {
        TABLE,
        INDEX_GLOBAL,
        INDEX_LOCAL;

    }
}

