/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.partition;

import java.util.Enumeration;
import javax.swing.JCheckBox;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.ide.db.controls.SelectableComponent;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.db.util.TreeNodeMaker;
import oracle.ideimpl.db.panels.ChildSelectableComponentEditorPanel;
import oracle.ideimpl.db.panels.partition.PartitionRenderer;
import oracle.ideimpl.db.validate.DBValidationManager;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;

public abstract class AbstractPartitionTreeEditorPanel<C extends ChildDBObject, P extends DBObject>
extends ChildSelectableComponentEditorPanel<C, P> {
    private JTree m_tree;
    private JCheckBox m_chkDefinePartitions = new JCheckBox();

    public AbstractPartitionTreeEditorPanel(String string) {
        super(string);
    }

    public void setDefinePartitionsCheckbox(JCheckBox jCheckBox) {
        this.m_chkDefinePartitions = jCheckBox;
    }

    protected JCheckBox getDefinePartitionsCheckbox() {
        return this.m_chkDefinePartitions;
    }

    protected JTree getTree() {
        return this.m_tree;
    }

    @Override
    protected void initialisePanel() {
        super.initialisePanel();
        TreeNodeMaker.expandAll(this.m_tree);
    }

    @Override
    protected SelectableComponent createSelectableComponent() {
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(new DefaultMutableTreeNode(this.getUpdatedObject()));
        this.m_tree = new JTree(defaultTreeModel);
        this.m_tree.setRootVisible(false);
        this.m_tree.setCellRenderer(DBValidationManager.wrapTreeCellRenderer(this.createItemRenderer(), this.getDataContext()));
        this.m_tree.setShowsRootHandles(true);
        return SelectableComponent.createSelectableComponent(this.m_tree);
    }

    @Override
    protected void commitChildProperty() {
        this.commitChildPropertyImpl(true);
    }

    @Override
    protected C findChild(C c, C[] CArray) {
        ChildDBObject childDBObject;
        ChildDBObject childDBObject2 = (ChildDBObject)DBUtil.findParentOfType((DBObject)c.getParent(), c.getClass());
        if (childDBObject2 == null) {
            childDBObject = super.findChild(c, CArray);
        } else {
            DefaultMutableTreeNode defaultMutableTreeNode;
            ChildDBObject childDBObject3 = null;
            DefaultMutableTreeNode defaultMutableTreeNode2 = this.findChildNode(childDBObject2, (DefaultMutableTreeNode)this.getTreeModel().getRoot());
            if (defaultMutableTreeNode2 != null && (defaultMutableTreeNode = this.findChildNode(c, defaultMutableTreeNode2)) != null) {
                childDBObject3 = (ChildDBObject)defaultMutableTreeNode.getUserObject();
            }
            childDBObject = childDBObject3;
        }
        return (C)childDBObject;
    }

    private DefaultMutableTreeNode findChildNode(C c, DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        DefaultMutableTreeNode defaultMutableTreeNode3 = null;
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode4 = (DefaultMutableTreeNode)enumeration.nextElement();
            Object object = defaultMutableTreeNode4.getUserObject();
            if (object == c) {
                defaultMutableTreeNode2 = defaultMutableTreeNode4;
                break;
            }
            if (defaultMutableTreeNode3 != null || !(object instanceof DBObject) || !DBUtil.areNamesAndTypesEqual((DBObject)((DBObject)object), c)) continue;
            defaultMutableTreeNode3 = defaultMutableTreeNode4;
        }
        return defaultMutableTreeNode2 == null ? defaultMutableTreeNode3 : defaultMutableTreeNode2;
    }

    protected abstract void commitChildPropertyImpl(boolean var1);

    protected DBObjectRenderer createItemRenderer() {
        return new PartitionRenderer();
    }

    protected DefaultTreeModel getTreeModel() {
        return (DefaultTreeModel)this.m_tree.getModel();
    }

    protected int getLevel() {
        TreePath treePath;
        int n = 0;
        if (this.m_tree != null && (treePath = this.m_tree.getSelectionPath()) != null) {
            n = treePath.getPathCount() - 2;
        }
        return n;
    }
}

