/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.partition;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import oracle.ide.db.ProviderOperator;
import oracle.ide.db.dialogs.DBExceptionDialog;
import oracle.ide.db.event.SwingDBObjectPropertyListener;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.panels.ChildSelectableComponentEditorPanel;
import oracle.ideimpl.db.panels.partition.AbstractPartitionPanel;
import oracle.ideimpl.db.panels.partition.HashPartitionPanel;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.db.ora.LocalIndexPartitionHelper;
import oracle.javatools.db.ora.OracleTablePartitions;

public abstract class AbstractCascadingTablePartitionPanel
extends AbstractPartitionPanel {
    private boolean m_cascadeRequired = false;
    private OracleTablePartitions m_otp;

    public AbstractCascadingTablePartitionPanel(String string, ChildSelectableComponentEditorPanel childSelectableComponentEditorPanel, HashPartitionPanel hashPartitionPanel) {
        super(string, childSelectableComponentEditorPanel, hashPartitionPanel);
    }

    public abstract String[] getCascadeProperties();

    @Override
    protected void initialisePanel() {
        super.initialisePanel();
        if (this.getProvider() instanceof Database) {
            OracleTablePartitions oracleTablePartitions = (OracleTablePartitions)this.getUpdatedObject().getProperty("OracleTablePartitions");
            this.m_otp = (OracleTablePartitions)DBUtil.makeTemporaryCopy((DBObject)oracleTablePartitions);
            this.setCascadeIsRequired(false);
        }
    }

    @Override
    protected void commitPanel() throws TraversalException {
        super.commitPanel();
        if (this.m_cascadeRequired) {
            this.doCascade();
        }
    }

    @Override
    protected DBObjectListener createComponentFactoryObjectListener() {
        String[] stringArray;
        SwingDBObjectPropertyListener swingDBObjectPropertyListener = null;
        if (this.getProvider() instanceof Database && (stringArray = this.getCascadeProperties()) != null && stringArray.length > 0) {
            swingDBObjectPropertyListener = new SwingDBObjectPropertyListener(stringArray){

                @Override
                protected void updateUI(DBObject dBObject, String string, PropertyChangeEvent propertyChangeEvent) {
                    AbstractCascadingTablePartitionPanel.this.setCascadeIsRequired(true);
                }
            };
        }
        return swingDBObjectPropertyListener;
    }

    private void setCascadeIsRequired(boolean bl) {
        this.m_cascadeRequired = bl;
    }

    private void doCascade() {
        DBObjectProvider dBObjectProvider = this.getProvider();
        if (dBObjectProvider instanceof Database) {
            Table table = (Table)this.getUpdatedObject();
            OracleTablePartitions oracleTablePartitions = (OracleTablePartitions)this.getUpdatedObject().getProperty("OracleTablePartitions");
            try {
                LocalIndexPartitionHelper.cascadeTablePartitions((SystemObject)table, (OracleTablePartitions)this.m_otp, (OracleTablePartitions)oracleTablePartitions, (Database)((Database)dBObjectProvider));
            }
            catch (DBException dBException) {
                DBExceptionDialog.showErrorDialog((Component)((Object)this), ProviderOperator.getErrorTitle(this.getEditorConfig()), dBException);
            }
        }
    }
}

