/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels;

import java.math.BigInteger;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.javatools.db.AbstractIncrementer;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.TemporaryObjectID;

public class IncrementerPanel<T extends AbstractIncrementer>
extends BaseEditorPanel<AbstractIncrementer> {
    private final boolean m_useTwoColumns;

    protected IncrementerPanel() {
        this(null, false);
    }

    protected IncrementerPanel(String string, boolean bl) {
        this.m_useTwoColumns = bl;
        this.getComponentFactory().setBasePath(string);
    }

    @Override
    protected void initialiseComponents() {
        ComponentWrapper componentWrapper = this.getOrCreateWrapper("startWith");
        ComponentWrapper componentWrapper2 = this.getOrCreateWrapper("incrementBy");
        ComponentWrapper componentWrapper3 = this.getOrCreateWrapper("minValue");
        ComponentWrapper componentWrapper4 = this.getOrCreateWrapper("maxValue");
        ComponentWrapper componentWrapper5 = this.getOrCreateWrapper("cacheSize");
        ComponentWrapper componentWrapper6 = this.getOrCreateWrapper("cacheFlag");
        ComponentWrapper componentWrapper7 = this.getOrCreateWrapper("cycleFlag");
        ComponentWrapper componentWrapper8 = this.getOrCreateWrapper("orderFlag");
        componentWrapper6.addListener(propertyChangeEvent -> this.processCacheSize(propertyChangeEvent.getNewValue(), true));
        DBUILayoutHelper dBUILayoutHelper = this.getDBUILayoutHelper();
        dBUILayoutHelper.add(componentWrapper);
        if (!this.m_useTwoColumns) {
            dBUILayoutHelper.nextRow();
        }
        dBUILayoutHelper.add(componentWrapper2);
        dBUILayoutHelper.nextRow();
        dBUILayoutHelper.add(componentWrapper3);
        if (!this.m_useTwoColumns) {
            dBUILayoutHelper.nextRow();
        }
        dBUILayoutHelper.add(componentWrapper4);
        dBUILayoutHelper.nextRow();
        dBUILayoutHelper.add(componentWrapper6);
        if (!this.m_useTwoColumns) {
            dBUILayoutHelper.nextRow();
        }
        dBUILayoutHelper.add(componentWrapper5);
        if (!this.m_useTwoColumns) {
            dBUILayoutHelper.indent(componentWrapper5.getLabel());
        }
        dBUILayoutHelper.nextRow();
        dBUILayoutHelper.add(componentWrapper7);
        dBUILayoutHelper.nextRow();
        dBUILayoutHelper.add(componentWrapper8);
        this.completeLayout();
    }

    @Override
    protected void initialisePanel() {
        AbstractIncrementer abstractIncrementer = (AbstractIncrementer)this.getComponentFactoryUpdatedObject();
        if (abstractIncrementer != null) {
            this.processCacheSize(abstractIncrementer.getCacheFlag(), false);
        }
    }

    protected void completeLayout() {
        DBUILayoutHelper dBUILayoutHelper = this.getDBUILayoutHelper();
        dBUILayoutHelper.nextRow();
        dBUILayoutHelper.pushUp();
        dBUILayoutHelper.layout();
    }

    private void processCacheSize(Object object, boolean bl) {
        boolean bl2 = Boolean.TRUE.equals(object);
        ComponentWrapper componentWrapper = this.getOrCreateWrapper("cacheSize");
        componentWrapper.setEnabled(bl2);
        if (bl) {
            componentWrapper.resetPropertyValue(bl2 ? this.getCacheSizeDefault() : null);
        }
    }

    private BigInteger getCacheSizeDefault() {
        BigInteger bigInteger;
        AbstractIncrementer abstractIncrementer = (AbstractIncrementer)this.getComponentFactoryUpdatedObject();
        BigInteger bigInteger2 = abstractIncrementer.getMaxValue();
        BigInteger bigInteger3 = abstractIncrementer.getMinValue();
        BigInteger bigInteger4 = abstractIncrementer.getIncrementBy();
        if (bigInteger4 == null || bigInteger4.equals(BigInteger.ZERO)) {
            bigInteger4 = BigInteger.ONE;
        }
        if (bigInteger2 == null) {
            bigInteger2 = bigInteger4.signum() > 0 ? BigInteger.valueOf(10L).pow(27) : BigInteger.ONE.negate();
        }
        if (bigInteger3 == null) {
            bigInteger3 = bigInteger4.signum() > 0 ? BigInteger.ONE : BigInteger.valueOf(10L).pow(26).negate();
        }
        BigInteger[] bigIntegerArray = bigInteger2.subtract(bigInteger3).abs().divideAndRemainder(bigInteger4.abs());
        BigInteger bigInteger5 = bigIntegerArray[0];
        if (bigIntegerArray[1].signum() > 0) {
            bigInteger5 = bigInteger5.add(BigInteger.ONE);
        }
        if (bigInteger5.subtract(bigInteger = new BigInteger("20")).signum() > 0) {
            bigInteger5 = bigInteger;
        }
        return bigInteger5;
    }

    @Override
    protected DBObject getComponentFactoryUpdatedObject() {
        DBObject dBObject = (DBObject)this.getDataContext().find("NewChildObject");
        if (dBObject instanceof Column) {
            return ((Column)dBObject).getIdentityProperties();
        }
        return this.getUpdatedObject();
    }

    @Override
    protected DBObject getComponentFactoryOriginalObject() {
        return TemporaryObjectID.getOriginalObject((DBObject)this.getComponentFactoryUpdatedObject());
    }
}

