/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.swing.plaf.TabbedPaneUI;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.panels.DBTraversable;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.TabbedPanel;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.ideimpl.db.panels.DBNavigable;
import oracle.ideimpl.db.validate.DBValidationHandler;
import oracle.ideimpl.db.validate.DBValidationManager;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.validators.DBObjectValidationModel;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.ui.StatusIndicator;

public class DBTabbedPanel
extends TabbedPanel
implements DBTraversable {
    private StatusIndicator[] m_statusIndicators;
    private BaseEditorPanel m_baseEditorPanel;
    private DBValidationHandler m_validationHandler;
    private DBObject m_updatedObject;
    private boolean m_pendingStatusRefresh;

    public DBTabbedPanel(Navigable[] navigableArray) {
        super(navigableArray);
    }

    public DBTabbedPanel(Navigable[] navigableArray, TabbedPaneUI tabbedPaneUI) {
        super(navigableArray, tabbedPaneUI);
    }

    public void setBaseEditorPanel(BaseEditorPanel baseEditorPanel) {
        this.m_baseEditorPanel = baseEditorPanel;
    }

    public Navigable getCurrentNavigable() {
        return super.getCurrentNavigable();
    }

    public final Navigable[] getRootNavigables() {
        return super.getRootNavigables();
    }

    public int getSelectedIndex() {
        int n = -1;
        Navigable navigable = this.getCurrentNavigable();
        if (navigable != null) {
            Navigable[] navigableArray = this.getRootNavigables();
            for (int i = 0; i < navigableArray.length; ++i) {
                if (navigable != navigableArray[i]) continue;
                n = i;
                break;
            }
        }
        return n;
    }

    public void setRootNavigables(Navigable[] navigableArray) {
        super.setRootNavigables(navigableArray);
        this.m_statusIndicators = null;
        this.m_pendingStatusRefresh = true;
    }

    @Override
    public Component getDefaultFocusComponent() {
        Traversable traversable = this.getCurrentTraversable();
        return traversable instanceof DBTraversable ? ((DBTraversable)traversable).getDefaultFocusComponent() : null;
    }

    @Override
    public boolean requestFocusForEditorConfig() {
        Traversable traversable = this.getCurrentTraversable();
        return traversable instanceof DBTraversable ? ((DBTraversable)traversable).requestFocusForEditorConfig() : false;
    }

    public int findNavigableIndex(String string) {
        int n = -1;
        String string2 = string;
        block0: while (string2 != null) {
            Navigable[] navigableArray = this.getRootNavigables();
            for (int i = 0; i < navigableArray.length; ++i) {
                if (!(navigableArray[i] instanceof DBNavigable) || !((DBNavigable)navigableArray[i]).isPanelProperty(string2)) continue;
                n = i;
                break block0;
            }
            string2 = Property.getParentProperty((String)string2);
        }
        return n;
    }

    public void onEntry(TraversableContext traversableContext) {
        super.onEntry(traversableContext);
        this.m_pendingStatusRefresh = false;
        DBValidationHandler dBValidationHandler = this.getOrCreateValidationHandler(traversableContext);
        if (dBValidationHandler != null) {
            this.m_updatedObject = this.getValidationUpdatedObject(traversableContext);
            dBValidationHandler.startValidation(this.getValidationOriginalObject(traversableContext), this.m_updatedObject);
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        DBValidationHandler dBValidationHandler = this.m_validationHandler;
        if (dBValidationHandler != null) {
            dBValidationHandler.stopValidation();
        }
        super.onExit(traversableContext);
    }

    protected DBObject getValidationOriginalObject(TraversableContext traversableContext) {
        DBObject dBObject;
        if (this.m_baseEditorPanel == null) {
            DBEditorConfig dBEditorConfig = (DBEditorConfig)traversableContext.find(DBEditorConfig.class);
            dBObject = dBEditorConfig.getOriginalObject();
        } else {
            dBObject = this.m_baseEditorPanel.getComponentFactoryOriginalObject();
        }
        return dBObject;
    }

    protected DBObject getValidationUpdatedObject(TraversableContext traversableContext) {
        DBObject dBObject;
        if (this.m_baseEditorPanel == null) {
            DBEditorConfig dBEditorConfig = (DBEditorConfig)traversableContext.find(DBEditorConfig.class);
            dBObject = dBEditorConfig.getUpdatedObject();
        } else {
            dBObject = this.m_baseEditorPanel.getComponentFactoryUpdatedObject();
        }
        return dBObject;
    }

    private DBValidationHandler getOrCreateValidationHandler(TraversableContext traversableContext) {
        if (this.m_validationHandler == null) {
            DBEditorConfig dBEditorConfig = (DBEditorConfig)traversableContext.find(DBEditorConfig.class);
            DBValidationManager dBValidationManager = (DBValidationManager)traversableContext.find(DBValidationManager.class);
            if (dBEditorConfig != null && dBValidationManager != null) {
                this.m_validationHandler = dBValidationManager.createHandler(dBEditorConfig, null);
                if (this.m_validationHandler != null) {
                    this.m_validationHandler.addListener((dBObjectValidationModel, dBValidationHandler) -> this.updateStatusIndicators(dBObjectValidationModel));
                }
            }
        }
        return this.m_validationHandler;
    }

    private void updateStatusIndicators(DBObjectValidationModel dBObjectValidationModel) {
        if (this.getParent() != null && !this.m_pendingStatusRefresh) {
            Map map = dBObjectValidationModel.getValidationMap(this.m_updatedObject);
            Navigable[] navigableArray = this.getRootNavigables();
            if (this.m_statusIndicators == null) {
                this.m_statusIndicators = new StatusIndicator[navigableArray.length];
            }
            for (int i = 0; i < this.m_statusIndicators.length; ++i) {
                Collection<String> collection;
                if (this.m_statusIndicators[i] == null) {
                    this.m_statusIndicators[i] = new StatusIndicator();
                }
                ArrayList<ValidationException> arrayList = new ArrayList<ValidationException>();
                if (map != null && navigableArray[i] instanceof DBNavigable && (collection = ((DBNavigable)navigableArray[i]).getProperties()) != null) {
                    for (String string : collection) {
                        for (Map.Entry entry : map.entrySet()) {
                            String string2 = (String)entry.getKey();
                            if (string2 == null || !string2.equals(string) && !Property.startsWith((String)string2, (String[])new String[]{string})) continue;
                            arrayList.addAll((Collection)entry.getValue());
                        }
                    }
                }
                this.configureIndicator(this.m_statusIndicators[i], arrayList);
                this.setStatusIndicator(this.m_statusIndicators[i], i);
            }
        }
    }

    private void configureIndicator(StatusIndicator statusIndicator, Collection<ValidationException> collection) {
        if (collection.isEmpty()) {
            statusIndicator.setStatus(StatusIndicator.Status.OK);
            statusIndicator.setInfoTipContent(null);
        } else {
            statusIndicator.setStatus(StatusIndicator.Status.ERROR);
            statusIndicator.setInfoTipContent(DBValidationManager.createInfoTipContent(collection));
        }
    }
}

