/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels;

import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.DBObject;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.ui.table.ReorderableTableWithTitleBar;
import oracle.javatools.ui.table.TableToolbar;

public abstract class BaseEditorTabTable<C extends ChildDBObject, P extends DBObject>
extends ChildObjectEditorPanel<C, P> {
    private final GenericTable m_table = new GenericTable();
    private final TabTableModel m_tableModel = new TabTableModel(this.getColumnNames(), this.getColumnTypes());

    public BaseEditorTabTable(String string, String string2) {
        super(string, string2);
        this.m_table.setName(string + ".Table");
        this.m_table.setModel((TableModel)this.m_tableModel);
        this.m_table.setRolloverHighlightingEnabled(false);
        this.layoutTable();
    }

    private void layoutTable() {
        DBUILayoutHelper dBUILayoutHelper = new DBUILayoutHelper((JPanel)((Object)this), true);
        JScrollPane jScrollPane = new JScrollPane((Component)this.m_table);
        jScrollPane.setPreferredSize(new Dimension(400, 100));
        ReorderableTableWithTitleBar reorderableTableWithTitleBar = new ReorderableTableWithTitleBar((JTable)this.m_table, (JComponent)jScrollPane, false, true);
        this.configureToolBar(reorderableTableWithTitleBar.getTableToolbar());
        dBUILayoutHelper.add((Component)reorderableTableWithTitleBar, 1, 1, true, true);
        dBUILayoutHelper.layout();
    }

    public P getParentObject() {
        return (P)this.getUpdatedObject();
    }

    protected void setDefaultRenderer(TableCellRenderer tableCellRenderer, Class clazz) {
        this.m_table.setDefaultRenderer(clazz, tableCellRenderer);
    }

    protected void clearRows() {
        this.m_tableModel.clearRows();
    }

    @Override
    protected void initialisePanel() {
        Object c = this.getChildObject();
        this.setChildContext(c);
    }

    protected void addRow(int n, Object ... objectArray) {
        this.m_tableModel.addRow(n, objectArray);
    }

    public abstract void setChildContext(C var1);

    protected abstract void configureToolBar(TableToolbar var1);

    protected abstract String[] getColumnNames();

    protected abstract Class[] getColumnTypes();

    private class TabTableModel
    extends DefaultTableModel {
        private ArrayList<ArrayList<Object>> m_rowData = new ArrayList();
        private Class[] m_columnTypes;
        private String[] m_columnNames;

        public TabTableModel(String[] stringArray, Class[] classArray) {
            this.m_columnNames = stringArray;
            this.m_columnTypes = classArray;
        }

        @Override
        public int getColumnCount() {
            return this.m_columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.m_rowData != null ? this.m_rowData.size() : 0;
        }

        @Override
        public String getColumnName(int n) {
            return this.m_columnNames[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.m_columnTypes[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            ArrayList<Object> arrayList;
            Object object = null;
            if (n < this.m_rowData.size() && n2 < (arrayList = this.m_rowData.get(n)).size()) {
                object = arrayList.get(n2);
            }
            return object;
        }

        public void clearRows() {
            this.m_rowData.clear();
        }

        public void addRow(int n, Object ... objectArray) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (Object object : objectArray) {
                arrayList.add(object);
            }
            this.m_rowData.add(n, arrayList);
        }
    }
}

