/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.hive.components;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellEditor;
import oracle.ideimpl.db.components.ExtendedTableComponentWrapper;
import oracle.ideimpl.db.controls.ExtendedTable;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.hive.HivePartition;
import oracle.javatools.db.property.DisplayNames;
import oracle.javatools.db.property.Property;
import oracle.javatools.ui.table.GenericTable;

public class HivePartitionsComponentWrapper
extends ExtendedTableComponentWrapper<HivePartitionsTable> {
    public HivePartitionsComponentWrapper(String string) {
        super(new HivePartitionsTable(string));
    }

    @Override
    public Object getPropertyValue() {
        return ((HivePartitionsTable)this.getExtendedTable()).getPartitions();
    }

    @Override
    public void setPropertyValue(Object object) {
        String string;
        String string2 = Property.getLastProperty((String)this.getPropertyName());
        String string3 = Property.getParentProperty((String)this.getComponentContext().getFullPropertyPath());
        DBObject dBObject = (DBObject)this.getUpdatedObject().getProperty(string3);
        if ("skewedValues".equals(string2)) {
            string = "skewedColumns";
        } else if ("partitions".equals(string2)) {
            string = "partitionColumns";
        } else {
            throw new IllegalArgumentException(string2);
        }
        ((HivePartitionsTable)this.getExtendedTable()).setPartitions(dBObject, string, object instanceof HivePartition[] ? (HivePartition[])object : null);
    }

    public static class HivePartitionsTable
    extends ExtendedTable {
        private final List<HivePartition> m_partitions = new ArrayList<HivePartition>();
        private DBObject m_parent;
        private boolean m_loading;

        HivePartitionsTable(String string) {
            super(DisplayNames.getPropertyDisplayName((String)string), "HivePartitionsTable");
            this.addTableModelListener(new ExtendedTable.ExtendedTableModelListener(){

                @Override
                public void cellValueEdited(TableModelEvent tableModelEvent) {
                    this.sync(tableModelEvent);
                }

                @Override
                public void tableChanged(TableModelEvent tableModelEvent) {
                }
            });
            this.setSelectionModel(new DefaultListSelectionModel(){

                @Override
                public void setValueIsAdjusting(boolean bl) {
                    if (!m_loading) {
                        super.setValueIsAdjusting(bl);
                    }
                }
            });
        }

        private void sync(TableModelEvent tableModelEvent) {
            TableCellEditor tableCellEditor;
            int n = tableModelEvent.getColumn();
            if (!this.m_loading && 0 == tableModelEvent.getType() && n != -1 && (tableCellEditor = this.getTable().getCellEditor()) != null) {
                int n2 = this.getModel().getColumnCount();
                int n3 = tableModelEvent.getFirstRow();
                String string = (String)tableCellEditor.getCellEditorValue();
                HivePartition hivePartition = this.m_partitions.get(n3);
                String[] stringArray = hivePartition.getValues();
                String[] stringArray2 = new String[n2];
                System.arraycopy(stringArray, 0, stringArray2, 0, Math.min(stringArray.length, n2));
                stringArray2[n] = string;
                hivePartition.setValues(stringArray2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setPartitions(DBObject dBObject, String string, HivePartition[] hivePartitionArray) {
            GenericTable genericTable = this.getTable();
            ListSelectionModel listSelectionModel = genericTable.getSelectionModel();
            listSelectionModel.setValueIsAdjusting(true);
            this.m_loading = true;
            try {
                DBObjectID[] dBObjectIDArray;
                this.m_partitions.clear();
                if (hivePartitionArray != null) {
                    this.m_partitions.addAll(Arrays.asList(hivePartitionArray));
                }
                this.m_parent = dBObject;
                Vector<String> vector = new Vector<String>();
                int n = 0;
                if (this.m_parent != null && (dBObjectIDArray = (DBObjectID[])this.m_parent.getProperty(string)) != null) {
                    for (HivePartition hivePartition : dBObjectIDArray) {
                        vector.add(DBUtil.getDBObjectName((DBObjectID)hivePartition));
                        ++n;
                    }
                }
                dBObjectIDArray = new Vector();
                if (hivePartitionArray != null) {
                    for (HivePartition hivePartition : hivePartitionArray) {
                        Vector<String> vector2 = new Vector<String>(n);
                        String[] stringArray = hivePartition.getValues();
                        for (int i = 0; i < n; ++i) {
                            vector2.add(stringArray != null && i < stringArray.length ? stringArray[i] : null);
                        }
                        dBObjectIDArray.add(vector2);
                    }
                }
                int n2 = dBObjectIDArray.size();
                int n3 = genericTable.getSelectedRowInModel();
                if (n3 >= n2) {
                    n3 = 0;
                }
                this.setModel(new PartitionTableModel((Vector<Vector>)dBObjectIDArray, vector));
                if (n3 >= 0 && n2 > 0) {
                    genericTable.setSelectedRowInModel(n3);
                }
            }
            finally {
                this.m_loading = false;
                listSelectionModel.setValueIsAdjusting(false);
            }
        }

        HivePartition[] getPartitions() {
            this.stopCellEditing();
            return this.m_partitions.toArray(new HivePartition[this.m_partitions.size()]);
        }

        @Override
        protected void addNewRow() {
            ExtendedTable.StringTableModel stringTableModel = this.getModel();
            int n = stringTableModel.getColumnCount();
            HivePartition hivePartition = new HivePartition();
            hivePartition.setParent(this.m_parent);
            hivePartition.setValues(new String[n]);
            this.m_partitions.add(hivePartition);
            Vector<Object> vector = new Vector<Object>(n);
            for (int i = 0; i < n; ++i) {
                vector.add(null);
            }
            stringTableModel.addRow(vector);
        }

        public int indexOf(HivePartition hivePartition) {
            int n = -1;
            for (int i = 0; i < this.m_partitions.size(); ++i) {
                if (this.m_partitions.get(i) != hivePartition) continue;
                n = i;
                break;
            }
            return n;
        }

        public HivePartition getPartition(int n) {
            return n < this.m_partitions.size() && n >= 0 ? this.m_partitions.get(n) : null;
        }

        private class PartitionTableModel
        extends ExtendedTable.StringTableModel {
            PartitionTableModel(Vector<Vector> vector, Vector<String> vector2) {
                super(vector, vector2);
            }

            public void removeRow(int n) {
                HivePartitionsTable.this.m_partitions.remove(n);
                super.removeRow(n);
            }
        }
    }
}

