/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import oracle.ide.Context;
import oracle.ide.db.dialogs.BaseDBEditorFactory;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.panels.DBTraversable;
import oracle.ide.db.panels.PanelLibrary;
import oracle.ide.db.panels.TabbedEditorPanel;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;

public class DBObjectOverviewEditorPanel<T extends DBObject>
implements DBTraversable {
    private final JPanel m_panel = new JPanel();
    private final PanelLibrary<T> m_panelLib;
    private final Namespace m_namespace;
    private final TabbedEditorPanel m_tabbedPane;

    public DBObjectOverviewEditorPanel(PanelLibrary<T> panelLibrary, Namespace namespace) {
        this.m_panelLib = panelLibrary;
        this.m_namespace = namespace;
        DBEditorConfig dBEditorConfig = (DBEditorConfig)this.m_namespace.find(DBEditorConfig.class);
        if (dBEditorConfig == null) {
            throw new IllegalStateException("DBEditorConfig cannot be null");
        }
        List<Navigable> list = this.m_panelLib.getNavigables(dBEditorConfig);
        Navigable[] navigableArray = list.toArray(new Navigable[list.size()]);
        String string = this.getStartPage(dBEditorConfig);
        if (string == null && this.newlyCreated() && navigableArray.length > 1 && this.m_panelLib.getSkipGeneralForNewObject()) {
            string = navigableArray[1].getShortLabel();
        }
        this.m_tabbedPane = new TabbedEditorPanel(null, navigableArray, string);
        this.m_tabbedPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 0));
        this.m_panel.removeAll();
        this.m_panel.setLayout(new BorderLayout());
        this.m_panel.add(this.m_tabbedPane.getComponent(), "Center");
    }

    void resetCurrentPage() {
        DBEditorConfig dBEditorConfig;
        String string;
        if (this.m_tabbedPane != null && (string = this.getStartPage(dBEditorConfig = (DBEditorConfig)this.m_namespace.find(DBEditorConfig.class))) != null) {
            this.m_tabbedPane.setStartPage(string);
        }
    }

    private String getStartPage(DBEditorConfig dBEditorConfig) {
        return this.m_panelLib.getStartPage(dBEditorConfig);
    }

    Navigable getCurrentNavigable() {
        return this.m_tabbedPane.getCurrentNavigable();
    }

    public void onEntry(TraversableContext traversableContext) {
        PanelLibrary.PanelSetChanger panelSetChanger = (PanelLibrary.PanelSetChanger)traversableContext.find(PanelLibrary.PanelSetChanger.class);
        if (panelSetChanger != null) {
            List<Navigable> list = this.m_panelLib.getNavigables((DBEditorConfig)this.m_namespace.find(DBEditorConfig.class));
            Navigable[] navigableArray = list.toArray(new Navigable[list.size()]);
            try {
                panelSetChanger.panelSetChange(navigableArray, null);
            }
            catch (TraversalException traversalException) {
                DBLog.getLogger((Object)this).warning(traversalException.getMessage());
            }
        }
        this.m_tabbedPane.onEntry(traversableContext);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        this.m_tabbedPane.onExit(traversableContext);
    }

    public Component getComponent() {
        return this.m_panel;
    }

    @Override
    public Object getExitTransition() {
        return null;
    }

    public String getHelpID() {
        return this.m_tabbedPane.getHelpID();
    }

    private boolean newlyCreated() {
        Context context = (Context)this.m_namespace.find(Context.class);
        return context != null && BaseDBEditorFactory.isCreateContext(context);
    }

    @Override
    public Component getDefaultFocusComponent() {
        return this.m_tabbedPane.getDefaultFocusComponent();
    }

    @Override
    public boolean requestFocusForEditorConfig() {
        return this.m_tabbedPane.requestFocusForEditorConfig();
    }
}

