/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.editors;

import java.net.URL;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.dialogs.DBEditorFactoryRegistry;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.navigation.DefaultNavigationPoint;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.TemporaryObjectID;

public final class DBObjectNavigationPoint
extends DefaultNavigationPoint {
    private DBObject m_childObject;
    private String m_property;

    protected int navigateImpl() throws Exception {
        return super.navigateImpl();
    }

    protected int renavigate() throws Exception {
        int n = 1;
        if (this.m_childObject == null && this.viewID != null) {
            n = super.renavigate();
        } else if (this.nodeURL != null) {
            DBEditorFactory dBEditorFactory;
            Node node;
            Context context = this.getContext();
            Workspace workspace = context.getWorkspace();
            if (workspace != null) {
                Ide.setActiveWorkspace((Workspace)workspace);
                Ide.setActiveProject((Project)context.getProject());
            }
            if ((node = NodeFactory.find((URL)this.nodeURL)) instanceof DBObjectNode && (dBEditorFactory = DBEditorFactoryRegistry.getEditFactory((DBObjectNode)node)) != null) {
                DBEditorConfig dBEditorConfig = DBEditorConfig.newEditConfig((DBObjectNode)node);
                dBEditorConfig.setChildObject(this.m_childObject);
                dBEditorConfig.setProperty(this.m_property);
                dBEditorFactory.launchDialog(dBEditorConfig);
                n = 0;
            }
        }
        return n;
    }

    public void setContext(Context context) {
        super.setContext(context);
        DBObject dBObject = null;
        String string = null;
        DBEditorConfig dBEditorConfig = DBEditorConfig.getConfig(context);
        if (dBEditorConfig != null) {
            string = dBEditorConfig.getProperty();
            DBObject dBObject2 = dBEditorConfig.getChildObject();
            if (dBObject2 != null) {
                DBObject dBObject3 = TemporaryObjectID.findOriginalObject((DBObject)dBObject2);
                dBObject = dBObject3 == null ? dBObject2 : dBObject3;
            }
        }
        this.m_childObject = dBObject;
        this.m_property = string;
    }

    public Object copyTo(Object object) {
        DBObjectNavigationPoint dBObjectNavigationPoint = object == null ? new DBObjectNavigationPoint() : (DBObjectNavigationPoint)((Object)object);
        super.copyToImpl((DefaultNavigationPoint)dBObjectNavigationPoint);
        dBObjectNavigationPoint.m_childObject = this.m_childObject;
        dBObjectNavigationPoint.m_property = this.m_property;
        return dBObjectNavigationPoint;
    }

    public String getShortLabel() {
        return this.m_childObject == null ? super.getShortLabel() : DBUtil.getFullyQualifiedName((DBObject)this.m_childObject, (boolean)false);
    }

    public Icon getIcon() {
        return this.m_childObject == null ? super.getIcon() : DBTypeDisplayRegistry.getNodeIcon(this.m_childObject);
    }
}

