/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.dialogs;

import java.awt.Component;
import java.awt.Window;
import java.util.logging.Level;
import oracle.ide.Ide;
import oracle.ide.db.dialogs.DBExceptionDialog;
import oracle.ide.util.IdeUtil;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.dialogs.MessageDialog;

public class DBMessageDialog {
    public static boolean useDialog() {
        return Ide.isRunning() && !IdeUtil.isHeadless() && Ide.getMainWindow() != null;
    }

    public static void showErrorDialog(String string, Object object, Level level) {
        DBMessageDialog.showErrorDialog(string, object, level, null, null);
    }

    public static void showErrorDialog(String string, Object object, Level level, String string2, String string3) {
        if (DBMessageDialog.useDialog()) {
            MessageDialog.error((Component)DBMessageDialog.getDialogParent(), (Object)string, (String)string2, (String)string3);
        } else if (level != null) {
            DBLog.getLogger((Object)object).log(level, string);
        }
    }

    public static void showErrorDialog(Exception exception, Object object, Level level) {
        DBMessageDialog.showErrorDialog(exception, object, level, null, null, null);
    }

    public static void showErrorDialog(Exception exception, Object object, Level level, String string, String string2, String string3) {
        if (DBMessageDialog.useDialog()) {
            if (exception instanceof DBException) {
                DBExceptionDialog.showErrorDialog(DBMessageDialog.getDialogParent(), string2, string, (DBException)((Object)exception), string3);
            } else {
                Throwable throwable = exception.getCause();
                if (throwable instanceof DBException) {
                    DBExceptionDialog.showErrorDialog(DBMessageDialog.getDialogParent(), string2, string, (DBException)throwable, string3);
                } else {
                    Object object2 = exception.getMessage();
                    if (string != null) {
                        object2 = string + " : " + (String)object2;
                    }
                    if (object2 == null) {
                        object2 = (String)object2;
                    }
                    DBMessageDialog.showErrorDialog((String)object2, object, level, string2, string3);
                }
            }
        } else if (level != null) {
            DBLog.getLogger((Object)object).log(level, string, exception);
        }
    }

    public static Component getDialogParent() {
        Window window = null;
        if (DBMessageDialog.useDialog() && (window = IdeUtil.findActiveModalWindow()) == null) {
            window = Ide.getMainWindow();
        }
        return window;
    }
}

