/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.controls;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import oracle.ideimpl.db.controls.ExtendedTable;

public class KeyValueTable
extends ExtendedTable {
    private NameCellEditor m_nameEditor;

    protected KeyValueTable(String string, String string2) {
        super(string, string2);
    }

    public final void setKeys(Collection<String> collection) {
        if (this.m_nameEditor == null) {
            this.m_nameEditor = new NameCellEditor();
        }
        JComboBox jComboBox = this.m_nameEditor.getCombo();
        jComboBox.removeAllItems();
        if (collection != null) {
            for (String string : collection) {
                jComboBox.addItem(string);
            }
        }
        this.ensureNameCellEditor();
    }

    @Override
    protected void modelReplaced() {
        this.ensureNameCellEditor();
    }

    private void ensureNameCellEditor() {
        ExtendedTable.StringTableModel stringTableModel = this.getModel();
        if (stringTableModel != null && this.m_nameEditor != null) {
            this.getTable().getColumnModel().getColumn(0).setCellEditor(this.m_nameEditor);
        }
    }

    protected String getDefaultValue(String string) {
        return null;
    }

    protected void keyChanged(String string, int n) {
    }

    public static KeyValueTable getKeyValueTable(JComponent jComponent) {
        return (KeyValueTable)ExtendedTable.getExtendedTable(jComponent);
    }

    private class NameCellEditor
    extends DefaultCellEditor {
        private boolean m_active;

        NameCellEditor() {
            super(new JComboBox());
            final JComboBox jComboBox = this.getCombo();
            jComboBox.setEditable(true);
            jComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    int n;
                    if (NameCellEditor.this.m_active && (n = KeyValueTable.this.getTable().getSelectedRow()) >= 0) {
                        KeyValueTable.this.keyChanged((String)jComboBox.getSelectedItem(), n);
                    }
                }
            });
            KeyValueTable.this.getResourceHelper().setName(jComboBox, "NameCombo");
        }

        JComboBox getCombo() {
            return (JComboBox)this.getComponent();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            Component component = super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            this.m_active = true;
            return component;
        }

        @Override
        public void cancelCellEditing() {
            super.cancelCellEditing();
            this.m_active = false;
        }

        @Override
        public boolean stopCellEditing() {
            boolean bl = super.stopCellEditing();
            if (bl) {
                String string;
                Object object;
                ExtendedTable.StringTableModel stringTableModel;
                Object object2;
                this.m_active = false;
                int n = KeyValueTable.this.getTable().getSelectedRowInModel();
                if (n >= 0 && (object2 = (stringTableModel = KeyValueTable.this.getModel()).getValueAt(n, 1)) == null && (object = stringTableModel.getValueAt(n, 0)) instanceof String && (string = KeyValueTable.this.getDefaultValue((String)object)) != null) {
                    stringTableModel.setValueAt(string, n, 1);
                }
            }
            return bl;
        }
    }
}

