/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.controls;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import oracle.ide.db.PropertyDisplayRegistry;
import oracle.ideimpl.db.controls.ExtendedTable;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.ora.bigdata.BigDataField;
import oracle.javatools.db.ora.bigdata.BigDataFields;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.util.ModelUtil;

public class BigDataFieldsTable
extends ExtendedTable {
    public BigDataFieldsTable() {
        super(PropertyDisplayRegistry.getDisplayName("bigDataFields"), "BigDataFieldsTable");
    }

    @Override
    protected boolean isReorderable() {
        return true;
    }

    public void setFields(BigDataFields bigDataFields) {
        this.getComponent().getReorderableBar().setBackground(this.getTable().getBackground());
        Vector<Vector> vector = new Vector<Vector>();
        if (bigDataFields != null) {
            for (BigDataField bigDataField : bigDataFields.getBigDataFields()) {
                Vector<String> vector2 = new Vector<String>();
                vector2.add(bigDataField.getName());
                vector2.add(bigDataField.getFieldDataType());
                vector2.add((String)bigDataField.getProperty("Comment"));
                vector.add(vector2);
            }
        }
        this.setModel(new ExtendedTable.StringTableModel(this, vector, this.getPropertyColumnNames("name", "fieldDataType", "Comment")));
    }

    public BigDataFields getFields() {
        this.stopCellEditing();
        BigDataFields bigDataFields = new BigDataFields();
        for (Object e : this.getModel().getDataVector()) {
            String string = (String)((Vector)e).get(0);
            String string2 = (String)((Vector)e).get(1);
            String string3 = (String)((Vector)e).get(2);
            BigDataField bigDataField = new BigDataField();
            bigDataField.setName(string);
            if (ModelUtil.hasLength((String)string2)) {
                bigDataField.setFieldDataType(string2);
            }
            if (ModelUtil.hasLength((String)string3)) {
                bigDataField.setProperty("Comment", (Object)string3);
            }
            bigDataFields.addBigDataField(bigDataField);
        }
        return bigDataFields;
    }

    @Override
    protected void addNewRow() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object e : this.getModel().getDataVector()) {
            arrayList.add((String)((Vector)e).get(0));
        }
        String string = DBUtil.getUniqueName(arrayList, (String)"field1");
        this.getModel().addRow(new Object[]{string, null, null});
    }

    @Override
    protected void modelReplaced() {
        this.getTable().getColumnModel().getColumn(1).setCellEditor(new DataTypeCellEditor());
    }

    private class DataTypeCellEditor
    extends ExtendedTable.EditableComboCellEditor {
        DataTypeCellEditor() {
            super((ExtendedTable)BigDataFieldsTable.this, "fieldDataType", "array<>", "bigint", "binary", "boolean", "decimal", "double", "float", "int", "map<,>", "smallint", "string", "struct<>", "timestamp", "tinyint", "uniontype<>");
            this.getCombo().addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    String string;
                    boolean bl = DataTypeCellEditor.this.getCombo().isPopupVisible();
                    if (itemEvent.getStateChange() == 1 && bl && (string = (String)itemEvent.getItem()).indexOf(60) >= 0) {
                        DataTypeCellEditor.this.editCellAndInsertCaretInsideAngles();
                    }
                }
            });
        }

        private void editCellAndInsertCaretInsideAngles() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GenericTable genericTable = BigDataFieldsTable.this.getTable();
                    if (genericTable.isVisible()) {
                        genericTable.editCellAt(genericTable.getSelectedRow(), genericTable.getSelectedColumn());
                        DataTypeCellEditor.this.insertCaretInsideAngles();
                    }
                }
            });
        }

        private void insertCaretInsideAngles() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int n;
                    final JTextComponent jTextComponent = DataTypeCellEditor.this.getEditorComponent();
                    if (jTextComponent.isVisible() && (n = jTextComponent.getText().indexOf(60) + 1) > 0) {
                        jTextComponent.requestFocusInWindow();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                jTextComponent.select(n, n);
                                jTextComponent.setCaretPosition(n);
                            }
                        });
                    }
                }
            });
        }
    }
}

