/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.components;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ideimpl.db.components.SubTypeComponentWrapper;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Relation;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;

public class TableTypeComponentWrapper
extends SubTypeComponentWrapper {
    private final Map<String, String> m_typeMappings = new HashMap<String, String>();

    @Override
    protected Map<String, Object> getInvalidProperties(SystemObject systemObject) {
        Map<String, Object> map = super.getInvalidProperties(systemObject);
        if (systemObject instanceof Table && !map.containsKey("constraints")) {
            Collection<String> collection = this.getInvalidConstraintTypes((Table)systemObject);
            for (String string : collection) {
                String string2 = this.m_typeMappings.get(string);
                if (string2 == null) {
                    string2 = DBTypeDisplayRegistry.getDisplayName(string);
                    this.m_typeMappings.put(string2, string);
                }
                map.put(string2, string);
            }
        }
        return map;
    }

    @Override
    protected boolean shouldEnsurePanels() {
        return true;
    }

    private Collection<String> getInvalidConstraintTypes(Table table) {
        Collection collection = this.getProvider().getPropertyManager().getAllowedPropertyValues(null, (DBObject)table, "constraintType");
        HashSet<String> hashSet = new HashSet<String>();
        for (Constraint constraint : table.getConstraints()) {
            if (collection.contains(constraint.getConstraintType())) continue;
            hashSet.add(constraint.getConstraintType());
        }
        return hashSet;
    }

    @Override
    protected void clearInvalidProperty(SystemObject systemObject, String string, Object object) {
        if (systemObject instanceof Table && this.m_typeMappings.containsKey(string)) {
            if (object instanceof String) {
                for (Constraint constraint : Constraint.getConstraints((Relation)((Table)systemObject), (String[])new String[]{(String)object})) {
                    ((Table)systemObject).removeConstraint(constraint);
                }
            }
        } else {
            super.clearInvalidProperty(systemObject, string, object);
        }
    }

    @Override
    protected boolean shouldCacheInvalidProperty(String string) {
        return string.equals("OracleExternalTableProperties") || string.equals("OracleStorageProperties") || string.equals("OracleIndexOrganizedTableProperties");
    }

    @Override
    protected boolean shouldRecurseToChildProperties(String string) {
        return string.equals("OracleStorageProperties") || string.equals("OracleTablePartitions");
    }
}

