/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.components;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.model.Node;
import oracle.ide.util.Namespace;

public abstract class AsynchronousComponentWrapper<T extends Component>
extends ComponentWrapper<T> {
    private static final String CANCEL_CLIENT_PROP = "AsynchronousComponentWrapper.cancellingComponent";
    private boolean m_dirty;
    private boolean m_suppressWrite;

    public AsynchronousComponentWrapper(T t) {
        super(t);
    }

    public final boolean writeUpdates() {
        return this.writeUpdatesImpl(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeUpdatesImpl(boolean bl) {
        boolean bl2 = true;
        this.prepareForWrite();
        if (this.m_dirty) {
            boolean bl3;
            boolean bl4;
            bl2 = false;
            boolean bl5 = !bl;
            boolean bl6 = bl4 = bl || this.getComponentContext().isInFlatEditor();
            if (this.m_suppressWrite) {
                if (bl4) {
                    bl5 = false;
                    bl3 = true;
                } else {
                    bl3 = false;
                }
            } else {
                bl3 = true;
            }
            if (bl3) {
                try {
                    this.fireVetoableChangeEvent();
                    bl2 = true;
                    this.m_suppressWrite = false;
                }
                catch (PropertyVetoException propertyVetoException) {
                    Object object;
                    this.m_suppressWrite = true;
                    if (bl5 && (object = propertyVetoException.getMessage()) != null) {
                        this.showError((String)object);
                    }
                    if (bl4) {
                        object = propertyVetoException.getPropertyChangeEvent();
                        if (object != null) {
                            this.setPropertyValue(((PropertyChangeEvent)object).getOldValue());
                        }
                        this.cancelUpdates();
                    }
                }
                finally {
                    if (this.m_suppressWrite) {
                        SwingUtilities.invokeLater(() -> {
                            this.m_suppressWrite = false;
                        });
                    }
                }
            }
            if (bl2) {
                this.m_dirty = false;
            }
            this.writeFinished(bl2);
        }
        return bl2;
    }

    protected void prepareForWrite() {
    }

    protected void writeFinished(boolean bl) {
    }

    protected void cancelUpdates() {
        if (this.m_dirty) {
            this.m_dirty = false;
            this.m_suppressWrite = false;
        }
    }

    @Override
    public Component getDefaultFocusComponent() {
        return this.getFocusComponents()[0];
    }

    public Component[] getFocusComponents() {
        return new Component[]{this.getActiveComponent()};
    }

    @Override
    protected void initialiseComponentListener() {
        Component[] componentArray = this.getFocusComponents();
        if (componentArray != null) {
            for (Component component : componentArray) {
                component.addFocusListener(new FocusListener(){

                    @Override
                    public void focusGained(FocusEvent focusEvent) {
                        AsynchronousComponentWrapper.this.gainingFocus();
                    }

                    @Override
                    public void focusLost(FocusEvent focusEvent) {
                        AsynchronousComponentWrapper.this.losingFocus();
                        if (!AsynchronousComponentWrapper.this.m_suppressWrite) {
                            boolean bl = AsynchronousComponentWrapper.isCancellingComponent(focusEvent.getOppositeComponent(), focusEvent.getComponent());
                            AsynchronousComponentWrapper.this.writeUpdatesImpl(bl);
                        }
                    }
                });
            }
        }
    }

    protected final void markDirty() {
        Object object;
        this.m_dirty = true;
        this.m_suppressWrite = false;
        Namespace namespace = this.getComponentContext().getDataContext();
        while ((object = namespace.getParent()) != null && object != namespace) {
            namespace = object;
        }
        object = (AsynchronousComponentWrapper)namespace.find(AsynchronousComponentWrapper.class);
        if (object != this) {
            if (object != null) {
                ((AsynchronousComponentWrapper)object).writeUpdatesImpl(true);
            }
            namespace.put(AsynchronousComponentWrapper.class.getName(), (Object)this);
        }
        if (this.getComponentContext().isInFlatEditor()) {
            Node node;
            Context context = (Context)namespace.find(Context.class);
            Node node2 = node = context == null ? null : context.getNode();
            if (node != null) {
                node.markDirty(true);
            }
        }
    }

    protected void gainingFocus() {
    }

    protected void losingFocus() {
    }

    protected boolean isDirty() {
        return this.m_dirty;
    }

    public static boolean commitCurrentWrapper(Namespace namespace, boolean bl, boolean bl2) {
        boolean bl3 = true;
        AsynchronousComponentWrapper asynchronousComponentWrapper = (AsynchronousComponentWrapper)namespace.find(AsynchronousComponentWrapper.class);
        if (asynchronousComponentWrapper != null && (bl3 = asynchronousComponentWrapper.writeUpdatesImpl(bl)) && bl2) {
            namespace.remove(AsynchronousComponentWrapper.class.getName());
        }
        return bl3;
    }

    public static void cancelCurrentWrapper(Namespace namespace) {
        AsynchronousComponentWrapper asynchronousComponentWrapper = (AsynchronousComponentWrapper)namespace.find(AsynchronousComponentWrapper.class);
        if (asynchronousComponentWrapper != null) {
            asynchronousComponentWrapper.cancelUpdates();
        }
    }

    public static void registerCancellingComponent(JComponent jComponent, Component component) {
        jComponent.putClientProperty(CANCEL_CLIENT_PROP, component);
    }

    private static boolean isCancellingComponent(Component component, Component component2) {
        Object object;
        boolean bl = false;
        if (component instanceof JComponent && (object = ((JComponent)component).getClientProperty(CANCEL_CLIENT_PROP)) instanceof Component) {
            for (Component component3 = component2; component3 != null; component3 = component3.getParent()) {
                if (object != component3) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }
}

