/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import oracle.bali.ewt.dateEditor.DateEditor;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.bali.ewt.spinBox.SpinBox;
import oracle.ide.controls.FlatEditorTransparentPanel;
import oracle.ide.controls.JComboCardPanel;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.db.controls.AbstractSizeChooser;
import oracle.ide.db.controls.DBObjectChooser;
import oracle.ide.panels.TabbedPanel;
import oracle.ideimpl.db.controls.IntegerWithComboPanel;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.ideimpl.db.panels.mviewlog.MViewLogHeader;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ResizeComponent;
import oracle.javatools.ui.RichHintLabel;
import oracle.javatools.ui.TitledSeparator;
import oracle.javatools.ui.plaf.IconicButtonUI;
import oracle.javatools.ui.table.ReorderableTableWithTitleBar;

public final class DBUILayoutHelper {
    public static final String SHUTTLE = "oracle.ideimpl.db.DBUILayoutHelper.SHUTTLE";
    private static final String MERGED_CONTAINERS_KEY = "oracle.ideimpl.db.DBUILayoutHelper.MERGED_CONTAINERS";
    private static final String MERGED_PARENT_KEY = "oracle.ideimpl.db.DBUILayoutHelper.MERGED_PARENT";
    private DBUILayoutHelper m_parent;
    private final List<DBUILayoutHelper> m_children = new ArrayList<DBUILayoutHelper>();
    private final JPanel m_panel;
    private boolean m_layoutDone;
    private boolean m_reuseLayout;
    private final Map<Component, GridBagConstraints> m_componentMap = new LinkedHashMap<Component, GridBagConstraints>();
    private final List<List<Component>> m_grid = new ArrayList<List<Component>>();
    private List<Component> m_lastRow;
    private final List<Component> m_extras = new ArrayList<Component>();
    private TitledSeparator m_titledSeparator = null;
    private final boolean m_isInFlatEditor;
    private final int CELL_SPACING = 2;
    private int m_x = 0;
    private int m_y = -2;
    private int m_maxx = 0;
    private int m_verticalGap = 0;
    private int m_marginTop = 6;
    private int m_marginLeft = 0;
    private int m_marginBottom = 6;
    private int m_marginRight = 0;
    private static final List<Class<? extends Component>> s_fillHorizontalClz = new ArrayList<Class<? extends Component>>();
    private static final List<Class<? extends Component>> s_fillVerticalClz;
    private static final List<Class<? extends Component>> s_allKnownClz;

    private DBUILayoutHelper(JPanel jPanel, DBUILayoutHelper dBUILayoutHelper, boolean bl) {
        this.m_panel = jPanel;
        if ("oracle.ideimpl.db.components.panels".equals(jPanel.getClass().getPackage().getName())) {
            this.m_marginTop = 0;
        }
        this.m_parent = dBUILayoutHelper;
        this.m_isInFlatEditor = bl;
        this.setOpaque(this.m_panel);
        if (dBUILayoutHelper != null) {
            dBUILayoutHelper.m_children.add(this);
        }
    }

    public DBUILayoutHelper(JPanel jPanel) {
        this(jPanel, null, false);
    }

    public DBUILayoutHelper(JPanel jPanel, boolean bl) {
        this(jPanel, null, bl);
    }

    public DBUILayoutHelper newChildHelper(int n, int n2, boolean bl, boolean bl2) {
        JPanel jPanel = new JPanel();
        DBUILayoutHelper dBUILayoutHelper = this.newChildHelperImpl(jPanel, jPanel, n, n2, bl, bl2);
        dBUILayoutHelper.setMargins(0);
        return dBUILayoutHelper;
    }

    public DBUILayoutHelper newChildHelper(String string, int n, int n2, boolean bl, boolean bl2) {
        JPanel jPanel = new JPanel();
        jPanel.setName(string);
        DBUILayoutHelper dBUILayoutHelper = this.newChildHelperImpl(jPanel, jPanel, n, n2, bl, bl2);
        dBUILayoutHelper.setMargins(0);
        return dBUILayoutHelper;
    }

    @Deprecated
    public DBUILayoutHelper newTitledBorderHelper(String string, int n, int n2, boolean bl, boolean bl2) {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(string));
        return this.newChildHelperImpl(jPanel, jPanel, n, n2, bl, bl2);
    }

    @Deprecated
    public DBUILayoutHelper newCheckboxBorderHelper(JCheckBox jCheckBox, int n, int n2, boolean bl, boolean bl2) {
        JComboCardPanel jComboCardPanel = new JComboCardPanel(new JLabel(), (JComponent)jCheckBox);
        JPanel jPanel = new JPanel();
        jComboCardPanel.showSubPanel((JComponent)jPanel);
        return this.newChildHelperImpl((JPanel)jComboCardPanel, jPanel, n, n2, bl, bl2);
    }

    public DBUILayoutHelper newTitledHelper(String string, int n, int n2, boolean bl, boolean bl2) {
        JLabel jLabel = new JLabel(string);
        return this.newTitledHelper(jLabel, n, n2, bl, bl2);
    }

    public DBUILayoutHelper newTitledHelper(ComponentWrapper componentWrapper, int n, int n2, boolean bl, boolean bl2) {
        ((Component)componentWrapper.getActiveComponent()).setForeground(UIManager.getColor("TitledBorder.titleColor"));
        return this.newTitledHelper((JComponent)componentWrapper.getComponent(), n, n2, bl, bl2);
    }

    public DBUILayoutHelper newTitledHelper(JComponent jComponent, int n, int n2, boolean bl, boolean bl2) {
        TitledSeparator titledSeparator = new TitledSeparator(jComponent, TitledSeparator.STYLE.LINE);
        this.add((Component)titledSeparator, n, 1, bl, false);
        this.nextRow();
        JPanel jPanel = new JPanel();
        DBUILayoutHelper dBUILayoutHelper = this.newChildHelperImpl(jPanel, jPanel, n, n2, bl, bl2);
        dBUILayoutHelper.setTitleSeparator(titledSeparator);
        return dBUILayoutHelper;
    }

    private DBUILayoutHelper newChildHelperImpl(JPanel jPanel, JPanel jPanel2, int n, int n2, boolean bl, boolean bl2) {
        this.add(jPanel, n, n2, bl, bl2);
        DBUILayoutHelper dBUILayoutHelper = new DBUILayoutHelper(jPanel2, this, this.isInFlatEditor());
        dBUILayoutHelper.setMarginTop(6);
        dBUILayoutHelper.setMarginLeft(10);
        dBUILayoutHelper.setMarginRight(6);
        dBUILayoutHelper.setMarginBottom(10);
        return dBUILayoutHelper;
    }

    public JPanel getPanel() {
        return this.m_panel;
    }

    public void add(Component component) {
        this.add(component, 1, 1);
    }

    public void add(Component component, int n, int n2) {
        boolean bl = false;
        boolean bl2 = false;
        if (component != null) {
            boolean bl3 = false;
            for (Class<? extends Component> clazz : s_allKnownClz) {
                if (!clazz.isAssignableFrom(component.getClass())) continue;
                bl3 = true;
                break;
            }
            if (!bl3) {
                throw new IllegalArgumentException("Don't know how to fill component of class " + component.getClass().getCanonicalName());
            }
            for (Class<? extends Component> clazz : s_fillHorizontalClz) {
                if (!clazz.isAssignableFrom(component.getClass())) continue;
                bl = true;
                break;
            }
            for (Class<? extends Component> clazz : s_fillVerticalClz) {
                if (!clazz.isAssignableFrom(component.getClass())) continue;
                bl2 = true;
                break;
            }
        }
        this.add(component, n, n2, bl, bl2);
    }

    public void add(Component component, int n, int n2, boolean bl, boolean bl2) {
        Object object;
        if (component == null) {
            throw new IllegalArgumentException("Component is null");
        }
        if (this.m_y < 0) {
            this.nextRowImpl(this.m_marginTop);
        }
        int n3 = 0;
        if (bl && bl2) {
            n3 = 1;
        } else if (bl) {
            n3 = 2;
        } else if (bl2) {
            n3 = 3;
        }
        int n4 = this.m_verticalGap;
        int n5 = 16;
        if (this.m_y == 0) {
            n4 = this.m_marginTop;
        }
        if (this.m_x == 0) {
            n5 = this.m_marginLeft;
        } else if (this.m_lastRow != null && this.m_lastRow.size() > 0) {
            object = this.m_lastRow.get(this.m_lastRow.size() - 1);
            if (object instanceof JLabel) {
                if (this.isLabelFor((JLabel)object, component)) {
                    n5 = 8;
                    if (bl2) {
                        this.getConstraints((Component)object).anchor = 18;
                    }
                }
            } else if (object instanceof JRadioButton && component instanceof JRadioButton) {
                n5 = 16;
            } else if (object instanceof JCheckBox && component instanceof JCheckBox) {
                n5 = 16;
            } else if (object instanceof AbstractButton && component instanceof AbstractButton) {
                n5 = 8;
            }
        }
        if (component instanceof JComponent && (object = ((JComponent)component).getClientProperty(SHUTTLE)) instanceof Boolean && ((Boolean)object).booleanValue()) {
            n4 -= 6;
        }
        object = new GridBagConstraints(this.m_x, this.m_y, 1 + (n - 1) * 2, 1 + (n2 - 1) * 2, bl ? 1.0 : 0.0, bl2 ? 1.0 : 0.0, 17, n3, new Insets(n4, n5, 0, 0), 0, 0);
        this.m_componentMap.put(component, (GridBagConstraints)object);
        this.m_lastRow.add(component);
        this.m_x += n * 2;
        if (this.m_x > this.m_maxx) {
            this.m_maxx = this.m_x;
        }
    }

    private boolean isLabelFor(JLabel jLabel, Component component) {
        boolean bl = false;
        if (jLabel.getLabelFor() == component) {
            bl = true;
        } else if (component instanceof Container) {
            for (Component component2 : ((Container)component).getComponents()) {
                if (!this.isLabelFor(jLabel, component2)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public void add(ComponentWrapper componentWrapper) {
        JLabel jLabel = componentWrapper.getLabel();
        if (jLabel != null) {
            this.add(componentWrapper.getLabel());
            this.add(componentWrapper.getComponent());
        } else {
            this.add(componentWrapper.getComponent(), 2, 1);
        }
    }

    public void addChildren(Component component, Integer ... integerArray) {
        this.addChildrenImpl(component, integerArray);
    }

    public void addChildren(ComponentWrapper componentWrapper, Integer ... integerArray) {
        this.addChildrenImpl(componentWrapper.getComponent(), integerArray);
    }

    private void addChildrenImpl(Component component, Integer ... integerArray) {
        Container container;
        LayoutManager layoutManager;
        Integer[] integerArray2 = integerArray == null ? new Integer[]{} : integerArray;
        if (component instanceof Container && (layoutManager = (container = (Container)component).getLayout()) instanceof GridBagLayout) {
            this.addMergedContainer(container);
            GridBagLayout gridBagLayout = (GridBagLayout)layoutManager;
            int n = -999;
            int n2 = 0;
            for (Component component2 : container.getComponents()) {
                if (component2 instanceof Box.Filler) continue;
                GridBagConstraints gridBagConstraints = gridBagLayout.getConstraints(component2);
                if (n != gridBagConstraints.gridy) {
                    if (this.m_lastRow != null && this.m_lastRow.size() > 0) {
                        this.nextRow();
                        n2 = 0;
                    }
                    n = gridBagConstraints.gridy;
                }
                int n3 = n2 < integerArray2.length ? 1 + (integerArray2[n2] - 1) * 2 : gridBagConstraints.gridwidth;
                boolean bl = gridBagConstraints.fill == 1 || gridBagConstraints.fill == 2;
                boolean bl2 = gridBagConstraints.fill == 1 || gridBagConstraints.fill == 3;
                this.add(component2, n3, gridBagConstraints.gridheight, bl, bl2);
                if (gridBagConstraints.gridx != 0) {
                    this.getConstraints((Component)component2).insets.left = gridBagConstraints.insets.left;
                }
                ++n2;
            }
        }
    }

    private void addMergedContainer(Container container) {
        ArrayList<Container> arrayList = (ArrayList<Container>)this.m_panel.getClientProperty(MERGED_CONTAINERS_KEY);
        if (arrayList == null) {
            arrayList = new ArrayList<Container>();
            this.m_panel.putClientProperty(MERGED_CONTAINERS_KEY, arrayList);
        }
        arrayList.add(container);
        if (container instanceof JComponent) {
            ((JComponent)container).putClientProperty(MERGED_PARENT_KEY, this.m_panel);
        }
    }

    public void nextRow() {
        this.nextRowImpl(6);
    }

    public void nextRowWithGap() {
        this.nextRowImpl(16);
    }

    private void nextRowImpl(int n) {
        this.m_x = 0;
        this.m_y += 2;
        this.m_lastRow = new ArrayList<Component>();
        this.m_grid.add(this.m_lastRow);
        this.m_verticalGap = n;
    }

    public void nextColumn() {
        this.m_x += 2;
        if (this.m_x > this.m_maxx) {
            this.m_maxx = this.m_x;
        }
    }

    public void pushUp() {
        this.nextRowImpl(0);
        this.add(Box.createVerticalGlue(), 1, 1, false, true);
    }

    public void pushLeft() {
        this.m_x = this.m_maxx;
        this.add(Box.createHorizontalGlue(), 1, 1, true, false);
    }

    public void indent(Component component) {
        GridBagConstraints gridBagConstraints = this.getConstraints(component);
        gridBagConstraints.insets.left += 16;
    }

    public GridBagConstraints getConstraints(Component component) {
        if (component == null) {
            throw new IllegalArgumentException("Component is null");
        }
        GridBagConstraints gridBagConstraints = this.m_componentMap.get(component);
        if (gridBagConstraints == null) {
            throw new IllegalStateException("Component has not been added");
        }
        return gridBagConstraints;
    }

    public void setMinWidth(Component component, int n) {
        GridBagConstraints gridBagConstraints = this.getConstraints(component);
        if (gridBagConstraints != null) {
            Component component2 = Box.createHorizontalStrut(n);
            GridBagConstraints gridBagConstraints2 = (GridBagConstraints)gridBagConstraints.clone();
            ++gridBagConstraints2.gridy;
            gridBagConstraints2.insets.top = 0;
            gridBagConstraints2.insets.bottom = 0;
            this.m_componentMap.put(component2, gridBagConstraints2);
            this.m_extras.add(component2);
        }
    }

    public void setMinHeight(Component component, int n) {
        GridBagConstraints gridBagConstraints = this.getConstraints(component);
        if (gridBagConstraints != null) {
            Component component2 = Box.createVerticalStrut(n);
            GridBagConstraints gridBagConstraints2 = (GridBagConstraints)gridBagConstraints.clone();
            ++gridBagConstraints2.gridx;
            gridBagConstraints2.insets.left = 0;
            gridBagConstraints2.insets.right = 0;
            this.m_componentMap.put(component2, gridBagConstraints2);
            this.m_extras.add(component2);
        }
    }

    public void layout() {
        if (this.m_parent != null) {
            return;
        }
        for (DBUILayoutHelper object2 : this.m_children) {
            object2.m_parent = null;
            object2.layout();
        }
        this.m_children.clear();
        if (!this.m_layoutDone && this.m_panel != null && this.m_grid != null) {
            if (!this.m_reuseLayout) {
                this.m_panel.setLayout(new GridBagLayout());
            }
            if (this.m_marginRight > 0) {
                Component component = Box.createHorizontalStrut(this.m_marginRight);
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = this.m_maxx + 1;
                gridBagConstraints.gridy = 1;
                this.m_componentMap.put(component, gridBagConstraints);
                this.m_extras.add(component);
            }
            if (this.m_lastRow != null && this.m_lastRow.size() > 0) {
                for (int i = 0; i < this.m_lastRow.size(); ++i) {
                    GridBagConstraints gridBagConstraints = this.getConstraints(this.m_lastRow.get(i));
                    if (gridBagConstraints == null) continue;
                    gridBagConstraints.insets.bottom = this.m_marginBottom;
                }
            }
            for (List<Component> list : this.m_grid) {
                for (Component component : list) {
                    this.m_panel.add(this.getComponent(component), this.getConstraints(component));
                    this.showDebug(component);
                }
            }
            for (Component component : this.m_extras) {
                this.m_panel.add(this.getComponent(component), this.getConstraints(component));
                this.showDebug(component);
            }
            this.showDebug(this.m_panel);
        }
        this.m_componentMap.clear();
        this.m_extras.clear();
        this.m_grid.clear();
        this.m_lastRow.clear();
        this.m_layoutDone = true;
    }

    private void showDebug(Component component) {
        if (component instanceof JComponent && DBUILayoutHelper.isDebug()) {
            final JComponent jComponent = (JComponent)component;
            if (component != this.m_panel) {
                GridBagConstraints gridBagConstraints = this.getConstraints(jComponent);
                StringBuffer stringBuffer = new StringBuffer("Debug");
                stringBuffer.append(": class=").append(jComponent.getClass());
                stringBuffer.append(": name=").append(jComponent.getName());
                stringBuffer.append(": gridx=").append(gridBagConstraints.gridx);
                stringBuffer.append(": gridy=").append(gridBagConstraints.gridy);
                stringBuffer.append(": gridwidth=").append(gridBagConstraints.gridwidth);
                stringBuffer.append(": gridheight=").append(gridBagConstraints.gridheight);
                stringBuffer.append(": fill=").append(gridBagConstraints.fill);
                stringBuffer.append(": anchor=").append(gridBagConstraints.anchor);
                stringBuffer.append(": insets.top=").append(gridBagConstraints.insets.top);
                stringBuffer.append(": insets.left=").append(gridBagConstraints.insets.left);
                stringBuffer.append(": insets.bottom=").append(gridBagConstraints.insets.bottom);
                stringBuffer.append(": insets.right=").append(gridBagConstraints.insets.right);
                jComponent.setToolTipText(stringBuffer.toString());
                jComponent.addMouseListener(new MouseListener(){
                    private Border m_border = null;
                    private Color m_color;
                    private boolean m_opaque;

                    @Override
                    public void mouseEntered(MouseEvent mouseEvent) {
                        this.m_border = jComponent.getBorder();
                        this.m_color = jComponent.getBackground();
                        this.m_opaque = jComponent.isOpaque();
                        jComponent.setBorder(new LineBorder(Color.RED));
                        jComponent.setBackground(Color.cyan);
                    }

                    @Override
                    public void mouseExited(MouseEvent mouseEvent) {
                        jComponent.setBorder(this.m_border);
                        jComponent.setBackground(this.m_color);
                        jComponent.setOpaque(this.m_opaque);
                    }

                    @Override
                    public void mouseClicked(MouseEvent mouseEvent) {
                    }

                    @Override
                    public void mousePressed(MouseEvent mouseEvent) {
                    }

                    @Override
                    public void mouseReleased(MouseEvent mouseEvent) {
                    }
                });
            }
        }
    }

    private static boolean isDebug() {
        return Boolean.getBoolean("ide.db.debugLayout");
    }

    public void setMarginTop(int n) {
        this.m_marginTop = n;
    }

    public int getMarginTop() {
        return this.m_marginTop;
    }

    public void setMarginLeft(int n) {
        this.m_marginLeft = n;
    }

    public int getMarginLeft() {
        return this.m_marginLeft;
    }

    public void setMarginBottom(int n) {
        this.m_marginBottom = n;
    }

    public int getMarginBottom() {
        return this.m_marginBottom;
    }

    public void setMarginRight(int n) {
        this.m_marginRight = n;
    }

    public int getMarginRight() {
        return this.m_marginRight;
    }

    public void setMargins(int n) {
        this.m_marginTop = n;
        this.m_marginLeft = n;
        this.m_marginBottom = n;
        this.m_marginRight = n;
    }

    public void setReuseExistingLayout(int n) {
        LayoutManager layoutManager = this.m_panel.getLayout();
        if (layoutManager instanceof GridBagLayout) {
            for (Component component : this.m_panel.getComponents()) {
                GridBagConstraints gridBagConstraints = ((GridBagLayout)layoutManager).getConstraints(component);
                if (gridBagConstraints == null || gridBagConstraints.gridy < n) continue;
                this.m_panel.remove(component);
            }
        } else {
            throw new IllegalStateException("panel must have an existing grid bag");
        }
        this.m_reuseLayout = true;
        this.m_y = n;
        this.nextRow();
    }

    private Component getComponent(Component component) {
        this.setOpaque(component);
        return component;
    }

    private void setOpaque(Component component) {
        if (component instanceof JComponent && this.isInFlatEditor()) {
            if (component instanceof JButton && ((JButton)component).getUI() instanceof IconicButtonUI) {
                ((JButton)component).setOpaque(false);
            } else {
                DBUILayoutHelper.makeTransparentForFlatEditor((JComponent)component);
            }
        }
    }

    private boolean isInFlatEditor() {
        return this.m_isInFlatEditor;
    }

    public TitledSeparator getTitleSeparator() {
        return this.m_titledSeparator;
    }

    private void setTitleSeparator(TitledSeparator titledSeparator) {
        this.m_titledSeparator = titledSeparator;
    }

    public Component wrapForInvisibility(Component component) {
        JPanel jPanel = new JPanel();
        DBUILayoutHelper dBUILayoutHelper = new DBUILayoutHelper(jPanel, this.isInFlatEditor());
        dBUILayoutHelper.add(component, 1, 1, true, true);
        dBUILayoutHelper.layout();
        return jPanel;
    }

    public static JScrollPane createFlatScrollPane(Component component) {
        if (component instanceof JComponent) {
            ((JComponent)component).setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        }
        JScrollPane jScrollPane = new JScrollPane(component);
        jScrollPane.setBorder(null);
        jScrollPane.setBackground(UIManager.getColor("window"));
        jScrollPane.getViewport().setBackground(UIManager.getColor("window"));
        jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
        jScrollPane.getHorizontalScrollBar().setUnitIncrement(20);
        return jScrollPane;
    }

    public static Collection<Container> getMergedContainers(JPanel jPanel) {
        return (Collection)jPanel.getClientProperty(MERGED_CONTAINERS_KEY);
    }

    public static JPanel getMergedParent(JComponent jComponent) {
        JPanel jPanel;
        JPanel jPanel2 = (JPanel)jComponent.getClientProperty(MERGED_PARENT_KEY);
        if (jPanel2 != null && (jPanel = DBUILayoutHelper.getMergedParent(jPanel2)) != null) {
            jPanel2 = jPanel;
        }
        return jPanel2;
    }

    public static void makeTransparentForFlatEditor(JComponent jComponent) {
        FlatEditorTransparentPanel.makeTransparent((JComponent)jComponent);
    }

    static {
        s_fillHorizontalClz.add(JList.class);
        s_fillHorizontalClz.add(JTextField.class);
        s_fillHorizontalClz.add(JTextArea.class);
        s_fillHorizontalClz.add(JMultiLineLabel.class);
        s_fillHorizontalClz.add(JComboBox.class);
        s_fillHorizontalClz.add(JSplitPane.class);
        s_fillHorizontalClz.add(DateEditor.class);
        s_fillHorizontalClz.add(DBObjectChooser.class);
        s_fillHorizontalClz.add(AbstractSizeChooser.class);
        s_fillHorizontalClz.add(JScrollPane.class);
        s_fillHorizontalClz.add(ResizeComponent.class);
        s_fillHorizontalClz.add(Shuttle.class);
        s_fillHorizontalClz.add(ComponentWithTitlebar.class);
        s_fillHorizontalClz.add(ReorderableTableWithTitleBar.class);
        s_fillHorizontalClz.add(JWrappedLabel.class);
        s_fillHorizontalClz.add(RichHintLabel.class);
        s_fillHorizontalClz.add(TitledSeparator.class);
        s_fillHorizontalClz.add(JTabbedPane.class);
        s_fillHorizontalClz.add(TabbedPanel.class);
        s_fillHorizontalClz.add(ChildObjectEditorPanel.class);
        s_fillHorizontalClz.add(MViewLogHeader.class);
        s_fillHorizontalClz.add(IntegerWithComboPanel.class);
        s_fillVerticalClz = new ArrayList<Class<? extends Component>>();
        s_fillVerticalClz.add(JList.class);
        s_fillVerticalClz.add(JTextArea.class);
        s_fillVerticalClz.add(JSplitPane.class);
        s_fillVerticalClz.add(ResizeComponent.class);
        s_fillVerticalClz.add(JScrollPane.class);
        s_fillVerticalClz.add(ComponentWithTitlebar.class);
        s_fillVerticalClz.add(ReorderableTableWithTitleBar.class);
        s_fillVerticalClz.add(JWrappedLabel.class);
        s_fillVerticalClz.add(JTabbedPane.class);
        s_fillVerticalClz.add(TabbedPanel.class);
        s_fillVerticalClz.add(ChildObjectEditorPanel.class);
        s_fillVerticalClz.add(MViewLogHeader.class);
        s_allKnownClz = new ArrayList<Class<? extends Component>>();
        s_allKnownClz.add(JLabel.class);
        s_allKnownClz.add(JPanel.class);
        s_allKnownClz.add(AbstractButton.class);
        s_allKnownClz.add(JWrappedLabel.class);
        s_allKnownClz.add(SpinBox.class);
        s_allKnownClz.addAll(s_fillHorizontalClz);
    }
}

