/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.util;

import java.awt.Component;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.dialogs.DBExceptionDialog;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.util.IdeUtil;
import oracle.ideimpl.db.dialogs.DBUIProgressBar;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.execute.StatementWrapper;
import oracle.javatools.db.property.DerivedPropertyBuilder;
import oracle.javatools.util.Holder;
import oracle.javatools.util.MultiMap;

public class SchemaObjectBuilder {
    private boolean m_cancellable;
    private DBObjectProvider m_pro;
    private MultiMap<String, String> m_props;

    public SchemaObjectBuilder(boolean bl) {
        this.m_cancellable = bl;
    }

    public void buildDerivedProperties(DBObjectProvider dBObjectProvider) {
        this.m_pro = dBObjectProvider;
    }

    public void setProperties(String string, String ... stringArray) {
        if (this.m_props == null) {
            this.m_props = new MultiMap();
        }
        this.m_props.remove((Object)string);
        if (stringArray != null) {
            for (String string2 : stringArray) {
                if (string2 == null) continue;
                this.m_props.add((Object)string, (Object)string2);
            }
        }
    }

    private String[] getPropertiesToBuild(String string) {
        String[] stringArray = null;
        if (this.m_props != null) {
            Collection collection;
            TreeSet treeSet = new TreeSet();
            Collection collection2 = this.m_props.get(null);
            if (collection2 != null) {
                treeSet.addAll(collection2);
            }
            if ((collection = this.m_props.get((Object)string)) != null) {
                treeSet.addAll(collection);
            }
            if (treeSet.size() > 0) {
                stringArray = treeSet.toArray(new String[treeSet.size()]);
            }
        }
        return stringArray;
    }

    public boolean ensureObjectBuilt(DBObject ... dBObjectArray) {
        try {
            return this.ensureObjectBuiltEx(dBObjectArray);
        }
        catch (CancelledException cancelledException) {
        }
        catch (DBException dBException) {
            DBObject dBObject = dBException.getObject();
            String string = dBObject == null ? UIBundle.get("EXEC_BUILD_ERR_TITLE2") : UIBundle.format("EXEC_BUILD_ERR_TITLE", dBObject.getName());
            DBExceptionDialog.showErrorDialog((Component)IdeUtil.getMainWindow(), string, dBException);
        }
        return false;
    }

    public boolean ensureObjectBuiltEx(DBObject ... dBObjectArray) throws DBException, CancelledException {
        if (dBObjectArray != null && dBObjectArray.length > 0) {
            this.ensureObjectBuiltImpl(dBObjectArray);
            return true;
        }
        return false;
    }

    @Deprecated
    public void ensureDerivedPropertiesBuiltEx(DBObject dBObject) throws DBException {
        if (dBObject != null) {
            this.ensureObjectBuiltImpl(dBObject);
        }
    }

    private Collection<DBObject> getObjectsToBuild(DBObject ... dBObjectArray) {
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        for (DBObject dBObject : dBObjectArray) {
            if ((!(dBObject instanceof SystemObject) || !this.needsBuilding((SystemObject)dBObject)) && (this.m_pro == null || !DBUtil.needsDerivedPropertiesBuilding((DBObjectProvider)this.m_pro, (DBObject)dBObject))) continue;
            arrayList.add(dBObject);
        }
        return arrayList;
    }

    private boolean needsBuilding(SystemObject systemObject) {
        boolean bl = false;
        if (DBUtil.needsBuilding((DBObject)systemObject)) {
            String[] stringArray = this.getPropertiesToBuild(systemObject.getType());
            if (stringArray == null || stringArray.length == 0) {
                bl = true;
            } else {
                for (String string : stringArray) {
                    if (!DBUtil.needsBuilding((DBObject)systemObject, (String)string)) continue;
                    bl = true;
                    break;
                }
            }
        }
        return bl;
    }

    private String getProgressText(DBObject dBObject) {
        SystemObject systemObject = DBUtil.getSystemObject((DBObject)dBObject);
        if (systemObject != null) {
            dBObject = systemObject;
        }
        return UIBundle.format("EXEC_PB_OBJ_PROGRESS", DBTypeDisplayRegistry.getSingularDisplayName(dBObject.getType()), dBObject.getName());
    }

    private void ensureObjectBuiltImpl(DBObject ... dBObjectArray) throws DBException {
        Collection<DBObject> collection = this.getObjectsToBuild(dBObjectArray);
        if (collection.size() > 0) {
            ProgressBar progressBar;
            Frame frame;
            Holder holder = new Holder();
            Holder holder2 = new Holder();
            Holder holder3 = new Holder();
            if (SwingUtilities.isEventDispatchThread()) {
                frame = IdeUtil.getMainWindow();
                progressBar = new ProgressBar((Component)frame, UIBundle.get("EXEC_PB_OBJ_TITLE"), null, true);
                progressBar.setCancelable(this.m_cancellable);
            } else {
                progressBar = null;
            }
            frame = new Holder();
            Runnable runnable = new Runnable((Holder)frame, collection, progressBar, holder2, holder3, holder){
                final /* synthetic */ Holder val$pbThread;
                final /* synthetic */ Collection val$toBuild;
                final /* synthetic */ ProgressBar val$pb;
                final /* synthetic */ Holder val$objHolder;
                final /* synthetic */ Holder val$builderHolder;
                final /* synthetic */ Holder val$dbeHolder;
                {
                    this.val$pbThread = holder;
                    this.val$toBuild = collection;
                    this.val$pb = progressBar;
                    this.val$objHolder = holder2;
                    this.val$builderHolder = holder3;
                    this.val$dbeHolder = holder4;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block23: {
                        this.val$pbThread.set((Object)Thread.currentThread());
                        try {
                            for (DBObject dBObject : this.val$toBuild) {
                                if (this.val$pb != null && this.val$pb.hasUserCancelled()) {
                                    break;
                                }
                                try {
                                    this.val$objHolder.set((Object)dBObject);
                                    if (this.val$pb != null) {
                                        this.val$pb.updateProgress(SchemaObjectBuilder.this.getProgressText(dBObject), null);
                                    }
                                    DerivedPropertyBuilder derivedPropertyBuilder = null;
                                    if (SchemaObjectBuilder.this.m_pro != null) {
                                        derivedPropertyBuilder = SchemaObjectBuilder.this.m_pro.getObjectFactory().ensureDerivedPropertyBuilder(dBObject);
                                    }
                                    boolean bl = false;
                                    String[] stringArray = SchemaObjectBuilder.this.getPropertiesToBuild(dBObject.getType());
                                    if (stringArray == null) {
                                        stringArray = new String[1];
                                        bl = true;
                                    }
                                    for (String string : stringArray) {
                                        if (this.val$pb != null && this.val$pb.hasUserCancelled()) {
                                            break block23;
                                        }
                                        try {
                                            this.val$builderHolder.set((Object)DBUtil.getDBObjectBuilder((DBObject)dBObject, (String)string));
                                            DBUtil.ensureObjectBuilt((DBObject)dBObject, (String[])new String[]{string});
                                        }
                                        finally {
                                            this.val$builderHolder.set(null);
                                        }
                                    }
                                    if (this.val$pb != null && this.val$pb.hasUserCancelled()) {
                                        break;
                                    }
                                    if (!bl || SchemaObjectBuilder.this.m_pro == null || derivedPropertyBuilder == null) continue;
                                    try {
                                        this.val$builderHolder.set((Object)derivedPropertyBuilder);
                                        DBUtil.ensureDerivedPropertiesBuilt((DBObject)dBObject, (DBObjectProvider)SchemaObjectBuilder.this.m_pro);
                                    }
                                    catch (DBException dBException) {
                                        DBLog.getLogger((Object)this).log(Level.WARNING, UIBundle.format("EXEC_DERIVED_BUILD_LOG_ERR", DBTypeDisplayRegistry.getSingularDisplayName(dBObject.getType()), dBObject.getName(), dBException.getMessage()));
                                    }
                                    finally {
                                        this.val$builderHolder.set(null);
                                    }
                                }
                                catch (DBException dBException) {
                                    this.val$dbeHolder.set((Object)dBException);
                                    break;
                                }
                                catch (Throwable throwable) {
                                    this.val$dbeHolder.set((Object)new DBException(dBObject, throwable));
                                    break;
                                }
                            }
                        }
                        finally {
                            this.val$objHolder.set(null);
                            if (this.val$pb != null) {
                                this.val$pb.setDoneStatus();
                            }
                        }
                    }
                }
            };
            if (progressBar == null) {
                runnable.run();
            } else {
                progressBar.setRunnable(runnable);
                DBUIProgressBar.start(progressBar, this.getProgressText(collection.iterator().next()), null);
                if (progressBar.hasUserCancelled()) {
                    Thread thread;
                    DBObjectBuilder dBObjectBuilder = (DBObjectBuilder)holder3.get();
                    if (dBObjectBuilder != null) {
                        dBObjectBuilder.cancelCurrentBuild((DBObject)holder2.get());
                    }
                    if ((thread = (Thread)frame.get()) != null) {
                        StatementWrapper.cancelExecution((Thread)thread);
                    }
                    throw new CancelledException();
                }
            }
            if (holder.get() != null) {
                throw (DBException)((Object)holder.get());
            }
        }
    }
}

