/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.util;

import java.awt.Component;
import javax.accessibility.AccessibleContext;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.SchemaObjectDescriptor;
import oracle.ide.db.util.TreeNodeMaker;
import oracle.ide.util.Assert;
import oracle.ide.util.FastStringBuffer;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.CheckConstraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.sql.AliasFragment;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.DBObjectUsage;
import oracle.javatools.db.sql.FKUsage;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.JoinObject;
import oracle.javatools.db.sql.OrderByObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SimpleSQLFragment;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ModelUtil;

public class DBObjectRenderer
implements TableCellRenderer,
ListCellRenderer,
TreeCellRenderer {
    private static final String EMPTY = "<" + UIBundle.get("EMPTY") + ">";
    private TableCellRenderer m_tableDelegate;
    private ListCellRenderer m_listDelegate;
    private TreeCellRenderer m_treeDelegate;
    private String m_nullLabel;
    private DBObjectProvider m_prov;
    private boolean m_iconify;
    private boolean m_showSchema;

    public DBObjectRenderer() {
    }

    public DBObjectRenderer(boolean bl) {
        this.m_iconify = bl;
    }

    public String getNullLabel() {
        return this.m_nullLabel;
    }

    public void setNullLabel(String string) {
        this.m_nullLabel = string;
    }

    public void setProvider(DBObjectProvider dBObjectProvider) {
        this.m_prov = dBObjectProvider;
    }

    public void setIncludeIcon(boolean bl) {
        this.m_iconify = bl;
    }

    private Object normalise(Object object) {
        Object object2 = object;
        if (object instanceof TemporaryObjectID) {
            object2 = ((TemporaryObjectID)object).getDBObject();
        }
        return object2;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if ((object = this.normalise(object)) instanceof DBObject && (object = ((DBObject)object).getName()) == null) {
            object = this.m_nullLabel;
        }
        if (this.m_tableDelegate == null) {
            this.m_tableDelegate = new DefaultTableCellRenderer();
        }
        return this.m_tableDelegate.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        Object object2;
        object = this.normalise(object);
        if (this.m_listDelegate == null) {
            this.m_listDelegate = new DefaultListCellRenderer();
        }
        Object object3 = object;
        String string = null;
        if (object instanceof SQLFragment) {
            if (object instanceof ColumnUsage) {
                string = "COLUMN";
                object3 = ((ColumnUsage)object).getColumnName();
            } else {
                object3 = ((SQLFragment)object).getSQLText();
            }
        } else if (object instanceof DBObject) {
            string = ((DBObject)object).getType();
            object3 = ((DBObject)object).getName();
            if (null != this.m_prov) {
                Schema schema;
                object2 = null;
                try {
                    object2 = this.m_prov.quoteIdentifier((String)object3, false);
                }
                catch (DBException dBException) {
                    object2 = (String)object3;
                }
                object3 = object2;
                if (this.m_showSchema && object instanceof SchemaObject && (schema = ((SchemaObject)object).getSchema()) != null) {
                    object3 = schema.getName() + "." + (String)object3;
                }
            }
            if (object instanceof FKConstraint && !ModelUtil.hasLength((String)((String)object3))) {
                object3 = " ";
            }
            if (!ModelUtil.hasLength((String)((String)object3)) && object instanceof Schema && ((Schema)object).getProperty("isDefaultSchema", (Object)Boolean.FALSE).equals(Boolean.TRUE)) {
                object3 = UIBundle.get("DEFAULT_USER");
            }
            if (object3 == null) {
                object3 = this.m_nullLabel;
            }
        } else if (object instanceof SchemaObjectDescriptor) {
            object3 = ((SchemaObjectDescriptor)object).getName();
            object2 = ((SchemaObjectDescriptor)object).getOtherName();
            if (object2 != null && !((String)object2).equals(object3)) {
                object3 = (String)object3 + " (" + (String)object2 + ")";
            }
            String string2 = ((SchemaObjectDescriptor)object).getSchema();
            if (this.m_showSchema && ModelUtil.hasLength((String)string2)) {
                object3 = string2 + "." + (String)object3;
            }
            string = ((SchemaObjectDescriptor)object).getType();
        }
        if (object3 instanceof String && object3 != this.m_nullLabel && ("PACKAGE BODY".equals(string) || "TYPE BODY".equals(string))) {
            object3 = UIBundle.format("BODY_FORMAT", object3);
        }
        object2 = (JLabel)this.m_listDelegate.getListCellRendererComponent(jList, object3, n, bl, bl2);
        if (this.m_iconify && string != null) {
            ((JLabel)object2).setIcon(DBTypeDisplayRegistry.getNodeIcon(string));
        }
        if (object instanceof AliasFragment) {
            this.setupAliasFragmentLabel((JLabel)object2, (AliasFragment)object);
        } else if (object instanceof OrderByObject) {
            if (object3 == null || ((OrderByObject)object).getExpression() == null) {
                ((JLabel)object2).setText(EMPTY);
            }
        } else if (object instanceof SimpleSQLFragment && object3 == null) {
            ((JLabel)object2).setText(EMPTY);
        }
        return object2;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        Object object2;
        if (this.m_treeDelegate == null) {
            this.m_treeDelegate = new DefaultTreeCellRenderer();
        }
        JLabel jLabel = (JLabel)this.m_treeDelegate.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        String string = null;
        if (object instanceof DefaultMutableTreeNode) {
            object2 = ((DefaultMutableTreeNode)object).getUserObject();
            if ((object2 = this.normalise(object2)) instanceof SchemaObjectDescriptor) {
                String string2 = ((SchemaObjectDescriptor)object2).getName();
                string = ((SchemaObjectDescriptor)object2).getType();
                if ("PACKAGE BODY".equals(string) || "TYPE BODY".equals(string)) {
                    string2 = UIBundle.format("BODY_FORMAT", string2);
                }
                jLabel.setText(string2);
            } else if (object2 instanceof AliasFragment) {
                if (object2 instanceof FromObject) {
                    FromObject fromObject = (FromObject)object2;
                    SQLFragment sQLFragment = fromObject.getPivotExpression();
                    if (fromObject.getExpression() instanceof JoinObject) {
                        JoinObject joinObject = (JoinObject)fromObject.getExpression();
                        String string3 = joinObject.getJoinType();
                        Object object3 = "JOIN";
                        if (string3 != null) {
                            object3 = string3 + " " + (String)object3;
                        }
                        jLabel.setText((String)object3);
                        if (this.m_iconify) {
                            jLabel.setIcon(DBTypeDisplayRegistry.getNodeIcon("CONSTRAINT"));
                        }
                    } else {
                        String string4;
                        StringBuffer stringBuffer = new StringBuffer(fromObject.getExpression().getSQLText());
                        if (sQLFragment != null) {
                            stringBuffer.append(" ").append(sQLFragment.getSQLText());
                        }
                        if (ModelUtil.hasLength((String)(string4 = fromObject.getAlias()))) {
                            stringBuffer.insert(0, string4 + " (");
                            stringBuffer.append(")");
                        }
                        jLabel.setText(stringBuffer.toString());
                        this.setupIcon(jLabel, fromObject.getExpression());
                    }
                } else {
                    this.setupAliasFragmentLabel(jLabel, (AliasFragment)object2);
                }
            } else if (object2 instanceof FKUsage) {
                DBObject dBObject;
                Object object4 = null;
                DBObjectID dBObjectID = ((FKUsage)object2).getObjectID();
                if (dBObjectID != null) {
                    try {
                        dBObject = dBObjectID.resolveID();
                        object4 = dBObject.getName();
                    }
                    catch (DBException dBException) {
                        Assert.printStackTrace((Throwable)dBException);
                    }
                }
                if ((dBObject = ((FKUsage)object2).resolveRightFromObject()) != null) {
                    object4 = (String)object4 + " (" + dBObject.getName() + ")";
                }
                jLabel.setText((String)object4);
                if (this.m_iconify) {
                    jLabel.setIcon(DBTypeDisplayRegistry.getNodeIcon("CONSTRAINT"));
                }
            } else if (object2 instanceof SQLFragment) {
                String string5 = ((SQLFragment)object2).getSQLText();
                jLabel.setText(string5);
                DBObjectRenderer.setToolTipText(jLabel, string5);
                if (object2 instanceof ColumnUsage) {
                    jLabel.setIcon(OracleIcons.getIcon((String)"column.png"));
                } else {
                    jLabel.setIcon(OracleIcons.getIcon((String)"plsql_function.png"));
                }
            } else if (object2 instanceof DBObject) {
                Schema schema;
                Object object5 = ((DBObject)object2).getName();
                string = ((DBObject)object2).getType();
                if ("PACKAGE BODY".equals(string) || "TYPE BODY".equals(string)) {
                    object5 = UIBundle.format("BODY_FORMAT", object5);
                }
                if (this.m_showSchema && object2 instanceof SchemaObject && (schema = ((SchemaObject)object2).getSchema()) != null) {
                    object5 = schema.getName() + "." + (String)object5;
                }
                jLabel.setText((String)object5);
                DBObjectRenderer.setToolTipText(jLabel, DBUtil.getFullyQualifiedName((DBObject)((DBObject)object2)));
                if (object2 instanceof FKConstraint) {
                    jLabel.setIcon(OracleIcons.getIcon((String)"foreignkey.png"));
                } else if (object2 instanceof CheckConstraint) {
                    jLabel.setIcon(OracleIcons.getIcon((String)"constraint.png"));
                } else if (object2 instanceof PKConstraint) {
                    jLabel.setIcon(OracleIcons.getIcon((String)"primarykey.png"));
                } else if (object2 instanceof UniqueConstraint) {
                    jLabel.setIcon(OracleIcons.getIcon((String)"key.png"));
                } else {
                    string = ((DBObject)object2).getType();
                }
            } else if (object2 instanceof String && this.m_iconify && !bl3) {
                Icon icon = DBTypeDisplayRegistry.getFolderIcon((String)object2);
                if (icon == null) {
                    jLabel.setIcon(OracleIcons.getIcon((String)"folder.png"));
                } else {
                    jLabel.setIcon(icon);
                }
            }
        }
        if (this.m_iconify && string != null && (object2 = DBTypeDisplayRegistry.getNodeIcon(string)) != null) {
            jLabel.setIcon((Icon)object2);
        }
        return jLabel;
    }

    public void setShowSchema(boolean bl) {
        this.m_showSchema = bl;
    }

    private void setupAliasFragmentLabel(JLabel jLabel, AliasFragment aliasFragment) {
        String string = aliasFragment.getAlias();
        SQLFragment sQLFragment = aliasFragment.getExpression();
        String string2 = null;
        if (sQLFragment != null) {
            string2 = sQLFragment.getSQLText();
        }
        FastStringBuffer fastStringBuffer = new FastStringBuffer();
        if (ModelUtil.hasLength((String)string)) {
            fastStringBuffer.append(string);
            fastStringBuffer.append(" (");
            fastStringBuffer.append(string2);
            fastStringBuffer.append(")");
        } else if (ModelUtil.hasLength((String)string2)) {
            fastStringBuffer.append(string2);
        } else {
            fastStringBuffer.append(EMPTY);
        }
        jLabel.setText(fastStringBuffer.toString());
        this.setupIcon(jLabel, sQLFragment);
    }

    private void setupIcon(JLabel jLabel, SQLFragment sQLFragment) {
        DBObjectID dBObjectID;
        if (this.m_iconify && sQLFragment instanceof DBObjectUsage && (dBObjectID = ((DBObjectUsage)sQLFragment).getObjectID()) != null) {
            String string = dBObjectID.getType();
            jLabel.setIcon(DBTypeDisplayRegistry.getNodeIcon(string));
        }
    }

    public static void setToolTipText(JComponent jComponent, String string) {
        jComponent.setToolTipText(string);
        AccessibleContext accessibleContext = jComponent.getAccessibleContext();
        if (accessibleContext != null) {
            accessibleContext.setAccessibleDescription(string);
        }
    }

    @Deprecated
    public static DefaultMutableTreeNode createTreeNode(DBObject dBObject, boolean bl) {
        return DBObjectRenderer.createTreeNode(dBObject, bl, null);
    }

    @Deprecated
    public static DefaultMutableTreeNode createTreeNode(DBObject dBObject, boolean bl, String[] stringArray) {
        TreeNodeMaker treeNodeMaker = new TreeNodeMaker(true, stringArray);
        return treeNodeMaker.createTreeNode(dBObject);
    }

    @Deprecated
    public static DefaultMutableTreeNode createTreeNode(SQLFragment sQLFragment, boolean bl) {
        TreeNodeMaker treeNodeMaker = new TreeNodeMaker(true);
        return treeNodeMaker.createTreeNode(sQLFragment);
    }
}

