/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.sql.tester;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.help.HelpUtils;
import oracle.ide.db.controls.DBObjectProviderPicker;
import oracle.ide.db.dialogs.DBExceptionDialog;
import oracle.ide.db.panels.sql.tester.SQLQueryTester;
import oracle.ide.db.panels.sql.tester.TestSQLPanel;
import oracle.ide.db.panels.sql.tester.TesterComponent;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectProviderID;
import oracle.javatools.db.Database;

class TesterPanel
extends JPanel {
    private final DBObjectProviderPicker m_picker;
    private final DBObjectProviderPicker.PickerListener m_pickerListener = dBObjectProviderID -> this.pickerProviderChanged(dBObjectProviderID);
    private final JTextArea m_txtSQL = new JTextArea();
    private final JSplitPane m_pane;
    private final JTabbedPane m_tabPane = new JTabbedPane();
    private final ChangeListener m_changeListener = changeEvent -> this.panelChanged();
    private final DBUIResourceHelper m_reshelp = new DBUIResourceHelper("TesterPanel");
    private final List<TesterComponent> m_queryComps = new ArrayList<TesterComponent>();
    private Database m_db;
    private boolean m_pickerShown;
    private String m_queryTxt;
    private Map<String, Object> m_bindVariables;
    private SQLQueryTester.Result m_result;
    private boolean m_listen;

    TesterPanel(SQLQueryTester sQLQueryTester) {
        this.setLayout(new GridBagLayout());
        HelpUtils.setHelpID((JComponent)this, (String)"f1_odbsqltester_html");
        this.m_reshelp.setName(this.m_tabPane, "TesterTabPane");
        this.addPanel(new TestSQLPanel(this.m_txtSQL, this));
        this.m_txtSQL.setFont(Font.decode("Monospaced"));
        this.m_pane = new JSplitPane(0, TesterPanel.newChildPanel(this.m_txtSQL, UIBundle.get("TESTSQL_SQL_LABEL"), "SQL", this.m_reshelp, this), this.m_tabPane);
        this.m_reshelp.setName(this.m_pane, "Split");
        this.m_pane.setResizeWeight(0.5);
        DBObjectProviderPicker.PickerConfiguration pickerConfiguration = new DBObjectProviderPicker.PickerConfiguration();
        pickerConfiguration.setContext(sQLQueryTester.getContext());
        pickerConfiguration.setAllowNull(false);
        pickerConfiguration.setProviderTypes("db");
        DBUILayoutHelper dBUILayoutHelper = new DBUILayoutHelper(this);
        this.m_picker = DBObjectProviderPicker.getPicker(pickerConfiguration);
        if (this.m_picker != null) {
            this.m_pickerShown = true;
            dBUILayoutHelper.add(this.m_picker.getComponent(), 1, 1, true, false);
            dBUILayoutHelper.nextRow();
        }
        dBUILayoutHelper.add(this.m_pane);
        dBUILayoutHelper.layout();
    }

    void setShowConnectionPicker(boolean bl) {
        if (this.m_picker != null) {
            this.m_picker.getComponent().setVisible(bl);
            this.m_pickerShown = bl;
        }
    }

    private Database getChosenDatabase() {
        Database database = null;
        try {
            database = (Database)this.m_picker.getProvider();
        }
        catch (DBException dBException) {
            DBExceptionDialog.showErrorDialog(null, null, dBException);
        }
        return database;
    }

    Component getDefaultFocusComponent() {
        return this.m_txtSQL;
    }

    void setBindVariables(Map<String, Object> map) {
        this.m_bindVariables = map;
        for (TesterComponent testerComponent : this.m_queryComps) {
            testerComponent.setBindVariables(map);
        }
    }

    SQLQueryTester.Result getResult() {
        return this.m_result;
    }

    void setResult(boolean bl, String string, Integer n) {
        this.m_result = new SQLQueryTester.Result(this.m_queryTxt, bl, string, n);
    }

    void addPanel(TesterComponent testerComponent) {
        this.m_queryComps.add(testerComponent);
        this.m_tabPane.add(testerComponent.getName(), testerComponent.getComponent());
        testerComponent.setBindVariables(this.m_bindVariables);
    }

    void testSQL(Database database, String string) {
        this.m_listen = true;
        this.m_queryTxt = string;
        if (this.m_picker != null) {
            this.m_picker.removePickerListener(this.m_pickerListener);
        }
        if (this.m_pickerShown && database != null && database.getConnectionStore() != null) {
            this.m_picker.setProvider((DBObjectProvider)database);
            this.m_db = this.getChosenDatabase();
        } else {
            this.m_db = database;
        }
        if (this.m_tabPane.getSelectedIndex() != 0) {
            this.m_tabPane.setSelectedIndex(0);
        } else {
            this.panelChanged();
        }
        this.m_tabPane.addChangeListener(this.m_changeListener);
        if (this.m_pickerShown) {
            this.m_picker.addPickerListener(this.m_pickerListener);
        }
    }

    private void pickerProviderChanged(DBObjectProviderID dBObjectProviderID) {
        if (this.m_pickerShown) {
            this.m_db = this.getChosenDatabase();
            if (this.m_tabPane.getSelectedIndex() > 0) {
                this.m_tabPane.setSelectedIndex(0);
            } else {
                this.panelChanged();
            }
        }
    }

    private void panelChanged() {
        if (this.m_listen) {
            int n = this.m_tabPane.getSelectedIndex();
            if (this.m_db == null) {
                this.enableTabs(false);
                if (n != 0) {
                    try {
                        this.m_listen = false;
                        this.m_tabPane.setSelectedIndex(0);
                    }
                    finally {
                        this.m_listen = true;
                    }
                }
            } else {
                this.enableTabs(true);
                this.m_queryComps.get(n).testSQL(this.m_db, this.m_queryTxt);
            }
        }
    }

    void enableTabs(boolean bl) {
        for (int i = 1; i < this.m_tabPane.getTabCount(); ++i) {
            this.m_tabPane.setEnabledAt(i, bl);
        }
    }

    void close() {
        this.m_tabPane.removeChangeListener(this.m_changeListener);
        for (TesterComponent testerComponent : this.m_queryComps) {
            try {
                testerComponent.close();
            }
            catch (Exception exception) {
                DBLog.getLogger((Object)this).log(Level.SEVERE, testerComponent.getClass().getSimpleName(), exception);
            }
        }
        this.m_db = null;
    }

    static JPanel newChildPanel(JTextArea jTextArea, String string, String string2, DBUIResourceHelper dBUIResourceHelper, Component component) {
        JLabel jLabel = new JLabel();
        dBUIResourceHelper.resLabel(jLabel, jTextArea, string, string2);
        jTextArea.setEditable(false);
        jTextArea.setBackground(component.getBackground());
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        dBUIResourceHelper.setName(jScrollPane, string2 + "Scroll");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(5, 5));
        jPanel.add((Component)jLabel, "North");
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }
}

