/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels;

import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.ProviderOperator;
import oracle.ide.db.controls.NameAndSchemaAdvancedEditor;
import oracle.ide.db.controls.NameAndSchemaEditor;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.panels.DBTraversable;
import oracle.ide.db.panels.DDLPanel;
import oracle.ide.db.panels.MDDEditorPanel;
import oracle.ide.db.panels.TabbedEditorPanel;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.ideimpl.db.panels.DBNavigable;
import oracle.ideimpl.db.panels.GeneralPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.AbstractDatabase;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.TemplateExpander;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.validators.ValidationLevel;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.Tuple;

public abstract class PanelLibrary<T extends DBObject> {
    @Deprecated
    public static final String KEY = PanelLibrary.class.getName();
    @Deprecated
    public static final String COMMIT_TO_PROVIDER_KEY = "COMMIT_TO_PROVIDER_KEY";
    private final String m_type;
    private final Map<String, String> m_helpIDs;
    private final Panels m_panels;
    private boolean m_changingPanels;

    protected PanelLibrary(String string) {
        this(string, null);
    }

    protected PanelLibrary(String string, Map<String, String> map) {
        this.m_type = string;
        this.m_helpIDs = map;
        this.m_panels = new Panels();
    }

    private PanelLibrary(PanelLibrary panelLibrary) {
        this.m_type = panelLibrary.m_type;
        this.m_helpIDs = panelLibrary.m_helpIDs;
        this.m_panels = panelLibrary.m_panels;
    }

    protected Logger getLogger() {
        return DBLog.getLogger((Object)this);
    }

    public String getType() {
        return this.m_type;
    }

    public final void setDefaultPanels(Navigable[] navigableArray) {
        this.setDefaultPanels(navigableArray, false);
    }

    public final void setDefaultPanels(Navigable[] navigableArray, boolean bl) {
        this.m_panels.m_defaultPanels = navigableArray;
        this.m_panels.m_alwaysAddDefaultPanels = bl;
    }

    public Navigable[] getDefaultPanels(boolean bl) {
        Navigable[] navigableArray;
        Navigable[] navigableArray2 = navigableArray = this.m_panels.m_defaultPanels == null ? null : new Navigable[this.m_panels.m_defaultPanels.length];
        if (navigableArray != null) {
            for (int i = 0; i < navigableArray.length; ++i) {
                navigableArray[i] = (Navigable)this.m_panels.m_defaultPanels[i].copyTo(null);
            }
        }
        return navigableArray;
    }

    protected final void addDefaultPanels(List<Navigable> list, boolean bl) {
        Navigable[] navigableArray;
        if (list != null && (list.size() > 0 || this.m_panels.m_alwaysAddDefaultPanels) && (navigableArray = this.getDefaultPanels(bl)) != null) {
            for (int i = 0; i < navigableArray.length; ++i) {
                Navigable navigable = (Navigable)navigableArray[i].copyTo(null);
                list.add(navigable);
            }
        }
    }

    protected Class<? extends Traversable> getHeader() {
        if (this.getSimpleTitles() != null) {
            return NameAndSchemaAdvancedEditor.class;
        }
        return NameAndSchemaEditor.class;
    }

    protected String getHeaderHelpID() {
        return this.getGeneralHelpID();
    }

    protected String getGeneralHelpID() {
        return null;
    }

    public final Navigable getGeneralNavigable(DBEditorConfig dBEditorConfig) {
        DBNavigable dBNavigable = null;
        Traversable traversable = this.createHeader();
        if (traversable != null) {
            Collection<String> collection = this.getGeneralTitles();
            List<Navigable> list = this.getNavigables(collection, (DBObject)dBEditorConfig.getUpdatedObject(), dBEditorConfig.getProvider(), true, false, true);
            dBNavigable = new DBNavigable(UIBundle.get("GENERAL"), GeneralPanel.class, new Class[]{Traversable.class, List.class}, new Object[]{traversable, list});
            HashSet<String> hashSet = new HashSet<String>();
            for (String string : collection) {
                Collection<String> collection2 = this.m_panels.m_properties.get(string);
                if (collection2 == null) continue;
                hashSet.addAll(collection2);
            }
            dBNavigable.setProperties(hashSet);
            dBNavigable.setHelpID(this.getGeneralHelpID());
        }
        return dBNavigable;
    }

    public Collection<String> getGeneralTitles() {
        String string = null;
        Map<String, Navigable> map = this.getNavigables();
        if (map.size() == 1) {
            string = map.keySet().iterator().next();
        } else {
            String[] stringArray;
            for (String string2 : stringArray = new String[]{UIBundle.get("COMMENT"), UIBundle.get("PROPERTIES")}) {
                if (!map.containsKey(string2)) continue;
                string = string2;
                break;
            }
        }
        return string == null ? Collections.emptyList() : Collections.singleton(string);
    }

    public boolean getSkipGeneralForNewObject() {
        Collection<String> collection = this.getGeneralTitles();
        return collection == null || collection.size() == 1 && ModelUtil.areEqual((Object)UIBundle.get("COMMENT"), (Object)collection.iterator().next());
    }

    protected Class<? extends Traversable> getDDLPanel() {
        return DDLPanel.class;
    }

    public Navigable getDDLNavigable() {
        DBNavigable dBNavigable = null;
        Class<Traversable> clazz = this.getDDLPanel();
        if (clazz != null) {
            dBNavigable = new DBNavigable(UIBundle.get("DDL_TITLE"), clazz);
            dBNavigable.setHelpID("f1_odbddl_html");
        }
        return dBNavigable;
    }

    public Component getInitialFocus(Traversable traversable) {
        if (traversable instanceof DBTraversable) {
            return ((DBTraversable)traversable).getDefaultFocusComponent();
        }
        return null;
    }

    public final Traversable getMainDialogPanel(DBEditorConfig dBEditorConfig, Navigable[] navigableArray) {
        String string = this.getStartPage(dBEditorConfig);
        Traversable traversable = this.createHeader();
        return this.createMainPanel(traversable, navigableArray, string);
    }

    @Deprecated
    public final Traversable getMainDialogPanel(T t, DBObjectProvider dBObjectProvider, DBObject dBObject, Navigable[] navigableArray) {
        String string = this.getStartPage(dBObject);
        Traversable traversable = this.createHeader();
        return this.createMainPanel(traversable, navigableArray, string);
    }

    private Traversable createHeader() {
        Traversable traversable = null;
        try {
            Class<Traversable> clazz = this.getHeader();
            if (clazz != null) {
                traversable = clazz.newInstance();
            }
        }
        catch (Exception exception) {
            this.getLogger().log(Level.SEVERE, this.getType(), exception);
        }
        return traversable;
    }

    public boolean prepareEditorInBackground(DBEditorConfig dBEditorConfig) {
        return dBEditorConfig.getProvider() instanceof Database;
    }

    public void prepareObjectForEditor(DBEditorConfig dBEditorConfig, List<Navigable> list) throws DBException {
        if (dBEditorConfig.isEdit() || TemplateExpander.isPendingObject((DBObject)dBEditorConfig.getUpdatedObject())) {
            String string = this.getStartPage(dBEditorConfig);
            Navigable navigable = null;
            if (string != null) {
                navigable = this.getNavigables().get(string);
            }
            if (navigable == null && list != null && list.size() > 0) {
                navigable = list.get(0);
            }
            if (navigable != null) {
                this.prepareObjectForNavigable(dBEditorConfig, navigable);
            }
        }
    }

    protected void prepareObjectForNavigable(DBEditorConfig dBEditorConfig, Navigable navigable) throws DBException {
        Collection<String> collection = this.m_panels.m_properties.get(navigable.getShortLabel());
        if (collection != null && !collection.isEmpty()) {
            SystemObject systemObject = dBEditorConfig.getUpdatedObject();
            this.getLogger().fine("Preparing " + systemObject.getName() + " building: " + collection);
            DBUtil.ensureObjectBuilt((DBObject)systemObject, (String[])collection.toArray(new String[collection.size()]));
        }
    }

    protected Traversable createMainPanel(Traversable traversable, Navigable[] navigableArray, String string) {
        List<Navigable> list = this.getSimpleNavigables();
        int n = list == null ? 0 : list.size();
        TabbedEditorPanel tabbedEditorPanel = n > 0 ? new MDDEditorPanel(traversable, navigableArray, string, n) : new TabbedEditorPanel(traversable, navigableArray, string);
        tabbedEditorPanel.setHelpID(this.getHeaderHelpID());
        return tabbedEditorPanel;
    }

    protected boolean includePanelHeaders(DBEditorConfig dBEditorConfig) {
        return dBEditorConfig.getEditorType() == DBEditorFactory.EditorType.EDIT_FLAT;
    }

    public final List<Navigable> getNavigables(DBEditorConfig dBEditorConfig) {
        DBObject dBObject = dBEditorConfig.isChildEditOnly() ? dBEditorConfig.getChildObject() : dBEditorConfig.getUpdatedObject();
        DBObjectProvider dBObjectProvider = dBEditorConfig.getProvider();
        boolean bl = dBEditorConfig.isEdit();
        DBEditorFactory.EditorType editorType = dBEditorConfig.getEditorType();
        boolean bl2 = editorType == DBEditorFactory.EditorType.EDIT_FLAT;
        List<String> list = this.getTitles(dBObject, dBObjectProvider, bl);
        if (bl2 && list != null) {
            list = new ArrayList<String>(list);
            list.removeAll(this.getGeneralTitles());
        }
        List<Navigable> list2 = this.getNavigables(list, dBObject, dBObjectProvider, bl, this.includePanelHeaders(dBEditorConfig), false);
        if (bl2) {
            if (list2 == null) {
                list2 = new ArrayList<Navigable>();
            }
            list2.add(0, this.getGeneralNavigable(dBEditorConfig));
        }
        if (list2 != null) {
            Navigable navigable;
            if (!dBEditorConfig.isChildEditOnly()) {
                this.addDefaultPanels(list2, bl);
            }
            if ((editorType == DBEditorFactory.EditorType.CREATE_MODAL || editorType == DBEditorFactory.EditorType.EDIT_MODAL) && (navigable = this.getDDLNavigable()) != null) {
                list2.add(navigable);
            }
        }
        return list2;
    }

    @Deprecated
    public final List<Navigable> getCreateNavigables(T t, DBObjectProvider dBObjectProvider) {
        List<Navigable> list = this.getNavigables((Collection<String>)this.getTitles(t, dBObjectProvider, false), (DBObject)t, dBObjectProvider, false, false, false);
        if (list != null) {
            this.addDefaultPanels(list, false);
        }
        return list;
    }

    @Deprecated
    public final Map<String, Class> getCreateVerifiers() {
        return this.getVerifiers(false);
    }

    public boolean canEditObject(T t, DBObjectProvider dBObjectProvider) {
        String string;
        boolean bl = false;
        if (t != null && (string = t.getType()).equals(this.getType())) {
            bl = !(dBObjectProvider instanceof Database) || dBObjectProvider.isEditable(t);
        }
        return bl;
    }

    @Deprecated
    public final List<Navigable> getEditNavigables(T t, DBObjectProvider dBObjectProvider) {
        List<Navigable> list = this.getNavigables((Collection<String>)this.getTitles(t, dBObjectProvider, true), (DBObject)t, dBObjectProvider, true, false, false);
        if (list != null && t instanceof SystemObject) {
            this.addDefaultPanels(list, true);
        }
        return list;
    }

    @Deprecated
    public final Map<String, Class> getEditVerifiers() {
        return this.getVerifiers(true);
    }

    public final List<Navigable> getSimpleNavigables() {
        List<Navigable> list = null;
        List<String> list2 = this.getSimpleTitles();
        if (list2 != null) {
            list = this.getNavigables(list2, null, null, false, false, false);
            Navigable navigable = this.getDDLNavigable();
            if (navigable != null) {
                list.add(navigable);
            }
        }
        return list;
    }

    public final T getObjectForCreate(Schema schema, DBObjectProvider dBObjectProvider, DBObject dBObject) {
        T t = this.newDBObject(dBObjectProvider, schema, dBObject);
        this.makeNameUnique((DBObject)t, schema, dBObjectProvider, dBObject);
        t.setID(TemporaryObjectID.createID(t));
        return t;
    }

    public final void makeNameUnique(DBObject dBObject, Schema schema, DBObjectProvider dBObjectProvider, DBObject dBObject2) {
        Tuple tuple;
        Integer n;
        String string = dBObject.getName();
        Object object = dBObject instanceof SchemaObject ? schema : dBObject2;
        Set<String> set = this.getNamesToExclude(dBObjectProvider, (DBObject)object);
        if (set != null && set.contains(string) && (n = (Integer)(tuple = DBUtil.splitBaseName((String)string)).getSecond()) != null) {
            String string2 = (String)tuple.getFirst();
            int n2 = n;
            for (String string3 : set) {
                Integer n3;
                Tuple tuple2 = DBUtil.splitBaseName((String)string3);
                if (!ModelUtil.areEqual((Object)string2, (Object)tuple2.getFirst()) || (n3 = (Integer)tuple2.getSecond()) == null || n3 <= n2) continue;
                n2 = n3;
            }
            String string4 = string2 + (n2 + 1);
            string = dBObjectProvider.getUniqueName(this.m_type, (DBObject)object, string4);
            dBObject.setName(string);
        }
        if (dBObject instanceof SchemaObject) {
            ((SchemaObject)dBObject).setSchema(schema);
        }
    }

    protected Set<String> getNamesToExclude(DBObjectProvider dBObjectProvider, DBObject dBObject) {
        return null;
    }

    public void commitToProvider(DBEditorConfig dBEditorConfig) {
        dBEditorConfig.setException(null);
        dBEditorConfig.setResult(DBEditorConfig.Result.IN_PROGRESS);
        ProviderOperator providerOperator = new ProviderOperator(dBEditorConfig.getProvider());
        providerOperator.updateObjects(dBEditorConfig);
    }

    public boolean showEditorAfterCommit() {
        return false;
    }

    @Deprecated
    protected String getUniqueName(String string) {
        String string2 = string;
        if (string2.indexOf(" ") >= 0) {
            StringBuilder stringBuilder = new StringBuilder();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
            while (stringTokenizer.hasMoreElements()) {
                String string3 = stringTokenizer.nextToken();
                if (stringTokenizer.hasMoreElements()) {
                    stringBuilder.append(string3.substring(0, 1));
                    continue;
                }
                stringBuilder.append(string3);
            }
            string2 = stringBuilder.toString();
        }
        return string2 + "1";
    }

    public String getStartPage(DBEditorConfig dBEditorConfig) {
        String string = null;
        if (dBEditorConfig != null && (string = dBEditorConfig.getStartPage()) == null) {
            String string2 = null;
            DBObject dBObject = dBEditorConfig.getChildObject();
            if (dBObject == null) {
                string2 = dBEditorConfig.getProperty();
            } else {
                string2 = DBUtil.getPropertyPath((DBObject)dBEditorConfig.getUpdatedObject(), (DBObject)dBObject);
                if (string2 == null) {
                    this.getLogger().warning("Given child does not exist in the object we are editing.");
                }
            }
            if (string2 != null) {
                block0: for (Map.Entry<String, Collection<String>> entry : this.m_panels.m_properties.entrySet()) {
                    for (String string3 : entry.getValue()) {
                        if (!string2.startsWith(string3)) continue;
                        string = entry.getKey();
                        break block0;
                    }
                }
                if (dBEditorConfig.getEditorType() == DBEditorFactory.EditorType.EDIT_FLAT && (string == null || this.getGeneralTitles().contains(string))) {
                    string = UIBundle.get("GENERAL");
                }
            }
            if (string != null) {
                dBEditorConfig.setStartPage(string);
            }
        }
        return string;
    }

    @Deprecated
    public String getStartPage(DBObject dBObject) {
        return null;
    }

    protected T newDBObject(DBObjectProvider dBObjectProvider, Schema schema, DBObject dBObject) {
        DBObject dBObject2;
        Class clazz = Metadata.getInstance().getObjectClass(this.m_type);
        if (SchemaObject.class.isAssignableFrom(clazz)) {
            dBObject2 = dBObjectProvider.getObjectFactory().newObject(clazz, (DBObject)schema);
            if (dBObject2 instanceof SchemaObject && dBObject instanceof SchemaObject) {
                this.setContextObject((SchemaObject)dBObject2, (SchemaObject)dBObject);
            }
        } else {
            dBObject2 = dBObjectProvider.getObjectFactory().newObject(clazz, dBObject);
        }
        return (T)dBObject2;
    }

    protected void setContextObject(SchemaObject schemaObject, SchemaObject schemaObject2) {
        if (schemaObject instanceof ChildDBObject) {
            ((ChildDBObject)schemaObject).setParent((DBObject)schemaObject2);
        }
    }

    protected abstract List<String> getTitles(T var1, DBObjectProvider var2, boolean var3);

    @Deprecated
    protected void addSupportedTitle(SystemObject systemObject, DBObjectProvider dBObjectProvider, String string, Collection<String> collection, String string2) {
    }

    @Deprecated
    protected void addSupportedTitle(SystemObject systemObject, DBObjectProvider dBObjectProvider, String[] stringArray, Collection<String> collection, String string) {
    }

    @Deprecated
    protected Map<String, Class> getVerifiers(boolean bl) {
        return Collections.emptyMap();
    }

    protected List<String> getSimpleTitles() {
        return null;
    }

    private final List<Navigable> getNavigables(Collection<String> collection, DBObject dBObject, DBObjectProvider dBObjectProvider, boolean bl, boolean bl2, boolean bl3) {
        if (collection == null) {
            return null;
        }
        Navigable[] navigableArray = this.getDefaultPanels(bl);
        ArrayList<Navigable> arrayList = new ArrayList<Navigable>();
        for (String string : collection) {
            DBNavigable dBNavigable;
            int n;
            Navigable navigable = this.getNavigables().get(string);
            if (navigable == null && navigableArray != null) {
                for (n = 0; n < navigableArray.length; ++n) {
                    if (!string.equals(navigableArray[n].getShortLabel())) continue;
                    navigable = navigableArray[n];
                    break;
                }
            }
            if (navigable == null) {
                this.getLogger().warning("no such editor panel " + string);
                continue;
            }
            n = 1;
            Collection<String> collection2 = this.m_panels.m_properties.get(string);
            if (dBObjectProvider != null && dBObject instanceof SystemObject && collection2 != null && !collection2.isEmpty()) {
                n = bl3 ? 1 : 0;
                if (!bl3) {
                    dBNavigable = dBObjectProvider.getPropertyManager();
                    for (String string2 : collection2) {
                        if (!dBNavigable.canCreateProperty((SystemObject)dBObject, string2)) continue;
                        n = 1;
                        break;
                    }
                }
            }
            if (n == 0) continue;
            dBNavigable = new DBNavigable(navigable, bl2);
            dBNavigable.setProperties(collection2);
            if (this.m_helpIDs != null && this.m_helpIDs.containsKey(string)) {
                dBNavigable.setHelpID(this.m_helpIDs.get(string));
            }
            arrayList.add(dBNavigable);
        }
        return arrayList;
    }

    protected final Navigable addPanel(String string, Class<? extends Traversable> clazz, String string2, String ... stringArray) {
        return this.addPanel(string, clazz, string2, (Class[])null, (Object[])null, stringArray);
    }

    protected final Navigable addPanel(String string, Class<? extends Traversable> clazz, String string2, Class[] classArray, Object[] objectArray, String ... stringArray) {
        Navigable navigable = new Navigable(string, clazz, classArray, objectArray, null);
        navigable.setHelpID(string2);
        this.addNavigable(string, navigable, stringArray);
        return navigable;
    }

    protected final void addNavigable(String string, Navigable navigable, String ... stringArray) {
        this.getNavigables().put(string, navigable);
        if (stringArray != null) {
            this.m_panels.m_properties.put(string, Arrays.asList(stringArray));
        }
    }

    protected Map<String, Navigable> getNavigables() {
        return this.m_panels.m_panels;
    }

    public Dimension getSize(boolean bl) {
        return null;
    }

    public String getCreateText() {
        return DBTypeDisplayRegistry.getNewMenuItemText(this.getType());
    }

    public String getCreateTitle() {
        return DBTypeDisplayRegistry.getDialogTitle(this.getType(), false, false);
    }

    public String getEditTitle() {
        return DBTypeDisplayRegistry.getDialogTitle(this.getType(), true, false);
    }

    public String getErrorTitle(boolean bl) {
        return DBTypeDisplayRegistry.getDialogTitle(this.getType(), bl, true);
    }

    public boolean canReplaceByDefault() {
        return false;
    }

    public boolean shouldResetObjectBeforeEdit(DBEditorConfig dBEditorConfig) {
        boolean bl = false;
        DBObjectProvider dBObjectProvider = dBEditorConfig.getProvider();
        String string = this.getType();
        if (Metadata.getInstance().isTypeOf(SystemObject.class, string) && dBObjectProvider instanceof AbstractDatabase) {
            bl = !((AbstractDatabase)dBObjectProvider).supportsTimestamps(string);
        }
        return bl;
    }

    public boolean shouldValidateOnExit(BaseEditorPanel baseEditorPanel, Namespace namespace) {
        return !this.m_changingPanels && !Boolean.getBoolean("ide.db.skipValidation");
    }

    public ValidationLevel getValidationLevel(DBEditorConfig dBEditorConfig) {
        ValidationLevel validationLevel = dBEditorConfig.getProvider() instanceof Database && !Boolean.getBoolean("ide.db.forceFullValidation") ? ValidationLevel.SIMPLE : ValidationLevel.FULL;
        return validationLevel;
    }

    public boolean checkPrivilege(T t, DBObjectProvider dBObjectProvider, boolean bl) {
        return true;
    }

    public static void ensurePanels(Namespace namespace, PanelSetChangeValidator panelSetChangeValidator) throws TraversalException {
        PanelLibrary panelLibrary = (PanelLibrary)namespace.find(PanelLibrary.class);
        PanelSetChanger panelSetChanger = (PanelSetChanger)namespace.find(PanelSetChanger.class);
        if (panelLibrary != null && panelSetChanger != null) {
            List<Navigable> list = panelLibrary.getNavigables((DBEditorConfig)namespace.find(DBEditorConfig.class));
            PanelLibrary.ensurePanelsImpl(list, panelLibrary, panelSetChanger, panelSetChangeValidator);
        }
    }

    public static void ensureSimplePanels(Namespace namespace, PanelSetChangeValidator panelSetChangeValidator) throws TraversalException {
        PanelLibrary panelLibrary = (PanelLibrary)namespace.find(PanelLibrary.class);
        PanelSetChanger panelSetChanger = (PanelSetChanger)namespace.find(PanelSetChanger.class);
        if (panelLibrary != null && panelSetChanger != null) {
            PanelLibrary.ensurePanelsImpl(panelLibrary.getSimpleNavigables(), panelLibrary, panelSetChanger, panelSetChangeValidator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensurePanelsImpl(List<Navigable> list, PanelLibrary panelLibrary, PanelSetChanger panelSetChanger, PanelSetChangeValidator panelSetChangeValidator) throws TraversalException {
        panelLibrary.m_changingPanels = true;
        try {
            panelSetChanger.panelSetChange(list.toArray(new Navigable[list.size()]), panelSetChangeValidator);
        }
        finally {
            panelLibrary.m_changingPanels = false;
        }
    }

    private static final class Panels {
        private final Map<String, Navigable> m_panels = new HashMap<String, Navigable>();
        private final Map<String, Collection<String>> m_properties = new LinkedHashMap<String, Collection<String>>();
        private Navigable[] m_defaultPanels;
        private boolean m_alwaysAddDefaultPanels;

        private Panels() {
        }
    }

    public static class DelegatePanelLibrary<T extends DBObject>
    extends PanelLibrary<T> {
        private final PanelLibrary<T> m_delegate;

        public DelegatePanelLibrary(PanelLibrary<T> panelLibrary) {
            super(panelLibrary);
            this.m_delegate = panelLibrary;
        }

        @Override
        protected List<String> getTitles(T t, DBObjectProvider dBObjectProvider, boolean bl) {
            return this.m_delegate.getTitles(t, dBObjectProvider, bl);
        }

        @Override
        protected Traversable createMainPanel(Traversable traversable, Navigable[] navigableArray, String string) {
            return this.m_delegate.createMainPanel(traversable, navigableArray, string);
        }

        @Override
        protected Class<? extends Traversable> getHeader() {
            return this.m_delegate.getHeader();
        }

        @Override
        protected List<String> getSimpleTitles() {
            return this.m_delegate.getSimpleTitles();
        }

        @Override
        public Dimension getSize(boolean bl) {
            return this.m_delegate.getSize(bl);
        }

        @Override
        public boolean showEditorAfterCommit() {
            return this.m_delegate.showEditorAfterCommit();
        }

        @Override
        public void commitToProvider(DBEditorConfig dBEditorConfig) {
            this.m_delegate.commitToProvider(dBEditorConfig);
        }

        @Override
        public String getStartPage(DBEditorConfig dBEditorConfig) {
            return this.m_delegate.getStartPage(dBEditorConfig);
        }

        @Override
        protected Map<String, Class> getVerifiers(boolean bl) {
            return this.m_delegate.getVerifiers(bl);
        }

        @Override
        protected T newDBObject(DBObjectProvider dBObjectProvider, Schema schema, DBObject dBObject) {
            return this.m_delegate.newDBObject(dBObjectProvider, schema, dBObject);
        }

        @Override
        protected String getGeneralHelpID() {
            return this.m_delegate.getGeneralHelpID();
        }

        @Override
        public Collection<String> getGeneralTitles() {
            return this.m_delegate.getGeneralTitles();
        }

        @Override
        protected Class<? extends Traversable> getDDLPanel() {
            return this.m_delegate.getDDLPanel();
        }

        @Override
        public boolean prepareEditorInBackground(DBEditorConfig dBEditorConfig) {
            return this.m_delegate.prepareEditorInBackground(dBEditorConfig);
        }

        @Override
        public void prepareObjectForEditor(DBEditorConfig dBEditorConfig, List<Navigable> list) throws DBException {
            this.m_delegate.prepareObjectForEditor(dBEditorConfig, list);
        }

        @Override
        protected void prepareObjectForNavigable(DBEditorConfig dBEditorConfig, Navigable navigable) throws DBException {
            this.m_delegate.prepareObjectForNavigable(dBEditorConfig, navigable);
        }
    }

    @Deprecated
    public static interface HeaderPanel {
        public static final String HEADER_PANEL_KEY = HeaderPanel.class.getName();
        public static final String DEFAULT_PANEL_KEY = "DEFAULT_PANEL";

        public void addHeaderPanelListener(HeaderPanelListener var1);

        public boolean removeHeaderPanelListener(HeaderPanelListener var1);

        public void validatePanelChange(TraversableContext var1) throws TraversalException;
    }

    @Deprecated
    public static interface HeaderPanelListener {
        public void panelSetChange(String var1, Navigable[] var2) throws TraversalException;
    }

    @FunctionalInterface
    public static interface PanelSetChangeValidator {
        public void validatePanelChange(TraversableContext var1) throws TraversalException;
    }

    @FunctionalInterface
    public static interface PanelSetChanger {
        public void panelSetChange(Navigable[] var1, PanelSetChangeValidator var2) throws TraversalException;
    }
}

